/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.utils.CSTransformUtils;

public class MapCSBean {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.MAPVIEWER);
    private final String name = "MapCSBean";
    private static Class<MapCSBean> thisClass = MapCSBean.class;
    private static Class<?>[] params = new Class[4];
    static HashMap<String, Method> cache;

    public static Method getTransformMethod(String fromSrid, String toSrid) throws SecurityException, NoSuchMethodException {
        String methodName = "from_" + fromSrid + "_to_" + toSrid;
        Method m = cache.get(methodName);
        if (m == null) {
            m = thisClass.getDeclaredMethod(methodName, params);
            cache.put(methodName, m);
        }
        return m;
    }

    public static void from_8307_to_3857(double x, double y, double z, double[] out) {
        CSTransformUtils.toGoogleMercator(x, y, out);
    }

    public static void from_3857_to_8307(double x, double y, double z, double[] out) {
        CSTransformUtils.inverseGoogleMercator(x, y, out);
    }

    public static boolean supported(int fromSrid, int toSrid) {
        if (fromSrid == 8307 && toSrid == 3857) {
            return true;
        }
        return fromSrid == 3857 && toSrid == 8307;
    }

    public static boolean supported(String fromSrid, String toSrid) {
        return MapCSBean.supported(Integer.parseInt(fromSrid), Integer.parseInt(toSrid));
    }

    public static void main(String[] args) {
    }

    static {
        MapCSBean.params[0] = Double.TYPE;
        MapCSBean.params[1] = Double.TYPE;
        MapCSBean.params[2] = Double.TYPE;
        try {
            MapCSBean.params[3] = Class.forName("[D");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cache = new HashMap();
    }
}

