/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.util;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class EPSG2SDO {
    private static HashMap epsg_sdo_ids = null;

    public static void resetMappings() {
        if (epsg_sdo_ids != null) {
            epsg_sdo_ids.clear();
        }
        epsg_sdo_ids = null;
        EPSG2SDO.createSRSMap();
    }

    private static void createSRSMap() {
        if (epsg_sdo_ids == null) {
            epsg_sdo_ids = new HashMap(100);
            epsg_sdo_ids.put("3857", "3857");
            epsg_sdo_ids.put("3875", "3857");
            epsg_sdo_ids.put("4326", "8307");
            epsg_sdo_ids.put("4269", "8265");
            epsg_sdo_ids.put("4267", "8260");
            epsg_sdo_ids.put("4202", "81920");
            epsg_sdo_ids.put("4203", "81921");
            epsg_sdo_ids.put("20248", "81922");
            epsg_sdo_ids.put("20249", "81924");
            epsg_sdo_ids.put("20250", "81926");
            epsg_sdo_ids.put("20251", "81928");
            epsg_sdo_ids.put("20252", "81930");
            epsg_sdo_ids.put("20253", "81932");
            epsg_sdo_ids.put("20254", "81934");
            epsg_sdo_ids.put("20255", "81936");
            epsg_sdo_ids.put("20256", "81938");
            epsg_sdo_ids.put("20257", "81940");
            epsg_sdo_ids.put("20258", "81942");
            epsg_sdo_ids.put("20348", "81923");
            epsg_sdo_ids.put("20349", "81925");
            epsg_sdo_ids.put("20350", "81927");
            epsg_sdo_ids.put("20351", "81929");
            epsg_sdo_ids.put("20352", "81931");
            epsg_sdo_ids.put("20353", "81933");
            epsg_sdo_ids.put("20354", "81935");
            epsg_sdo_ids.put("20355", "81937");
            epsg_sdo_ids.put("20356", "81939");
            epsg_sdo_ids.put("20357", "81941");
            epsg_sdo_ids.put("20358", "81943");
            epsg_sdo_ids.put("23028", "82323");
            epsg_sdo_ids.put("23029", "82328");
            epsg_sdo_ids.put("23030", "82337");
            epsg_sdo_ids.put("23031", "82340");
            epsg_sdo_ids.put("23032", "82343");
            epsg_sdo_ids.put("23033", "82346");
            epsg_sdo_ids.put("23034", "82349");
            epsg_sdo_ids.put("23035", "82352");
            epsg_sdo_ids.put("23036", "82355");
            epsg_sdo_ids.put("23037", "82358");
            epsg_sdo_ids.put("23038", "82361");
            epsg_sdo_ids.put("8307", "4326");
            epsg_sdo_ids.put("8265", "4269");
            epsg_sdo_ids.put("8260", "4267");
            epsg_sdo_ids.put("81920", "4202");
            epsg_sdo_ids.put("81921", "4203");
            epsg_sdo_ids.put("81922", "20248");
            epsg_sdo_ids.put("81924", "20249");
            epsg_sdo_ids.put("81926", "20250");
            epsg_sdo_ids.put("81928", "20251");
            epsg_sdo_ids.put("81930", "20252");
            epsg_sdo_ids.put("81932", "20253");
            epsg_sdo_ids.put("81934", "20254");
            epsg_sdo_ids.put("81936", "20255");
            epsg_sdo_ids.put("81938", "20256");
            epsg_sdo_ids.put("81940", "20257");
            epsg_sdo_ids.put("81942", "20258");
            epsg_sdo_ids.put("81923", "20348");
            epsg_sdo_ids.put("81925", "20349");
            epsg_sdo_ids.put("81927", "20350");
            epsg_sdo_ids.put("81929", "20351");
            epsg_sdo_ids.put("81931", "20352");
            epsg_sdo_ids.put("81933", "20353");
            epsg_sdo_ids.put("81935", "20354");
            epsg_sdo_ids.put("81937", "20355");
            epsg_sdo_ids.put("81939", "20356");
            epsg_sdo_ids.put("81941", "20357");
            epsg_sdo_ids.put("81943", "20358");
            epsg_sdo_ids.put("82323", "23028");
            epsg_sdo_ids.put("82328", "23029");
            epsg_sdo_ids.put("82337", "23030");
            epsg_sdo_ids.put("82340", "23031");
            epsg_sdo_ids.put("82343", "23032");
            epsg_sdo_ids.put("82346", "23033");
            epsg_sdo_ids.put("82349", "23034");
            epsg_sdo_ids.put("82352", "23035");
            epsg_sdo_ids.put("82355", "23036");
            epsg_sdo_ids.put("82358", "23037");
            epsg_sdo_ids.put("82361", "23038");
            epsg_sdo_ids.put("102100", "3857");
            epsg_sdo_ids.put("900913", "3857");
        }
    }

    public static String EPSGtoSDO(String epsg_srid) {
        String sdo_srid = null;
        if (epsg_srid == null || epsg_srid.length() == 0) {
            return null;
        }
        sdo_srid = (String)epsg_sdo_ids.get(epsg_srid);
        if (sdo_srid == null) {
            return epsg_srid;
        }
        return sdo_srid;
    }

    public static String SDOtoEPSG(String sdo_srid) {
        String epsg_srid = null;
        if (sdo_srid == null || sdo_srid.length() == 0) {
            return null;
        }
        epsg_srid = (String)epsg_sdo_ids.get(sdo_srid);
        if (epsg_srid == null) {
            return null;
        }
        return epsg_srid;
    }

    public static String NS_EPSGtoSDO(String epsg_ns_srid) {
        String sdo_ns_srid = null;
        String epsg_srid = null;
        String sdo_srid = null;
        if (epsg_ns_srid == null || epsg_ns_srid.length() < 6) {
            return null;
        }
        epsg_srid = epsg_ns_srid.substring(5);
        if (epsg_srid == null || epsg_srid.length() < 6) {
            return null;
        }
        sdo_srid = (String)epsg_sdo_ids.get(epsg_srid);
        if (sdo_srid == null) {
            return null;
        }
        sdo_ns_srid = "SDO:" + sdo_srid;
        return sdo_ns_srid;
    }

    public static String NS_SDOtoEPSG(String sdo_ns_srid) {
        String epsg_ns_srid = null;
        String epsg_srid = null;
        String sdo_srid = null;
        if (sdo_ns_srid == null || sdo_ns_srid.length() < 5) {
            return null;
        }
        sdo_srid = sdo_ns_srid.substring(4);
        if (sdo_srid == null || sdo_srid.length() == 0) {
            return null;
        }
        epsg_srid = (String)epsg_sdo_ids.get(sdo_srid);
        if (epsg_srid == null) {
            return null;
        }
        epsg_ns_srid = "EPSG:" + epsg_srid;
        return epsg_ns_srid;
    }

    public static int loadFromCustomMapFile(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            Properties p = new Properties();
            p.load(fis);
            int i = 0;
            Enumeration<?> enumer = p.propertyNames();
            while (enumer.hasMoreElements()) {
                String sdoSrid = (String)enumer.nextElement();
                String epsgSrid = p.getProperty(sdoSrid);
                epsg_sdo_ids.put(sdoSrid, epsgSrid);
                epsg_sdo_ids.put(epsgSrid, sdoSrid);
                ++i;
            }
            fis.close();
            return i;
        }
        catch (Exception e) {
            System.err.println("error opening WMS srid map file: " + file);
            return 0;
        }
    }

    public static boolean addSRSMapping(String epsg, String sdo) {
        if (epsg == null || sdo == null) {
            return false;
        }
        epsg_sdo_ids.put(epsg, sdo);
        epsg_sdo_ids.put(sdo, epsg);
        return true;
    }

    static {
        EPSG2SDO.createSRSMap();
    }
}

