/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class DotDensityStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 8273185276122465955L;
    protected static int MAX_DOTS = 1500;
    SizeDefinition2D dotSize = new SizeDefinition2D(6.0, 6.0, null);
    String markerStyleName = null;

    public DotDensityStyleModel() {
        this.type = 9;
    }

    @Override
    public Object clone() {
        DotDensityStyleModel obj = (DotDensityStyleModel)super.clone();
        obj.setDotSize(this.dotSize);
        return obj;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    public void setDotSize(SizeDefinition2D size) {
        this.dotSize = new SizeDefinition2D(6.0, 6.0, null);
        if (size == null) {
            return;
        }
        this.dotSize.setSize(size.getWidth(), size.getHeight());
        this.dotSize.setUnit(size.getUnit());
    }

    public SizeDefinition2D getDotSize() {
        return this.dotSize;
    }

    @Override
    public String toXMLString() {
        String wStr = StyleUtils.getUSLocaleFormat(this.dotSize.getWidth());
        wStr = StyleUtils.cleanDecimalZeros(wStr, 1);
        String hStr = StyleUtils.getUSLocaleFormat(this.dotSize.getHeight());
        hStr = StyleUtils.cleanDecimalZeros(hStr, 1);
        String unit = "";
        if (this.dotSize.getUnit() != null && !this.dotSize.getUnit().equalsIgnoreCase("px")) {
            unit = this.dotSize.getUnit();
        }
        if (this.dotSize.isPixelUnit()) {
            wStr = String.valueOf((int)this.dotSize.getWidth());
            hStr = String.valueOf((int)this.dotSize.getHeight());
        }
        String ms = this.markerStyleName == null ? "" : "MarkerStyle=\"" + XMLUtil.replaceXMLEntities(this.markerStyleName) + "\" ";
        String xml = "<?xml version=\"1.0\" ?>\n";
        xml = xml + "<AdvancedStyle>\n    <DotDensityStyle " + ms + "DotWidth=\"" + wStr + unit + "\" DotHeight=\"" + hStr + unit + "\" />\n" + "</AdvancedStyle>\n";
        return xml;
    }

    public static void setMaxDots(int mAX_DOTS) {
        MAX_DOTS = mAX_DOTS;
    }

    public static int getMaxDots() {
        return MAX_DOTS;
    }

    public void setDotWidth(int dotWidth) {
        this.dotSize.setWidth(dotWidth);
    }

    public void setDotWidth(double dotWidth) {
        this.dotSize.setWidth(dotWidth);
    }

    public int getDotWidth() {
        return (int)this.dotSize.getWidth();
    }

    public double getDoubleDotWidth() {
        return this.dotSize.getWidth();
    }

    public void setDotHeight(int dotHeight) {
        this.dotSize.setHeight(dotHeight);
    }

    public void setDotHeight(double dotHeight) {
        this.dotSize.setHeight(dotHeight);
    }

    public int getDotHeight() {
        return (int)this.dotSize.getHeight();
    }

    public double getDoubleDotHeight() {
        return this.dotSize.getHeight();
    }

    public void setDotSize(int width, int height) {
        this.dotSize.setSize(width, height);
    }

    public void setDotSize(double width, double height) {
        this.dotSize.setSize(width, height);
    }

    public String getDotUnit() {
        return this.dotSize.getUnit();
    }

    public void setDotUnit(String unit) {
        this.dotSize.setUnit(unit);
    }

    public void setMarkerStyleName(String markerStyleName) {
        this.markerStyleName = markerStyleName;
    }

    public String getMarkerStyleName() {
        return this.markerStyleName;
    }

    @Override
    public String[] getStyleDependency() {
        String[] deps = null;
        if (this.markerStyleName != null) {
            deps = new String[]{this.markerStyleName};
        }
        return deps;
    }
}

