/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.util.ArrayList;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.BucketSeries;

public class BucketStyleModel
extends AbstractBucketStyleModel {
    static final long serialVersionUID = -9141046439918195333L;

    public BucketStyleModel() {
        this.type = 9;
        this.bucketSeries = new BucketSeries();
    }

    public BucketStyleModel(BucketSeries bs) {
        this.type = 9;
        this.bucketSeries = bs;
    }

    @Override
    public Object clone() {
        BucketStyleModel obj = (BucketStyleModel)super.clone();
        return obj;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    @Override
    public String toXMLString() {
        String xmlDef = "<?xml version=\"1.0\" ?>\n";
        xmlDef = xmlDef + "<AdvancedStyle>\n   <BucketStyle>\n";
        xmlDef = xmlDef + this.bucketSeries.toXMLString();
        xmlDef = xmlDef + "\n   </BucketStyle>\n</AdvancedStyle>\n";
        return xmlDef;
    }

    @Override
    public String[] getStyleDependency() {
        ArrayList<String> depStyles = new ArrayList<String>();
        if (this.bucketSeries == null) {
            return null;
        }
        if (this.bucketSeries.getDefaultRenderStyleName() != null) {
            depStyles.add(this.bucketSeries.getDefaultRenderStyleName());
        }
        if (this.bucketSeries.getDefaultLabelStyleName() != null) {
            depStyles.add(this.bucketSeries.getDefaultLabelStyleName());
        }
        for (int i = 0; i < this.bucketSeries.size(); ++i) {
            Bucket bkt = this.bucketSeries.getBucket(i);
            if (bkt.getRenderStyleName() != null && !depStyles.contains(bkt.getRenderStyleName())) {
                depStyles.add(bkt.getRenderStyleName());
            }
            if (bkt.getLabelStyleName() == null || depStyles.contains(bkt.getLabelStyleName())) continue;
            depStyles.add(bkt.getLabelStyleName());
        }
        if (depStyles.size() == 0) {
            return null;
        }
        return depStyles.toArray(new String[depStyles.size()]);
    }
}

