/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import oracle.mapviewer.share.TopologyEdge;
import oracle.mapviewer.share.TopologyFace;
import oracle.mapviewer.share.TopologyNode;

public class TopologyPrimitives {
    private Vector<TopologyNode> nodes = new Vector();
    private Vector<TopologyEdge> edges = new Vector();
    private Vector<TopologyFace> faces = new Vector();

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
        this.faces.clear();
    }

    public void addNode(TopologyNode node) {
        if (node == null) {
            return;
        }
        this.nodes.add(node);
    }

    public boolean removeNode(TopologyNode node) {
        if (node == null) {
            return false;
        }
        return this.nodes.remove(node);
    }

    public TopologyNode[] getNodes() {
        if (this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.toArray(new TopologyNode[this.nodes.size()]);
    }

    public void addEdge(TopologyEdge edge) {
        if (edge == null) {
            return;
        }
        this.edges.add(edge);
    }

    public boolean removeEdge(TopologyEdge edge) {
        if (edge == null) {
            return false;
        }
        return this.edges.remove(edge);
    }

    public TopologyEdge[] getEdges() {
        if (this.edges.size() == 0) {
            return null;
        }
        return this.edges.toArray(new TopologyEdge[this.edges.size()]);
    }

    public void addFace(TopologyFace face) {
        if (face == null) {
            return;
        }
        this.faces.add(face);
    }

    public boolean removeFace(TopologyFace face) {
        if (face == null) {
            return false;
        }
        return this.faces.remove(face);
    }

    public TopologyFace[] getFaces() {
        if (this.faces.size() == 0) {
            return null;
        }
        return this.faces.toArray(new TopologyFace[this.faces.size()]);
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public int getNumberOfEdges() {
        return this.edges.size();
    }

    public int getNumberOfFaces() {
        return this.faces.size();
    }

    public int getNumberOfPrimitives() {
        return this.getNumberOfNodes() + this.getNumberOfEdges() + this.getNumberOfFaces();
    }

    public TopologyFace getFace(int index) {
        if (index < 0 || index >= this.faces.size()) {
            return null;
        }
        return this.faces.get(index);
    }

    public TopologyEdge getEdge(int index) {
        if (index < 0 || index >= this.edges.size()) {
            return null;
        }
        return this.edges.get(index);
    }

    public TopologyNode getNode(int index) {
        if (index < 0 || index >= this.nodes.size()) {
            return null;
        }
        return this.nodes.get(index);
    }

    public Rectangle2D getMBR() {
        int i;
        Rectangle2D totalMBR = null;
        for (i = 0; i < this.faces.size(); ++i) {
            Rectangle2D faceMBR = this.faces.get(i).getMBR();
            if (faceMBR == null) continue;
            if (totalMBR == null) {
                totalMBR = new Rectangle2D.Double();
            }
            totalMBR.add(faceMBR);
        }
        for (i = 0; i < this.edges.size(); ++i) {
            Rectangle2D edgeMBR = this.edges.get(i).getMBR();
            if (edgeMBR == null) continue;
            if (totalMBR == null) {
                totalMBR = new Rectangle2D.Double();
            }
            totalMBR.add(edgeMBR);
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            Rectangle2D nodeMBR = this.nodes.get(i).getMBR();
            if (nodeMBR == null) continue;
            if (totalMBR == null) {
                totalMBR = new Rectangle2D.Double();
            }
            totalMBR.add(nodeMBR);
        }
        return totalMBR;
    }

    public int getSrid() {
        if (this.getNumberOfPrimitives() == 0) {
            return 0;
        }
        if (this.nodes.size() > 0 && this.nodes.get(0).getGeometry() != null) {
            return this.nodes.get(0).getGeometry().getSRID();
        }
        if (this.edges.size() > 0 && this.edges.get(0).getGeometry() != null) {
            return this.edges.get(0).getGeometry().getSRID();
        }
        return 0;
    }
}

