/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;

public class OMSException
extends Exception {
    public int severityLevel = 0;
    public Date currentTime = null;
    public String description = "";
    public Throwable detail = null;

    public OMSException() {
        this.currentTime = new Date();
    }

    public OMSException(String message) {
        super(message);
        this.currentTime = new Date();
    }

    public OMSException(Throwable ex) {
        this.detail = ex;
        this.currentTime = new Date();
    }

    public OMSException(String message, Throwable ex) {
        super(message);
        this.detail = ex;
        this.currentTime = new Date();
    }

    @Override
    public String toString() {
        String val = "Message:" + this.getMessage() + "\n";
        val = val + this.currentTime.toString() + "\n";
        val = val + "Severity: " + this.severityLevel + "\n";
        val = val + "Description: " + this.description;
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        if (this.detail == null) {
            super.printStackTrace(ps);
        } else {
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.println(this);
                this.detail.printStackTrace(ps);
            }
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        if (this.detail == null) {
            super.printStackTrace(pw);
        } else {
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.println(this);
                this.detail.printStackTrace(pw);
            }
        }
    }
}

