/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.util.ArrayList;
import oracle.mapviewer.share.Field;

public class FieldArray
extends Field {
    private ArrayList<Field> fields = new ArrayList();
    private String SQLfieldType = null;

    public FieldArray(String[] values, String type) {
        this.isArray = true;
        this.type = Field.getFieldType(type);
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            Field f = Field.createField(values[i], type);
            this.fields.add(f);
            this.type = f.getType();
        }
    }

    @Override
    public Object clone() {
        FieldArray fa = (FieldArray)super.clone();
        fa.fields = new ArrayList();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field f = (Field)this.fields.get(i).clone();
            fa.fields.add(f);
        }
        return fa;
    }

    public boolean addField(String value, String type) {
        if (value == null) {
            return false;
        }
        String ftype = type;
        if (type == null) {
            ftype = "string";
        }
        if (this.fields.size() > 0 && !this.getShortJavaTypeName().equalsIgnoreCase(ftype)) {
            return false;
        }
        Field f = Field.createField(value, type);
        this.fields.add(f);
        this.type = f.getType();
        return true;
    }

    @Override
    public String toString() {
        if (this.fields.size() == 0) {
            return null;
        }
        String farray = this.toString(0);
        for (int i = 1; i < this.fields.size(); ++i) {
            farray = farray + "," + this.toString(i);
        }
        return farray;
    }

    public String toString(int index) {
        if (index < 0 || index >= this.fields.size()) {
            return null;
        }
        Field f = this.fields.get(index);
        if (f == null) {
            return null;
        }
        return f.toString();
    }

    public String[] toStringArray() {
        if (this.fields.size() == 0) {
            return null;
        }
        String[] strs = new String[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            strs[i] = this.toString(i);
        }
        return strs;
    }

    public int getSize() {
        return this.fields.size();
    }

    public void clear() {
        this.fields.clear();
        this.type = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        FieldArray obj = null;
        try {
            obj = (FieldArray)o;
        }
        catch (Exception e) {
            return false;
        }
        if (this.getSize() != obj.getSize()) {
            return false;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            Field f2;
            Field f1 = this.fields.get(i);
            if (f1.equals(f2 = obj.fields.get(i))) continue;
            return false;
        }
        return true;
    }

    public String getSQLfieldType() {
        return this.SQLfieldType;
    }

    public void setSQLfieldType(String sqlType) {
        this.SQLfieldType = sqlType;
    }
}

