/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

public class Field
implements Serializable,
Cloneable,
Comparable {
    static final long serialVersionUID = -7506230808640711705L;
    private static byte _KEY = 1;
    private static byte _LABEL = (byte)4;
    private static byte _NODATA = (byte)8;
    public static final int T_BYTE = 1;
    public static final int T_SHORT = 2;
    public static final int T_INT = 3;
    public static final int T_LONG = 4;
    public static final int T_FLOAT = 5;
    public static final int T_DOUBLE = 6;
    public static final int T_CHAR = 7;
    public static final int T_STRING = 8;
    public static final int T_BOOLEAN = 9;
    public static final int T_DATE = 10;
    protected static String[] typeName = new String[]{"invalid-type", "byte", "short", "int", "long", "float", "double", "char", "string", "boolean", "date"};
    protected byte flag = 0;
    protected byte[] vbytes;
    protected String svalue;
    protected int type;
    protected String name;
    protected String displayName;
    protected String[] contexts = null;
    protected boolean isArray = false;

    public Object clone() {
        try {
            Field f = (Field)super.clone();
            if (this.vbytes != null) {
                f.vbytes = new byte[this.vbytes.length];
                System.arraycopy(this.vbytes, 0, f.vbytes, 0, this.vbytes.length);
            }
            return f;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public Field() {
    }

    public Field(String str) {
        this.svalue = str;
        this.vbytes = null;
        this.setType(8);
    }

    public Field(int i) {
        this.setInt(i);
    }

    public Field(double d) {
        this.setDouble(d);
    }

    public static Field createField(String value, String type) {
        Field f = new Field();
        if (type == null || type.length() == 0) {
            f.setString(value);
            return f;
        }
        if (value == null) {
            return f;
        }
        if ("string".equals(type = type.toLowerCase())) {
            f.setString(value);
        } else if ("int".equals(type) || "integer".equals(type)) {
            f.setInt(Integer.parseInt(value));
        } else if ("float".equals(type)) {
            f.setFloat(Float.parseFloat(value));
        } else if ("double".equals(type)) {
            f.setDouble(Double.parseDouble(value));
        } else if ("long".equals(type)) {
            f.setLong(Long.parseLong(value));
        } else if ("char".equals(type)) {
            f.setChar(value.charAt(0));
        } else if ("short".equals(type)) {
            f.setShort(Short.parseShort(value));
        } else if ("byte".equals(type)) {
            f.setByte(Byte.parseByte(value));
        } else if ("date".equals(type)) {
            f.setDate(Long.parseLong(value));
        } else if ("boolean".equals(type)) {
            f.setBoolean(Boolean.parseBoolean(value));
        }
        return f;
    }

    public static int getFieldType(String type) {
        if (type == null) {
            return 0;
        }
        if ("string".equals(type = type.toLowerCase())) {
            return 8;
        }
        if ("int".equals(type) || "integer".equals(type)) {
            return 3;
        }
        if ("float".equals(type)) {
            return 5;
        }
        if ("double".equals(type)) {
            return 6;
        }
        if ("long".equals(type)) {
            return 4;
        }
        if ("char".equals(type)) {
            return 7;
        }
        if ("short".equals(type)) {
            return 2;
        }
        if ("byte".equals(type)) {
            return 1;
        }
        if ("date".equals(type)) {
            return 10;
        }
        if ("boolean".equals(type)) {
            return 9;
        }
        return 0;
    }

    public Field setByte(byte v) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = new byte[]{v};
        this.svalue = null;
        this.setType(1);
        return this;
    }

    public Field setBoolean(boolean v) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = new byte[]{(byte)(v ? 1 : 0)};
        this.svalue = null;
        this.setType(9);
        return this;
    }

    public Field setShort(int v) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        this.svalue = null;
        this.setType(2);
        return this;
    }

    private static byte[] getIntBits(int v) {
        return new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
    }

    public Field setInt(int v) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = Field.getIntBits(v);
        this.svalue = null;
        this.setType(3);
        return this;
    }

    public Field setChar(int v) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        this.svalue = null;
        this.setType(7);
        return this;
    }

    private static byte[] getLongBits(long v) {
        return new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
    }

    public Field setLong(long v) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = Field.getLongBits(v);
        this.svalue = null;
        this.setType(4);
        return this;
    }

    public Field setFloat(float v) {
        if (this.isArray) {
            return null;
        }
        int _v = Float.floatToIntBits(v);
        this.vbytes = Field.getIntBits(_v);
        this.svalue = null;
        this.setType(5);
        return this;
    }

    public Field setDouble(double v) {
        if (this.isArray) {
            return null;
        }
        long _v = Double.doubleToLongBits(v);
        this.vbytes = Field.getLongBits(_v);
        this.svalue = null;
        this.setType(6);
        return this;
    }

    public Field setString(String v) {
        if (this.isArray) {
            return null;
        }
        this.svalue = v;
        this.vbytes = null;
        this.setType(8);
        return this;
    }

    public Field setDate(long v) {
        if (this.isArray) {
            return null;
        }
        this.vbytes = Field.getLongBits(v);
        this.svalue = null;
        this.setType(10);
        return this;
    }

    public Field setDate(Date date) {
        return this.setDate(date.getTime());
    }

    public boolean getBoolean() {
        if (this.isArray || this.vbytes == null) {
            return false;
        }
        return this.vbytes[0] != 0;
    }

    public char getChar() {
        if (this.isArray || this.vbytes == null) {
            return '\u0000';
        }
        byte ch1 = this.vbytes[0];
        byte ch2 = this.vbytes[1];
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public byte getByte() {
        if (this.isArray || this.vbytes == null) {
            return -128;
        }
        return this.vbytes[0];
    }

    public short getShort() {
        if (this.isArray || this.vbytes == null) {
            return Short.MIN_VALUE;
        }
        byte ch1 = this.vbytes[0];
        byte ch2 = this.vbytes[1];
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int getInt() {
        if (this.isArray || this.vbytes == null) {
            return Integer.MIN_VALUE;
        }
        int ch1 = this.vbytes[0] & 0xFF;
        int ch2 = this.vbytes[1] & 0xFF;
        int ch3 = this.vbytes[2] & 0xFF;
        int ch4 = this.vbytes[3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long getLong() {
        if (this.isArray || this.vbytes == null) {
            return Long.MIN_VALUE;
        }
        return ((long)this.vbytes[0] << 56) + ((long)(this.vbytes[1] & 0xFF) << 48) + ((long)(this.vbytes[2] & 0xFF) << 40) + ((long)(this.vbytes[3] & 0xFF) << 32) + ((long)(this.vbytes[4] & 0xFF) << 24) + (long)((this.vbytes[5] & 0xFF) << 16) + (long)((this.vbytes[6] & 0xFF) << 8) + (long)((this.vbytes[7] & 0xFF) << 0);
    }

    public float getFloat() {
        if (this.isArray || this.vbytes == null) {
            return Float.NaN;
        }
        return Float.intBitsToFloat(this.getInt());
    }

    public double getDouble() {
        if (this.isArray || this.vbytes == null) {
            return Double.NaN;
        }
        return Double.longBitsToDouble(this.getLong());
    }

    public String getString() {
        return this.svalue;
    }

    public long getDate() {
        return this.getLong();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int _type) {
        if (_type < 0 || _type > 10) {
            throw new IllegalArgumentException("Trying to set an invalid field type (" + _type + ").");
        }
        this.type = _type;
    }

    public void setKey(boolean v) {
        this.flag = v ? (byte)(this.flag | _KEY) : (byte)(this.flag & 15 - _KEY);
    }

    public boolean isKey() {
        return (this.flag & _KEY) > 0;
    }

    public boolean isNumeric() {
        return this.type == 3 || this.type == 6 || this.type == 5 || this.type == 2 || this.type == 1 || this.type == 4;
    }

    public double convertToDouble() {
        if (this.isNoData() || this.isArray) {
            return Double.NaN;
        }
        switch (this.type) {
            case 1: {
                return this.getByte();
            }
            case 2: {
                return this.getShort();
            }
            case 3: {
                return this.getInt();
            }
            case 4: {
                return this.getLong();
            }
            case 5: {
                return this.getFloat();
            }
            case 6: {
                return this.getDouble();
            }
        }
        return Double.NaN;
    }

    public Field setNameAndKey(String name, boolean isKey, String displayName) {
        this.name = name;
        this.setKey(isKey);
        this.displayName = displayName;
        return this;
    }

    public Field setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String dname) {
        this.displayName = dname;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setLabelText(boolean v) {
        this.flag = v ? (byte)(this.flag | _LABEL) : (byte)(this.flag & 255 - _LABEL);
    }

    public boolean isLabelText() {
        return (this.flag & _LABEL) > 0;
    }

    public Object getValue() {
        return this.toString();
    }

    public String toString() {
        if (this.isNoData()) {
            return "nodata";
        }
        String s = "";
        switch (this.type) {
            case 1: {
                return s + this.getByte();
            }
            case 2: {
                return s + this.getShort();
            }
            case 3: {
                return s + this.getInt();
            }
            case 4: {
                return s + this.getLong();
            }
            case 5: {
                return s + this.getFloat();
            }
            case 7: {
                return s + this.getChar();
            }
            case 6: {
                return this.doubleToString(this.getDouble());
            }
            case 9: {
                return s + this.getBoolean();
            }
            case 8: {
                return this.getString();
            }
            case 10: {
                return s + DateFormat.getDateTimeInstance().format(new Date(this.getDate()));
            }
        }
        return s;
    }

    private String doubleToString(double value) {
        if ((double)((int)value) == value) {
            return Integer.toString((int)value);
        }
        return Double.toString(value);
    }

    public String getShortJavaTypeName() {
        return typeName[this.type];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Field obj = null;
        try {
            obj = (Field)o;
        }
        catch (Exception e) {
            return false;
        }
        boolean res = false;
        res = (this.name == obj.name || this.name != null && this.name.equals(obj.name)) && (this.displayName == obj.displayName || this.displayName != null && this.displayName.equals(obj.displayName)) && this.bytesEqual(obj.vbytes) && (this.svalue == obj.svalue || this.svalue != null && this.svalue.equals(obj.svalue)) && this.type == obj.type && this.flag == obj.flag;
        return res;
    }

    private boolean bytesEqual(byte[] bits) {
        if (this.vbytes == null && bits == null) {
            return true;
        }
        if (this.vbytes != null && bits != null) {
            if (this.vbytes.length != bits.length) {
                return false;
            }
            for (int i = 0; i < this.vbytes.length; ++i) {
                if (this.vbytes[i] == bits[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        Field fo = (Field)o;
        if (fo == null) {
            return this.isNoData() ? 0 : 1;
        }
        if (fo.isNoData()) {
            return this.isNoData() ? 0 : 1;
        }
        if (this.isNoData() || this.isNoData()) {
            return -1;
        }
        switch (this.type) {
            case 8: {
                if (this.svalue == null) {
                    return fo.svalue == null ? 0 : -1;
                }
                if (fo.svalue == null) {
                    return -1;
                }
                return this.svalue.compareTo(fo.svalue);
            }
            case 10: {
                long t1 = this.getDate();
                long t2 = fo.getDate();
                return t1 > t2 ? 1 : (t1 < t2 ? -1 : 0);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                double d1 = this.convertToDouble();
                double d2 = fo.convertToDouble();
                return d1 > d2 ? 1 : (d1 < d2 ? -1 : 0);
            }
            case 7: {
                char c12 = this.getChar();
                char c2 = fo.getChar();
                return c12 > c2 ? 1 : (c12 < c2 ? -1 : 0);
            }
            case 1: 
            case 9: {
                byte b1 = this.getByte();
                byte b2 = fo.getByte();
                return b1 > b2 ? 1 : (b1 < b2 ? -1 : 0);
            }
        }
        return 1;
    }

    public void setContexts(String[] param) {
        this.contexts = param;
    }

    public String[] getContexts() {
        return this.contexts;
    }

    public boolean isNoData() {
        return (this.flag & _NODATA) > 0;
    }

    public void setNoData() {
        this.flag = (byte)(this.flag | _NODATA);
        this.svalue = null;
        this.vbytes = null;
        this.type = 0;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public byte getFlag() {
        return this.flag;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public byte[] getVbytes() {
        return this.vbytes;
    }

    public void setVbytes(byte[] vbytes) {
        this.vbytes = vbytes;
    }

    public String getSvalue() {
        return this.svalue;
    }

    public void setSvalue(String svalue) {
        this.svalue = svalue;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }
}

