/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MPHttpServletRequest {
    HttpServletRequest request = null;
    boolean multiParts = false;
    String callBackId = null;
    int totalPartNumber = 0;
    ArrayList partsList = new ArrayList(50);
    PartComparator comparator = new PartComparator();
    Map parameters = null;
    int partNumber = -1;
    long timestamp = System.currentTimeMillis();

    public MPHttpServletRequest(HttpServletRequest req, String jsCallBackId) {
        this.callBackId = jsCallBackId;
        this.request = req;
        String pnStr = this.request.getParameter("pn");
        if (pnStr != null) {
            this.multiParts = true;
            this.mergeRequest(req);
        } else {
            this.parameters = req.getParameterMap();
        }
    }

    public void mergeRequest(HttpServletRequest req) {
        this.request = req;
        String pnStr = req.getParameter("pn");
        boolean lastPart = false;
        if (pnStr.startsWith("e")) {
            pnStr = pnStr.substring(1);
            lastPart = true;
        }
        this.partNumber = Integer.parseInt(pnStr);
        if (lastPart) {
            this.totalPartNumber = this.partNumber;
        }
        Object[] partInfo = new Object[]{new Integer(this.partNumber), new HashMap()};
        Map map = req.getParameterMap();
        Set set = map.entrySet();
        for (Map.Entry e : set) {
            String[] val = (String[])e.getValue();
            ((HashMap)partInfo[1]).put(e.getKey(), val);
        }
        this.partsList.add(partInfo);
        if (this.partsList.size() == this.totalPartNumber) {
            this.processParameters();
        }
    }

    public String getJSCallBackId() {
        return this.callBackId;
    }

    public HttpServletRequest getOriginalRequest() {
        return this.request;
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public String getParameter(String key) {
        if (this.parameters != null) {
            Object p = this.parameters.get(key);
            if (p == null) {
                return null;
            }
            if (p instanceof String[]) {
                return ((String[])p)[0];
            }
            if (p instanceof String) {
                return (String)p;
            }
            return null;
        }
        if (this.request != null) {
            return this.request.getParameter(key);
        }
        return null;
    }

    public boolean isInstanceIdRequest() {
        return !this.multiParts && this.request.getParameter("getinstid") != null;
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public HttpSession getSession(boolean flag) {
        return this.request.getSession(flag);
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public long getDateHeader(String arg) {
        return this.request.getDateHeader(arg);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public String getHeader(String arg) {
        return this.request.getHeader(arg);
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public boolean isMultiPartsRequest() {
        return this.multiParts;
    }

    public boolean isEndOfMultiPartsRequest() {
        String partNumber = this.request.getParameter("pn");
        return partNumber != null && partNumber.startsWith("e");
    }

    public boolean isComplete() {
        return this.multiParts && this.totalPartNumber == this.partsList.size();
    }

    public String getAllParameters() {
        StringBuilder sb = new StringBuilder(1024);
        Iterator it = null;
        it = this.parameters != null ? this.parameters.entrySet().iterator() : this.request.getParameterMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String[] value = (String[])entry.getValue();
            String valueString = value[0];
            sb.append((String)entry.getKey() + ": " + valueString + "\n");
        }
        return sb.toString();
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public long getAgeInSeconds() {
        return (System.currentTimeMillis() - this.timestamp) / 1000L;
    }

    private void processParameters() {
        Object[][] pArray = new Object[this.totalPartNumber][2];
        this.partsList.toArray((T[])pArray);
        Arrays.sort(pArray, this.comparator);
        this.parameters = (Map)pArray[0][1];
        for (int i = 1; i < pArray.length; ++i) {
            Map pMap = (Map)pArray[i][1];
            for (Map.Entry entry : pMap.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals("pn") || key.equals("callback_id")) continue;
                String[] val = (String[])entry.getValue();
                String[] pVal = (String[])this.parameters.get(key);
                if (pVal != null) {
                    pVal[0] = pVal[0] + val[0];
                    continue;
                }
                this.parameters.put(key, val);
            }
            pMap.clear();
            pArray[i][0] = null;
            pArray[i][1] = null;
        }
    }

    private class PartComparator
    implements Comparator {
        private PartComparator() {
        }

        public int compare(Object o1, Object o2) {
            Object[] p1 = (Object[])o1;
            Object[] p2 = (Object[])o2;
            if ((Integer)p1[0] == (Integer)p2[0]) {
                return 0;
            }
            if ((Integer)p1[0] < (Integer)p2[0]) {
                return -1;
            }
            return 1;
        }
    }
}

