/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.lbs.dataserver.MapDataRequest;
import oracle.mapviewer.share.FeatureGroup;
import oracle.mapviewer.share.SimpleFeatureI;
import oracle.mapviewer.share.SimpleGeometry;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRS;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Face;
import oracle.spatial.topo.Point2DD;
import oracle.spatial.topo.TopoFaceSplitInfo;
import oracle.spatial.topo.TopoPrimitivesMap;

public class GeometrySimplifier {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.MAPVIEWER);
    private TopoPrimitivesMap topology = null;
    private FeatureGroup features;
    private ArrayList<JGeometry> origGeometries = new ArrayList();
    private Hashtable<Integer, Boolean> geomToBeSimplified = new Hashtable();
    private Hashtable<Integer, int[]> lineGeomMap = new Hashtable();
    private Hashtable<Integer, int[]> polyGeomMap = new Hashtable();
    private Hashtable<Integer, Integer> edgeIndexMap = new Hashtable();
    private ArrayList<JGeometry> topoEdgeGeoms = null;
    private ArrayList<JGeometry> outGeometries;
    private Hashtable<Integer, Integer> faceGeomIndexMap = new Hashtable();
    private Hashtable<Integer, FaceSplitInfo> faceSplits = new Hashtable();
    private Hashtable<Integer, Boolean> usedFaces = new Hashtable();

    public GeometrySimplifier(FeatureGroup features) {
        try {
            this.topology = new TopoPrimitivesMap(10, 10, 10, 10);
        }
        catch (Exception ex) {
            log.warning("Unable to start topology class.");
            this.topology = null;
        }
        this.features = features;
    }

    private boolean validateGeometryForSimplification(JGeometry geom) {
        if (geom == null) {
            return false;
        }
        double[] gmbr = geom.getMBR();
        if (gmbr == null) {
            return false;
        }
        int gtype = geom.getType();
        if (gtype != 2 && gtype != 6 && gtype != 3 && gtype != 7 && gtype != 4) {
            return false;
        }
        if (gtype == 4) {
            JGeometry[] elems = geom.getElements();
            if (elems == null || elems.length == 0) {
                return false;
            }
            boolean hasPolygon = false;
            for (int i = 0; i < elems.length; ++i) {
                if (elems[i].getType() != 3) continue;
                hasPolygon = true;
                break;
            }
            if (!hasPolygon) {
                return false;
            }
        }
        return true;
    }

    public List<SimpleFeatureI> applySimplification(double threshold, int simplifyAlgorithm, SRS srs) {
        long startTime = System.currentTimeMillis();
        List<SimpleFeatureI> simpleFeatures = GeometrySimplifier.sortGeometryFeaturesByAreaDesc(this.features.getFeatures());
        Vector<JGeometry> geometries = new Vector<JGeometry>();
        Hashtable<String, String> unableFeats = new Hashtable<String, String>();
        for (int i = 0; i < simpleFeatures.size(); ++i) {
            SimpleFeatureI sf = simpleFeatures.get(i);
            SimpleGeometry simpleGeom = sf.getGeometry();
            JGeometry geom = null;
            if (simpleGeom != null) {
                geom = new JGeometry(simpleGeom.getGtype(), simpleGeom.getSrid(), simpleGeom.getElemInfo(), simpleGeom.getOrdinates());
            }
            if (this.validateGeometryForSimplification(geom)) {
                geometries.add(geom);
                continue;
            }
            unableFeats.put("" + i, "" + i);
        }
        ArrayList<JGeometry> geometriesToSimplify = new ArrayList<JGeometry>();
        ArrayList<JGeometry> areaGeometries = new ArrayList<JGeometry>();
        ArrayList<JGeometry> lineGeometries = new ArrayList<JGeometry>();
        Hashtable<Integer, JGeometry> collectionGeoms = new Hashtable<Integer, JGeometry>();
        for (int i = 0; i < geometries.size(); ++i) {
            JGeometry geom = (JGeometry)geometries.get(i);
            int gtype = geom.getType();
            if (gtype == 2 || gtype == 6) {
                lineGeometries.add(geom);
                continue;
            }
            if (gtype == 3 || gtype == 7) {
                areaGeometries.add(geom);
                continue;
            }
            if (gtype != 4) continue;
            JGeometry[] elems = geom.getElements();
            JGeometry g = null;
            for (int k = 0; k < elems.length; ++k) {
                int type = elems[k].getType();
                if (type != 3) continue;
                g = g == null ? new JGeometry(elems[k].getDimensions() * 1000 + 3, elems[k].getSRID(), elems[k].getElemInfo(), elems[k].getOrdinatesArray()) : JGeometryUtil.addPolygon(g, elems[k]);
            }
            collectionGeoms.put(new Integer(areaGeometries.size()), geom);
            areaGeometries.add(g);
        }
        this.buildTopology(areaGeometries);
        ArrayList<JGeometry> edgeGeometries = this.getTopologyEdgeGeometries();
        if (edgeGeometries != null) {
            for (int i = 0; i < edgeGeometries.size(); ++i) {
                geometriesToSimplify.add(edgeGeometries.get(i));
            }
        }
        if (lineGeometries.size() > 0) {
            for (int i = 0; i < lineGeometries.size(); ++i) {
                geometriesToSimplify.add((JGeometry)lineGeometries.get(i));
            }
        }
        JGeometry[] spGeoms = GeometrySimplifier.getSimplifiedGeometries(geometriesToSimplify, this.features.isGeodeticSrid(), threshold, simplifyAlgorithm, srs);
        this.outGeometries = new ArrayList();
        int topoedges = 0;
        if (edgeGeometries != null && edgeGeometries.size() > 0) {
            topoedges = edgeGeometries.size();
            ArrayList<JGeometry> simpliEdges = new ArrayList<JGeometry>();
            for (int i = 0; i < topoedges; ++i) {
                simpliEdges.add(spGeoms[i]);
            }
            ArrayList<JGeometry> polyGeometries = this.rebuildSimplifiedGeometries(simpliEdges);
            if (polyGeometries != null && polyGeometries.size() > 0) {
                for (int i = 0; i < polyGeometries.size(); ++i) {
                    this.outGeometries.add(polyGeometries.get(i));
                }
                if (collectionGeoms.size() > 0) {
                    Enumeration enumer = collectionGeoms.keys();
                    while (enumer.hasMoreElements()) {
                        Integer index = (Integer)enumer.nextElement();
                        JGeometry indexGeom = (JGeometry)collectionGeoms.get(index);
                        JGeometry[] elems = indexGeom.getElements();
                        JGeometry outGeom = this.outGeometries.get(index);
                        for (int i = 0; i < elems.length; ++i) {
                            if (elems[i].getType() == 1) {
                                outGeom = JGeometryUtil.addPoint(outGeom, elems[i]);
                                continue;
                            }
                            if (elems[i].getType() != 2) continue;
                            outGeom = JGeometryUtil.addLine(outGeom, elems[i]);
                        }
                        this.outGeometries.set(index, outGeom);
                    }
                }
            }
        }
        if (spGeoms.length > topoedges) {
            for (int i = topoedges; i < spGeoms.length; ++i) {
                this.outGeometries.add(spGeoms[i]);
            }
        }
        int count = 0;
        for (int featureCount = 0; featureCount < simpleFeatures.size(); ++featureCount) {
            if (unableFeats.get("" + featureCount) != null) continue;
            SimpleFeatureI feature = simpleFeatures.get(featureCount);
            SimpleGeometry geom = feature.getGeometry();
            JGeometry g = this.outGeometries.get(count++);
            geom.setGtype(g.getType());
            geom.setOrdinates(g.getOrdinatesArray());
            geom.setElemInfo(g.getElemInfo());
        }
        long endTime = System.currentTimeMillis();
        log.info("Simplification took: " + (endTime - startTime) + " ms, for " + this.outGeometries.size() + " geometries.");
        return simpleFeatures;
    }

    public static List<SimpleFeatureI> sortGeometryFeaturesByAreaDesc(List<SimpleFeatureI> feats) {
        ArrayList<SimpleFeatureI> features = new ArrayList<SimpleFeatureI>();
        if (feats == null || feats.size() == 0) {
            return null;
        }
        log.info("Sorting [" + feats.size() + "] features by area ...");
        for (int i = 0; i < feats.size(); ++i) {
            SimpleGeometry geom = feats.get(i).getGeometry();
            int gtype = geom.getGtype();
            if (geom != null && (gtype == 3 || gtype == 7)) {
                double[] mbr = geom.getMbr();
                double area = GeometrySimplifier.getAreaFromMBR(mbr);
                if (features.size() == 0) {
                    features.add(feats.get(i));
                    continue;
                }
                int index = -1;
                for (int j = 0; j < features.size(); ++j) {
                    double[] fMbr;
                    double fArea;
                    SimpleFeatureI f = features.get(j);
                    SimpleGeometry g = f.getGeometry();
                    if (g.getGtype() != 3 && g.getGtype() != 7 || !(area > (fArea = GeometrySimplifier.getAreaFromMBR(fMbr = f.getGeometry().getMbr())))) continue;
                    index = j;
                    break;
                }
                if (index == -1) {
                    features.add(feats.get(i));
                    continue;
                }
                features.add(index, feats.get(i));
                continue;
            }
            features.add(feats.get(i));
        }
        log.info("End of sorting process.");
        return features;
    }

    private static double getAreaFromMBR(double[] mbr) {
        return Math.abs(mbr[0] - mbr[2]) * Math.abs(mbr[1] - mbr[3]);
    }

    private void buildTopology(ArrayList<JGeometry> geometries) {
        this.reset();
        if (geometries == null || geometries.size() == 0) {
            return;
        }
        ArrayList<String> faceList = new ArrayList<String>();
        log.info("Building topology for [" + geometries.size() + "] geometries...");
        for (int i = 0; i < geometries.size(); ++i) {
            JGeometry geom = geometries.get(i);
            this.origGeometries.add(geom);
            int gtype = geom.getType();
            if (gtype == 1 || gtype == 5) {
                this.geomToBeSimplified.put(new Integer(i), false);
            } else if (gtype == 2 || gtype == 6) {
                this.geomToBeSimplified.put(new Integer(i), false);
            } else if (gtype == 3 || gtype == 7) {
                if (this.topology.getSrid() == -1) {
                    this.topology.setSrid(geom.getSRID());
                }
                try {
                    TopoFaceSplitInfo splitInfo;
                    int s;
                    int splits = this.topology.getFaceSplitInfo().size();
                    int[] ids = this.topology.addPolygonGeometry(geom);
                    int updatedSplits = this.topology.getFaceSplitInfo().size();
                    Hashtable<Integer, Integer> splitMap = new Hashtable<Integer, Integer>();
                    for (s = splits; s < updatedSplits; ++s) {
                        splitInfo = (TopoFaceSplitInfo)this.topology.getFaceSplitInfo().get(s);
                        splitMap.put(new Integer(splitInfo.getNewFace()), new Integer(splitInfo.getSplitFace()));
                    }
                    for (s = splits; s < updatedSplits; ++s) {
                        splitInfo = (TopoFaceSplitInfo)this.topology.getFaceSplitInfo().get(s);
                        if (faceList.contains("" + splitInfo.getSplitFace())) {
                            FaceSplitInfo fsi = new FaceSplitInfo(splitInfo.getNewFace(), splitInfo.getSplitFace(), i);
                            this.faceSplits.put(new Integer(splitInfo.getNewFace()), fsi);
                            continue;
                        }
                        Integer chosenFace = null;
                        Integer splitFace = (Integer)splitMap.get(new Integer(splitInfo.getNewFace()));
                        while (splitFace != null) {
                            chosenFace = splitFace;
                            splitFace = (Integer)splitMap.get(splitFace);
                        }
                        if (chosenFace == null || chosenFace == -1) continue;
                        FaceSplitInfo fsi = new FaceSplitInfo(splitInfo.getNewFace(), chosenFace, i);
                        this.faceSplits.put(new Integer(splitInfo.getNewFace()), fsi);
                    }
                    if (ids != null) {
                        this.polyGeomMap.put(new Integer(i), ids);
                        for (int j = 0; j < ids.length; ++j) {
                            if (!faceList.contains("" + ids[j])) {
                                faceList.add("" + ids[j]);
                            }
                            this.faceGeomIndexMap.put(new Integer(ids[j]), new Integer(i));
                        }
                    }
                    this.geomToBeSimplified.put(new Integer(i), true);
                }
                catch (Exception ex) {
                    log.warning("Exception adding polygon to topology, with index=" + i + ". " + ex.getMessage());
                    this.geomToBeSimplified.put(new Integer(i), false);
                }
            } else {
                this.geomToBeSimplified.put(new Integer(i), false);
            }
            if ((i + 1) % 300 != 0) continue;
            log.finest("Geometry [" + (i + 1) + "] processed.");
        }
        Iterator it = this.topology.getEdgeIterator();
        int index = 0;
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            this.edgeIndexMap.put(new Integer(e.getId()), new Integer(index));
            ++index;
        }
        log.info("End build topology.");
    }

    private void reset() {
        if (this.topology != null) {
            try {
                this.topology.reset();
            }
            catch (Exception e) {
                log.warning("Exception resetting topology. " + e.getMessage());
            }
        }
        this.lineGeomMap.clear();
        this.polyGeomMap.clear();
        this.edgeIndexMap.clear();
        this.topoEdgeGeoms = null;
        this.geomToBeSimplified.clear();
        this.origGeometries.clear();
        this.faceSplits.clear();
        this.usedFaces.clear();
        this.faceGeomIndexMap.clear();
    }

    private static JGeometry[] getSimplifiedGeometries(ArrayList<JGeometry> geoms, boolean isGeodetic, double threshold, int simplifyAlgorithm, SRS srs) {
        JGeometry[] simplifiedGeoms = null;
        boolean tallertriBox = false;
        double M = 1.0;
        double N = 0.0;
        double KS = 1.0;
        double KH = 1.0;
        double SM = 1.0;
        double SK = 1.0;
        double origPoints = 0.0;
        double simpliPoints = 0.0;
        simplifiedGeoms = new JGeometry[geoms.size()];
        log.info("Starting simplification of [" + geoms.size() + "] geometries...");
        for (int i = 0; i < geoms.size(); ++i) {
            double wd;
            double[] mbr;
            JGeometry simpgeom;
            double yend;
            double xend;
            double yini;
            double xini;
            int dim;
            double[] joords;
            block15: {
                JGeometry jgeom = geoms.get(i);
                joords = jgeom.getOrdinatesArray();
                dim = jgeom.getDimensions();
                xini = joords[0];
                yini = joords[1];
                xend = joords[joords.length - dim];
                yend = joords[joords.length - dim + 1];
                simpgeom = null;
                if (simplifyAlgorithm == MapDataRequest.DOUGLAS_PEUCKER_ALGORITHM) {
                    try {
                        simpgeom = isGeodetic ? jgeom.simplify(threshold, srs.getSpheroid().getSemiMajorAxis(), 1.0 / srs.getSpheroid().getFlattening()) : jgeom.simplify(threshold);
                        break block15;
                    }
                    catch (Exception ex) {
                        origPoints += (double)(joords.length / dim);
                        simpliPoints += (double)(joords.length / dim);
                        log.warning("Exception during simplification of geometry [" + (i + 1) + "]. " + ex.getMessage());
                        continue;
                    }
                }
                if (simplifyAlgorithm == MapDataRequest.VISVALINGAM_WHYATT_ALGORITHM) {
                    try {
                        simpgeom = isGeodetic ? JGeometry.simplifyVW((JGeometry)jgeom, (double)threshold, (boolean)tallertriBox, (double)M, (double)N, (double)KS, (double)KH, (double)SM, (double)SK, (double)srs.getSpheroid().getSemiMajorAxis(), (double)(1.0 / srs.getSpheroid().getFlattening())) : JGeometry.simplifyVW((JGeometry)jgeom, (double)threshold, (boolean)tallertriBox, (double)M, (double)N, (double)KS, (double)KH, (double)SM, (double)SK);
                    }
                    catch (Exception ex) {
                        origPoints += (double)(joords.length / dim);
                        simpliPoints += (double)(joords.length / dim);
                        log.warning("Exception during simplification of geometry [" + (i + 1) + "]. " + ex.getMessage());
                        continue;
                    }
                }
            }
            if (simpgeom == null || simpgeom.getOrdinatesArray() == null) {
                log.warning("Simplification of geometry [" + (i + 1) + "] generated a null geometry or a null array of points. Ignored.");
                origPoints += (double)(joords.length / dim);
                simpliPoints += (double)(joords.length / dim);
                continue;
            }
            if (simpgeom.getType() == 1) {
                log.warning("Simplification of geometry [" + (i + 1) + "] generated a point. Ignored.");
                origPoints += (double)(joords.length / dim);
                simpliPoints += (double)(joords.length / dim);
                continue;
            }
            if (simpgeom.getType() == 2 && simpgeom.getOrdinatesArray().length / simpgeom.getDimensions() == 1) {
                log.warning("Simplification of geometry [" + (i + 1) + "] generated a line with just one point. Ignored.");
                origPoints += (double)(joords.length / dim);
                simpliPoints += (double)(joords.length / dim);
                continue;
            }
            double[] oords = simpgeom.getOrdinatesArray();
            oords[0] = xini;
            oords[1] = yini;
            oords[oords.length - dim] = xend;
            oords[oords.length - dim + 1] = yend;
            if (isGeodetic && (mbr = simpgeom.getMBR()) != null && mbr.length > 2 && (wd = mbr[2] - mbr[0]) > 180.0) {
                int oo;
                ArrayList<Double> ptsdb = new ArrayList<Double>();
                boolean start = false;
                double prevX = 0.0;
                for (oo = 0; oo < oords.length; oo += dim) {
                    if (start && Math.abs(oords[oo] - prevX) > 180.0) continue;
                    prevX = oords[oo];
                    ptsdb.add(new Double(oords[oo]));
                    ptsdb.add(new Double(oords[oo + 1]));
                    if (dim > 2) {
                        for (int oox = 2; oox < dim; ++oox) {
                            ptsdb.add(new Double(oords[oo + oox]));
                        }
                    }
                    start = true;
                }
                oords = new double[ptsdb.size()];
                for (oo = 0; oo < ptsdb.size(); ++oo) {
                    oords[oo] = (Double)ptsdb.get(oo);
                }
            }
            double[] cleanOords = oords;
            simplifiedGeoms[i] = simpgeom = new JGeometry(simpgeom.getType() + simpgeom.getDimensions() * 1000, simpgeom.getSRID(), simpgeom.getElemInfo(), cleanOords);
            int featPoints = joords.length / dim;
            int featSimpliPoints = simpgeom.getOrdinatesArray().length / simpgeom.getDimensions();
            origPoints += (double)featPoints;
            simpliPoints += (double)featSimpliPoints;
            if ((i + 1) % 300 != 0) continue;
            log.finest("Geometry [" + (i + 1) + "]: # orig_points= " + featPoints + " # simplified_points= " + featSimpliPoints);
        }
        log.info("End of simplification: # orig_points= " + origPoints + " # simplified_points= " + simpliPoints);
        return simplifiedGeoms;
    }

    private ArrayList<JGeometry> getTopologyEdgeGeometries() {
        if (this.topoEdgeGeoms != null) {
            return this.topoEdgeGeoms;
        }
        if (this.topology == null) {
            return null;
        }
        Iterator it = this.topology.getEdgeIterator();
        ArrayList<JGeometry> edges = new ArrayList<JGeometry>();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            Point2DD[] coords = e.getCoords();
            double[] oords = new double[coords.length * 2];
            for (int i = 0; i < coords.length; ++i) {
                oords[2 * i] = coords[i].getX();
                oords[2 * i + 1] = coords[i].getY();
            }
            JGeometry ed = JGeometry.createLinearLineString((double[])oords, (int)2, (int)this.topology.getSrid());
            edges.add(ed);
        }
        if (edges.size() == 0) {
            return null;
        }
        this.topoEdgeGeoms = edges;
        return edges;
    }

    private int[] getGeometryTopoElements(int geomIndex) {
        if (this.origGeometries == null) {
            return null;
        }
        JGeometry geom = this.origGeometries.get(geomIndex);
        if (geom == null) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 5) {
            return null;
        }
        if (gtype == 2 || gtype == 6) {
            return this.lineGeomMap.get(new Integer(geomIndex));
        }
        if (gtype == 3 || gtype == 7) {
            return this.polyGeomMap.get(new Integer(geomIndex));
        }
        return null;
    }

    private ArrayList<JGeometry> rebuildSimplifiedGeometries(ArrayList<JGeometry> simplifiedTopoEdges) {
        int i;
        JGeometry geom;
        this.usedFaces.clear();
        ArrayList<JGeometry> outGeoms = new ArrayList<JGeometry>();
        if (this.origGeometries == null) {
            return null;
        }
        log.info("Rebuilding geometries...");
        for (int i2 = 0; i2 < this.origGeometries.size(); ++i2) {
            Boolean b;
            if ((i2 + 1) % 500 == 0) {
                log.finest("Geometry [" + (i2 + 1) + "] ...");
            }
            if ((b = this.geomToBeSimplified.get(new Integer(i2))) == null || !b.booleanValue()) {
                outGeoms.add(this.origGeometries.get(i2));
                continue;
            }
            geom = this.origGeometries.get(i2);
            int gtype = geom.getType();
            if (gtype == 1 || gtype == 5) {
                outGeoms.add(this.origGeometries.get(i2));
                continue;
            }
            if (gtype == 2 || gtype == 6) {
                outGeoms.add(this.origGeometries.get(i2));
                continue;
            }
            if (gtype == 3 || gtype == 7) {
                int[] elems = this.getGeometryTopoElements(i2);
                if (elems != null && elems.length > 0) {
                    JGeometry outg = null;
                    for (int j = 0; j < elems.length; ++j) {
                        this.usedFaces.put(new Integer(elems[j]), new Boolean(true));
                        JGeometry g = this.getFaceGeometry(elems[j], simplifiedTopoEdges);
                        if (g == null) continue;
                        outg = outg == null ? g : JGeometryUtil.addPolygon(outg, g);
                    }
                    if (outg == null) {
                        log.warning("Using original element for geometry " + i2);
                        outGeoms.add(this.origGeometries.get(i2));
                        continue;
                    }
                    outGeoms.add(outg);
                    continue;
                }
                log.warning("Using original element for geometry " + i2);
                outGeoms.add(this.origGeometries.get(i2));
                continue;
            }
            log.warning("Using original element for geometry " + i2);
            outGeoms.add(this.origGeometries.get(i2));
        }
        log.info("Processing missing faces ...");
        ArrayList topoFaces = this.topology.getFaceAdditions();
        for (i = 0; i < topoFaces.size(); ++i) {
            JGeometry geom2;
            FaceSplitInfo fsi;
            Integer f = (Integer)topoFaces.get(i);
            if (this.usedFaces.get(new Integer(f)) != null || (fsi = this.faceSplits.get(new Integer(f))) == null) continue;
            int geomIndex = -1;
            if (fsi.getSplitFace() == -1) {
                geomIndex = fsi.getGeomIndex();
            } else {
                FaceSplitInfo fsiSplit = this.faceSplits.get(new Integer(fsi.getSplitFace()));
                if (fsiSplit == null) {
                    Integer index = this.faceGeomIndexMap.get(new Integer(fsi.getSplitFace()));
                    if (index == null) continue;
                    geomIndex = index;
                } else {
                    geomIndex = fsiSplit.getGeomIndex();
                }
            }
            JGeometry g = this.getFaceGeometry(f, simplifiedTopoEdges);
            if (g == null || (geom2 = outGeoms.get(geomIndex)) == null || (geom2 = JGeometryUtil.addPolygon(geom2, g)) == null) continue;
            outGeoms.set(geomIndex, geom2);
        }
        log.info("Cleaning very small areas for multi-polygons or collection with polygons ...");
        for (i = 0; i < outGeoms.size(); ++i) {
            geom = outGeoms.get(i);
            if (geom.getType() != 7 && geom.getType() != 4) continue;
            double maxArea = Double.NEGATIVE_INFINITY;
            int maxAreaElem = -1;
            int numPolys = 0;
            JGeometry[] elems = geom.getElements();
            if (elems == null || elems.length <= 0) continue;
            double[] elemsArea = new double[elems.length];
            for (int j = 0; j < elems.length; ++j) {
                double area;
                JGeometry elem = elems[j];
                if (elem.getType() != 3) continue;
                elemsArea[j] = area = Math.abs(GeometryUtil.getPolygonArea(elems[j].getOrdinatesArray()));
                if (numPolys == 0 || area > maxArea) {
                    maxArea = area;
                    maxAreaElem = j;
                }
                ++numPolys;
            }
            if (maxAreaElem <= -1 || numPolys <= true) continue;
            Hashtable<String, String> elemsToRemove = new Hashtable<String, String>();
            for (int j = 0; j < elems.length; ++j) {
                double areaPercent;
                if (maxAreaElem == j) continue;
                JGeometry elem = elems[j];
                int numPoints = elem.getOrdinatesArray().length / elem.getDimensions();
                if (elem.getType() != 3 || numPoints >= 11 || !((areaPercent = elemsArea[j] / maxArea * 100.0) < 2.0)) continue;
                elemsToRemove.put("" + j, "" + j);
            }
            if (elemsToRemove.size() <= 0) continue;
            JGeometry g = new JGeometry(elems[maxAreaElem].getType(), elems[maxAreaElem].getSRID(), elems[maxAreaElem].getElemInfo(), elems[maxAreaElem].getOrdinatesArray());
            for (int j = 0; j < elems.length; ++j) {
                if (maxAreaElem == j || elemsToRemove.get("" + j) != null) continue;
                JGeometry elem = elems[j];
                if (elem.getType() == 1) {
                    g = JGeometryUtil.addPoint(g, elem);
                    continue;
                }
                if (elem.getType() == 2) {
                    g = JGeometryUtil.addLine(g, elem);
                    continue;
                }
                if (elem.getType() != 3) continue;
                g = JGeometryUtil.addPolygon(g, elem);
            }
            outGeoms.set(i, g);
        }
        return outGeoms;
    }

    private JGeometry getFaceGeometry(int face, ArrayList<JGeometry> simplifiedTopoEdges) {
        JGeometry outgeom = null;
        try {
            Face f = this.topology.getFace(Math.abs(face));
            int bdedge = f.getBoundaryEdge();
            outgeom = this.getPolygonFromBoundaryEdge(f.getID(), bdedge, simplifiedTopoEdges);
            if (outgeom == null) {
                log.warning("Unable to build face polygon from edge: " + bdedge);
                return null;
            }
            double[] oords = outgeom.getOrdinatesArray();
            if (oords == null || oords.length < 8) {
                return null;
            }
            int[] isledges = f.getIslandEdges();
            if (isledges != null && isledges.length > 0) {
                for (int i = 0; i < isledges.length; ++i) {
                    JGeometry hole = this.getPolygonFromBoundaryEdge(f.getID(), isledges[i], simplifiedTopoEdges);
                    if (hole == null || (oords = hole.getOrdinatesArray()) == null || oords.length < 8) continue;
                    outgeom = JGeometryUtil.addVoidPolygon(outgeom, 0, hole);
                }
            }
        }
        catch (Exception ex) {
            log.warning("Unable to build polygon geometry for face: " + face);
            outgeom = null;
        }
        return outgeom;
    }

    private JGeometry getPolygonFromBoundaryEdge(int faceId, int bdedge, ArrayList<JGeometry> simplifiedTopoEdges) {
        JGeometry outgeom = null;
        try {
            Edge e = this.topology.getEdge(Math.abs(bdedge));
            int startEdge = e.getId();
            int nextEdge = -1;
            nextEdge = e.getBoundedFaceL() == faceId ? e.getNextEdgeL() : e.getNextEdgeR();
            double[] oords = this.getEdgeOords(e, simplifiedTopoEdges);
            if (bdedge < 0) {
                oords = GeometryUtil.reverseCoordinates(oords, 2);
            }
            if (e.getOriginNode() == e.getEndNode()) {
                if (GeometryUtil.isClockwise(oords)) {
                    oords = GeometryUtil.reverseCoordinates(oords, 2);
                }
            } else {
                ArrayList<Point2DD> points = new ArrayList<Point2DD>();
                for (int i = 0; i < oords.length / 2; ++i) {
                    points.add(new Point2DD(oords[2 * i], oords[2 * i + 1]));
                }
                while (Math.abs(nextEdge) != Math.abs(startEdge)) {
                    int j;
                    Edge ne = this.topology.getEdge(Math.abs(nextEdge));
                    double[] neoords = this.getEdgeOords(ne, simplifiedTopoEdges);
                    if (nextEdge > 0) {
                        for (j = 1; j < neoords.length / 2; ++j) {
                            points.add(new Point2DD(neoords[2 * j], neoords[2 * j + 1]));
                        }
                    } else {
                        for (j = neoords.length / 2 - 2; j >= 0; --j) {
                            points.add(new Point2DD(neoords[2 * j], neoords[2 * j + 1]));
                        }
                    }
                    if (ne.getBoundedFaceL() == faceId) {
                        nextEdge = ne.getNextEdgeL();
                        continue;
                    }
                    nextEdge = ne.getNextEdgeR();
                }
                Point2DD[] p2ds = points.toArray(new Point2DD[points.size()]);
                oords = new double[p2ds.length * 2];
                for (int i = 0; i < p2ds.length; ++i) {
                    oords[i * 2] = p2ds[i].getX();
                    oords[i * 2 + 1] = p2ds[i].getY();
                }
            }
            int[] elemInfo = new int[]{1, 1003, 1};
            outgeom = new JGeometry(2003, this.topology.getSrid(), elemInfo, oords);
        }
        catch (Exception ex) {
            log.warning("Exception: " + ex.getMessage());
            outgeom = null;
        }
        return outgeom;
    }

    private double[] getEdgeOords(Edge e, ArrayList<JGeometry> simplifiedTopoEdges) {
        Integer simpliIndex = this.edgeIndexMap.get(e.getId());
        JGeometry simplEdgeGeom = simplifiedTopoEdges.get(simpliIndex);
        double[] oords = null;
        if (simplEdgeGeom == null) {
            Point2DD[] pts = e.getCoords();
            oords = new double[pts.length * 2];
            for (int i = 0; i < pts.length; ++i) {
                oords[i * 2] = pts[i].getX();
                oords[i * 2 + 1] = pts[i].getY();
            }
        } else {
            oords = simplEdgeGeom.getOrdinatesArray();
        }
        return oords;
    }

    public ArrayList<JGeometry> getOutGeometries() {
        return this.outGeometries;
    }

    private class FaceSplitInfo {
        private int newFace = -1;
        private int splitFace = -1;
        private int geomIndex = -1;

        public FaceSplitInfo(int newId, int splitId, int index) {
            this.newFace = newId;
            this.splitFace = splitId;
            this.geomIndex = index;
        }

        public int getNewFace() {
            return this.newFace;
        }

        public int getSplitFace() {
            return this.splitFace;
        }

        public int getGeomIndex() {
            return this.geomIndex;
        }
    }
}

