/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import oracle.dbtools.connections.db.AbstractConnectionCreator;

public class MySQLConnectionCreator
extends AbstractConnectionCreator {
    public static final String MYSQL_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    public static final String SUBTYPE_MYSQL = "MYSQL";

    protected boolean allowNullPassword() {
        return true;
    }

    public Connection getConnection(Properties properties) throws SQLException {
        return super.getConnection(properties);
    }

    public String getDriverClassName(Properties properties) throws SQLException {
        String string = super.getDriverClassName(properties);
        if (this.hasLength(string)) {
            return string;
        }
        return MYSQL_DRIVER_CLASS;
    }

    public String getConnectionURL(Properties properties) throws SQLException {
        String string;
        String string2 = super.getConnectionURL(properties);
        if (this.hasLength(string2)) {
            string = string2;
        } else {
            String string3 = this.getPropertyOrThrow(properties, "hostname");
            String string4 = properties.getProperty("port");
            String string5 = this.getPropertyOrThrow(properties, "dataSourceName");
            StringBuilder stringBuilder = new StringBuilder("jdbc:mysql://");
            stringBuilder.append(string3);
            if (string4 != null) {
                stringBuilder.append(':').append(string4);
            }
            stringBuilder.append('/').append(string5);
            string = stringBuilder.toString();
        }
        return string;
    }

    public Collection<String> listAllowedProperties() {
        Collection collection = super.listAllowedProperties();
        collection.add("hostname");
        collection.add("port");
        collection.add("dataSourceName");
        return collection;
    }

    public Collection<String> listRequiredProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("hostname");
        hashSet.add("dataSourceName");
        return hashSet;
    }
}

