/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbol.compiler;

import ilog.views.symbol.compiler.IlvScUtilities;
import ilog.views.symbol.compiler.IlvSymbolCompiler;
import ilog.views.symbol.compiler.IlvSymbolCompilerException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

abstract class ScJavaClassWriter
extends IlvScUtilities {
    private IlvSymbolCompiler a;
    private Hashtable<String, String> b;
    private String c;
    private String d;
    private String e;
    private ArrayList<String> f;
    private boolean g = false;
    private boolean h = true;

    public ScJavaClassWriter(IlvSymbolCompiler ilvSymbolCompiler) {
        this.a = ilvSymbolCompiler;
        this.b = new Hashtable();
    }

    IlvSymbolCompiler n() {
        return this.a;
    }

    public String getClassName() {
        return this.d;
    }

    public void setClassName(String string) {
        this.d = string;
    }

    public String getSuperClass() {
        return this.e;
    }

    public void setSuperClass(String string) {
        this.registerImportedClass(string);
        this.e = string;
    }

    public void addInterface(String string) {
        if (this.f == null) {
            this.f = new ArrayList(1);
        } else if (this.f.indexOf(string) != -1) {
            return;
        }
        this.f.add(string);
    }

    public Iterator<String> getInterfaces() {
        if (this.f != null) {
            return this.f.iterator();
        }
        return null;
    }

    public String getPackageName() {
        return this.c;
    }

    public void setPackageName(String string) {
        this.c = string;
    }

    public String getFullClassName() {
        if (this.c == null || this.c.length() == 0) {
            return this.d;
        }
        return this.c + "." + this.d;
    }

    public String registerImportedClass(String string) {
        String string2 = this.extractClassName(string);
        if (!this.b.containsKey(string)) {
            if (this.b.containsValue(string2)) {
                string2 = string;
            }
            this.b.put(string, string2);
        }
        return string2;
    }

    public void writeClass(Writer writer) throws IOException, IlvSymbolCompilerException {
        this.writeHeader(writer);
        IlvScUtilities.a(writer);
        this.writePackage(writer);
        IlvScUtilities.a(writer);
        this.writeImports(writer);
        IlvScUtilities.a(writer);
        this.writeClassDeclaration(writer);
        IlvScUtilities.a(writer);
        this.writeVariables(writer);
        IlvScUtilities.a(writer);
        this.writeInnerClasses(writer);
        this.writeFunctions(writer);
        this.writeEndOfClass(writer);
        writer.flush();
    }

    protected void writeVariables(Writer writer) throws IOException, IlvSymbolCompilerException {
    }

    protected void writeInnerClasses(Writer writer) throws IOException, IlvSymbolCompilerException {
    }

    protected abstract void writeFunctions(Writer var1) throws IOException, IlvSymbolCompilerException;

    protected void writeHeader(Writer writer) throws IOException, IlvSymbolCompilerException {
    }

    protected void writePackage(Writer writer) throws IOException, IlvSymbolCompilerException {
        if (this.getPackageName() != null) {
            writer.write("package ");
            writer.write(this.getPackageName());
            writer.write(";");
            IlvScUtilities.a(writer);
        }
    }

    protected void writeImports(Writer writer) throws IOException, IlvSymbolCompilerException {
        Enumeration<String> enumeration = this.b.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (string.startsWith("java.lang.")) continue;
            writer.write("import ");
            writer.write(string);
            writer.write(";");
            IlvScUtilities.a(writer);
        }
    }

    protected void writeClassDeclaration(Writer writer) throws IOException, IlvSymbolCompilerException {
        Iterator<String> iterator;
        if (this.p()) {
            writer.write("public ");
        }
        if (this.o()) {
            writer.write("abstract ");
        }
        writer.write("class ");
        writer.write(this.getClassName());
        String string = this.getSuperClass();
        if (!IlvScUtilities.s(string)) {
            string = this.getShortClassName(string);
            writer.write(" extends ");
            writer.write(string);
        }
        if ((iterator = this.getInterfaces()) != null) {
            boolean bl = true;
            while (iterator.hasNext()) {
                String string2 = this.getShortClassName(iterator.next());
                if (bl) {
                    bl = false;
                    writer.write(" implements ");
                } else {
                    writer.write(", ");
                }
                writer.write(string2);
            }
        }
        writer.write(" {");
        IlvScUtilities.a(writer);
    }

    protected void writeEndOfClass(Writer writer) throws IOException, IlvSymbolCompilerException {
        writer.write("}");
        IlvScUtilities.a(writer);
    }

    protected String getShortClassName(String string) {
        String string2 = this.b.get(string);
        return string2 == null ? string : string2;
    }

    protected String extractClassName(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    boolean o() {
        return this.g;
    }

    void c(boolean bl) {
        this.g = bl;
    }

    boolean p() {
        return this.h;
    }

    void d(boolean bl) {
        this.h = bl;
    }
}

