/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbol.compiler;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import ilog.views.sdm.graphic.IlvURLGraphic;
import ilog.views.symbol.compiler.CompilerAction;
import ilog.views.symbol.compiler.CompilerComponent;
import ilog.views.symbol.compiler.IlvScUtilities;
import ilog.views.symbol.compiler.IlvSymbolCompiler;
import ilog.views.symbol.compiler.IlvSymbolCompilerException;
import ilog.views.symbol.compiler.MainPanel;
import ilog.views.symbol.compiler.Project;
import ilog.views.symbol.compiler.PropertiesPanel;
import ilog.views.symbol.compiler.ScSymbol;
import ilog.views.symbol.compiler.Settings;
import ilog.views.symbol.compiler.StatusPanel;
import ilog.views.symbol.compiler.SymbolDropTargetListener;
import ilog.views.symbol.compiler.SymbolJavaView;
import ilog.views.symbol.compiler.SymbolTester;
import ilog.views.symbol.compiler.SymbolViewer;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvProductUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.internal.IlvPopUserBrowser;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class IlvSymbolCompilerApplication {
    private IlvSymbolCompiler a;
    private Project b;
    private JFileChooser c;
    private SymbolViewer d;
    private ResourceBundle e;
    private IlvPaletteManager f;
    private MainPanel g;
    private StatusPanel h;
    private Settings i;
    private PropertiesPanel j;
    private SymbolTester k;
    private Logger l;
    private ArrayList<File> m;
    private ArrayList<CompilerComponent> n;
    private String o;
    private String p;
    private String q;
    private boolean r = true;
    private String s = null;
    private boolean t = false;
    private boolean u = false;
    private boolean v = false;
    final Mode w = new Mode();
    final Mode x = new Mode();
    private Mode y;
    private ArrayList<IlvPaletteSymbol> z;
    private ArrayList<ScSymbol> aa;
    private SymbolJavaView ab;
    private IlvPaletteSymbol ac;
    private static final String ad = ".isc";
    CompilerAction ae;
    CompilerAction af;
    CompilerAction ag;
    CompilerAction ah;
    CompilerAction ai;
    CompilerAction aj;
    CompilerAction ak;
    CompilerAction al;
    CompilerAction am;
    CompilerAction an;
    CompilerAction ao;
    private FileFilter ap = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(IlvSymbolCompilerApplication.ad);
        }

        @Override
        public String getDescription() {
            return IlvSymbolCompilerApplication.this.a("Compiler.SymbolCompilerProjectFiles");
        }
    };

    IlvSymbolCompilerApplication() {
        this(null);
    }

    IlvSymbolCompilerApplication(String[] stringArray) {
        IlvProductUtil.DeploymentLicenseRequired((String)"JViews-Diagrammer");
        this.a(stringArray);
        this.n = new ArrayList();
        this.b = new Project(this);
        this.m = new ArrayList();
        this.e = IlvResourceUtil.getBundle((String)"compiler", IlvSymbolCompilerApplication.class, (Locale)IlvLocaleUtil.getCurrentLocale());
        this.z = new ArrayList();
        this.aa = new ArrayList();
        this.ab = new SymbolJavaView(this);
        this.d = new SymbolViewer(this);
        new SymbolDropTargetListener(this);
        this.f = new IlvPaletteManager();
        this.a = new IlvSymbolCompiler(this.f);
        this.a.a("URL", IlvURLGraphic.class, new IlvSymbolCompiler.URLStringWriter());
        this.i = new Settings(this);
        if (!this.r) {
            this.i.a(false);
        }
        if (this.s != null) {
            this.i.e(this.s);
        }
        this.ad();
        this.g = new MainPanel(this);
        this.a(this.w);
    }

    IlvSymbolCompiler a() {
        return this.a;
    }

    private void ad() {
        this.ae = new CompilerAction.New(this);
        this.af = new CompilerAction.Open(this);
        this.ag = new CompilerAction.Save(this);
        this.ah = new CompilerAction.SaveAs(this);
        this.ai = new CompilerAction.Exit(this);
        this.aj = new CompilerAction.Delete(this);
        this.ak = new CompilerAction.GenerateSourceFiles(this);
        this.al = new CompilerAction.JavaC(this);
        this.am = new CompilerAction.TestSelectedSymbols(this);
        this.an = new CompilerAction.Documentation(this);
        this.ao = new CompilerAction.About(this);
    }

    void b() {
        this.d();
        if (!this.t) {
            this.g.setVisible(true);
        }
        this.ag();
        this.af();
        this.c(this.i.a());
        this.d(this.i.c());
        this.e(this.i.b());
        this.b.a(false);
        if (this.u) {
            this.q();
        } else if (this.v) {
            this.p();
        }
        if (this.t) {
            this.c();
        }
    }

    private void a(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n++];
            if ("-clean".equals(string)) {
                this.r = false;
                continue;
            }
            if ("-project".equals(string) && n < stringArray.length) {
                this.s = stringArray[n++];
                File file = new File(this.s);
                if (!file.canRead()) {
                    this.a(Level.SEVERE, "Project not found: " + this.s);
                    System.exit(1);
                }
            }
            if ("-compile".equals(string)) {
                this.t = true;
                this.u = true;
            }
            if (!"-generate".equals(string)) continue;
            this.t = true;
            this.v = true;
        }
    }

    void c() {
        if (this.canExit()) {
            this.e();
            System.exit(0);
        }
    }

    protected boolean canExit() {
        return this.aa();
    }

    void a(CompilerComponent compilerComponent) {
        if (this.n.indexOf(compilerComponent) == -1) {
            this.n.add(compilerComponent);
        }
    }

    void d() {
        for (CompilerComponent compilerComponent : this.n) {
            compilerComponent.compilerStarted();
        }
    }

    void e() {
        for (CompilerComponent compilerComponent : this.n) {
            compilerComponent.compilerEnded();
        }
        this.i.e(this.b.a());
        this.i.a(this.o);
        this.i.c(this.q);
        this.i.b(this.p);
        if (this.c != null) {
            this.i.d(this.c.getCurrentDirectory().getPath());
        }
    }

    String a(String string) {
        return this.e.getString(string);
    }

    IlvPaletteManager f() {
        return this.f;
    }

    void a(StatusPanel statusPanel) {
        this.h = statusPanel;
    }

    void b(String string) {
        this.h.a(string);
    }

    void a(String string, String string2) {
        JOptionPane.showMessageDialog(this.g, string2, string, 2);
    }

    void a(Level level, String string) {
        this.ae().log(level, string);
    }

    private Logger ae() {
        if (this.l == null) {
            this.l = Logger.getLogger("ilog.views.symbol.compiler");
        }
        return this.l;
    }

    void c(String string) {
        if (!string.equals(this.o)) {
            this.o = string;
            this.j.a(string);
            this.b.a(true);
        }
    }

    String g() {
        return this.o;
    }

    String h() {
        return this.q;
    }

    void d(String string) {
        if (!string.equals(this.q)) {
            this.f(string);
            this.q = string;
            this.j.b(string);
            this.b.a(true);
        }
    }

    Settings i() {
        return this.i;
    }

    String j() {
        return this.p;
    }

    void e(String string) {
        if (!string.equals(this.p)) {
            this.f(string);
            this.p = string;
            this.j.c(string);
            this.b.a(true);
        }
    }

    void f(String string) {
        String string2 = string.replace("/", File.separator);
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator, string2);
        }
        if (!this.b(file)) {
            URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> clazz = URLClassLoader.class;
            try {
                Class[] classArray = new Class[1];
                classArray[0] = URL.class;
                Method method = clazz.getDeclaredMethod("addURL", classArray);
                method.setAccessible(true);
                URI uRI = file.toURI();
                URL uRL = uRI.toURL();
                method.invoke((Object)uRLClassLoader, uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m.add(file);
        }
    }

    private boolean b(File file) {
        for (File file2 : this.m) {
            if (!file2.equals(file)) continue;
            return true;
        }
        return false;
    }

    void a(PropertiesPanel propertiesPanel) {
        this.j = propertiesPanel;
    }

    PropertiesPanel k() {
        return this.j;
    }

    MainPanel l() {
        return this.g;
    }

    SymbolViewer m() {
        return this.d;
    }

    void a(SymbolJavaView symbolJavaView) {
        this.ab = symbolJavaView;
    }

    void a(IlvPaletteSymbol ilvPaletteSymbol) {
        if (this.b(ilvPaletteSymbol)) {
            this.b(this.a("Compiler.Symbol.AlreadyAdded"));
            this.g(ilvPaletteSymbol);
            return;
        }
        this.z.add(ilvPaletteSymbol);
        this.d.a(ilvPaletteSymbol);
        this.b(this.a("Compiler.Symbol.Added") + ilvPaletteSymbol.getID());
        this.b.a(true);
    }

    boolean b(IlvPaletteSymbol ilvPaletteSymbol) {
        return this.z.indexOf(ilvPaletteSymbol) != -1;
    }

    void a(Iterator<IlvPaletteSymbol> iterator) {
        while (iterator.hasNext()) {
            IlvPaletteSymbol ilvPaletteSymbol = iterator.next();
            if (this.b(ilvPaletteSymbol)) continue;
            this.a(ilvPaletteSymbol);
        }
    }

    private boolean a(IlvPaletteSymbol ilvPaletteSymbol, Iterator<IlvPaletteSymbol> iterator) {
        return true;
    }

    ScSymbol c(IlvPaletteSymbol ilvPaletteSymbol) throws IlvSymbolCompilerException {
        ScSymbol scSymbol = this.h(ilvPaletteSymbol);
        if (scSymbol == null) {
            scSymbol = new ScSymbol(this.a, ilvPaletteSymbol);
            this.aa.add(scSymbol);
        }
        return scSymbol;
    }

    private ScSymbol h(IlvPaletteSymbol ilvPaletteSymbol) {
        for (ScSymbol scSymbol : this.aa) {
            if (scSymbol.a() != ilvPaletteSymbol) continue;
            return scSymbol;
        }
        return null;
    }

    void d(IlvPaletteSymbol ilvPaletteSymbol) {
        if (this.z.indexOf(ilvPaletteSymbol) != -1) {
            ScSymbol scSymbol = this.h(ilvPaletteSymbol);
            this.d.b(ilvPaletteSymbol);
            this.z.remove(ilvPaletteSymbol);
            if (scSymbol != null) {
                this.aa.remove(scSymbol);
            }
            this.b.a(true);
        }
    }

    ArrayList<IlvPaletteSymbol> n() {
        return this.z;
    }

    void e(IlvPaletteSymbol ilvPaletteSymbol) {
        this.ab.a(ilvPaletteSymbol);
    }

    String f(IlvPaletteSymbol ilvPaletteSymbol) {
        try {
            ScSymbol scSymbol = new ScSymbol(this.a, ilvPaletteSymbol);
            StringWriter stringWriter = new StringWriter();
            scSymbol.writeClass(stringWriter);
            stringWriter.flush();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    void g(IlvPaletteSymbol ilvPaletteSymbol) {
        if (ilvPaletteSymbol == this.ac) {
            return;
        }
        this.ac = ilvPaletteSymbol;
        this.d.c(ilvPaletteSymbol);
        this.ab.a(ilvPaletteSymbol);
    }

    void o() {
        Thread thread = new Thread(new CompileToJava(this.z, this.g(), this.h()));
        thread.start();
    }

    void p() {
        try {
            for (IlvPaletteSymbol ilvPaletteSymbol : this.z) {
                ScSymbol scSymbol = this.a.a(ilvPaletteSymbol, this.g(), this.h());
                System.out.println("Generating " + scSymbol.getFullClassName());
            }
            System.out.println("Generated " + this.z.size() + " symbols.");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    void q() {
        try {
            ClProgressListener clProgressListener = new ClProgressListener(this.z.size());
            this.a.a(this.z, this.g(), this.h(), this.j(), clProgressListener);
            System.out.println("Compiled " + clProgressListener.b + " symbols.");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    void r() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IlvSymbolCompilerApplication.this.b("");
                IlvSymbolCompilerApplication.this.a(false);
            }
        });
    }

    synchronized void s() {
        Thread thread = new Thread(new JavaC(this.z, this.g(), this.h(), this.j()));
        thread.start();
    }

    synchronized void a(Mode mode) {
        if (mode == this.y) {
            return;
        }
        for (CompilerComponent compilerComponent : this.n) {
            compilerComponent.setMode(mode);
        }
        this.y = mode;
    }

    Mode t() {
        return this.y;
    }

    void u() {
        ArrayList<IlvPaletteSymbol> arrayList = this.d.b();
        if (arrayList == null) {
            arrayList = this.n();
        }
        if (this.a(arrayList)) {
            if (this.k == null) {
                this.k = new SymbolTester(this);
            }
            this.k.a(arrayList);
        }
    }

    private boolean a(ArrayList<IlvPaletteSymbol> arrayList) {
        ArrayList<IlvPaletteSymbol> arrayList2 = null;
        for (IlvPaletteSymbol ilvPaletteSymbol : arrayList) {
            if (IlvScUtilities.e(ilvPaletteSymbol) != null) continue;
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<IlvPaletteSymbol>();
            }
            arrayList2.add(ilvPaletteSymbol);
        }
        if (arrayList2 == null) {
            return true;
        }
        this.a(this.a("SysbolTester.testing"), this.a("SymbolTester.classesNotFound"));
        return false;
    }

    private boolean af() {
        File file;
        String string;
        String string2 = string = this.s != null ? this.s : this.i.i();
        if (!IlvScUtilities.s(string) && (file = new File(string)).canRead()) {
            try {
                this.a(file);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.i.e(null);
        return false;
    }

    private void ag() {
        IlvPaletteManager ilvPaletteManager = this.f;
        Iterator<Settings.PaletteSpec> iterator = this.i.h();
        while (iterator.hasNext()) {
            Settings.PaletteSpec paletteSpec = iterator.next();
            try {
                IlvPalette ilvPalette = ilvPaletteManager.load(paletteSpec.a);
            }
            catch (IOException iOException) {
                if (paletteSpec.b == null || paletteSpec.b.length() <= 0) continue;
                try {
                    URL uRL = new URL(paletteSpec.b);
                    ilvPaletteManager.load(uRL);
                }
                catch (Exception exception) {
                    this.a(Level.SEVERE, "Could not load the palette: " + paletteSpec.b);
                }
            }
        }
    }

    boolean v() throws IOException {
        if (this.b.a() == null) {
            return this.w();
        }
        this.b.b();
        this.b.a(false);
        return true;
    }

    boolean w() throws IOException {
        if (this.ah()) {
            this.b.b();
            this.b.a(false);
            return true;
        }
        return false;
    }

    private boolean ah() {
        JFileChooser jFileChooser = this.ai();
        jFileChooser.setDialogType(1);
        int n = jFileChooser.showSaveDialog(this.l());
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.getPath();
            if (string.indexOf(46) == -1) {
                file = new File(string + ad);
            }
            if (this.c(file)) {
                this.b.a(file.getPath());
                return true;
            }
        }
        return false;
    }

    private boolean c(File file) {
        File file2;
        if (file.exists() && this.b.a() != null && !file.equals(file2 = new File(this.b.a()))) {
            int n = JOptionPane.showOptionDialog(this.l(), this.a("Compiler.Dialog.FileExistsLabel"), this.a("Compiler.Dialog.FileExistsTitle"), 0, 3, null, null, null);
            return n == 0;
        }
        return true;
    }

    private JFileChooser ai() {
        if (this.c == null) {
            this.c = new JFileChooser();
            this.c.setFileFilter(this.ap);
            this.c.setFileSelectionMode(0);
            String string = this.i.g();
            if (string != null) {
                this.c.setCurrentDirectory(new File(string));
            }
        }
        return this.c;
    }

    void x() {
        if (!this.aa()) {
            return;
        }
        JFileChooser jFileChooser = this.ai();
        jFileChooser.setDialogType(0);
        int n = jFileChooser.showOpenDialog(this.l());
        boolean bl = true;
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.getPath().endsWith(ad) && !file.exists()) {
                file = new File(file.getPath() + ad);
            }
            if (file.exists()) {
                try {
                    this.a(file);
                    bl = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                this.a("Could not read", file.getPath());
            }
        }
    }

    void a(boolean bl) {
        int n = bl ? 3 : 0;
        this.g.setCursor(Cursor.getPredefinedCursor(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(File file) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        this.a(true);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
        this.y();
        this.b.b(document);
        this.b.a(file.getPath());
        this.b.a(false);
        this.a(false);
    }

    void y() {
        while (this.z.size() > 0) {
            this.d(this.z.get(0));
        }
        this.b.a((String)null);
    }

    void z() {
        if (this.aa()) {
            this.y();
            this.b.a(false);
        }
    }

    boolean aa() {
        if (this.b.e()) {
            int n = JOptionPane.showOptionDialog(this.l(), this.a("Compiler.ModifiedProject.Message"), this.a("Compiler.ModifiedProject.Title"), 1, 3, null, null, null);
            switch (n) {
                case 1: {
                    return true;
                }
                case 0: {
                    boolean bl = false;
                    try {
                        bl = this.v();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            return false;
        }
        return true;
    }

    void ab() {
        SymbolViewer symbolViewer = this.m();
        ArrayList<IlvPaletteSymbol> arrayList = symbolViewer.b();
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        int n = JOptionPane.showOptionDialog(this.l(), this.a("Compiler.Delete.Message"), this.a("Compiler.Delete.Title"), 0, 3, null, null, null);
        if (n == 0) {
            for (IlvPaletteSymbol ilvPaletteSymbol : arrayList) {
                this.d(ilvPaletteSymbol);
            }
        }
    }

    public static void main(final String[] stringArray) {
        if ("ja".equals(Locale.getDefault().getLanguage())) {
            IlvSymbolCompilerApplication.aj();
        }
        if (IlvSymbolCompilerApplication.b(stringArray)) {
            IlvSymbolCompilerApplication ilvSymbolCompilerApplication = new IlvSymbolCompilerApplication(stringArray);
            ilvSymbolCompilerApplication.b();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object object;
                    try {
                        object = IlvSwingUtil.getDefaultAppropriateLookAndFeelClassName();
                        WindowsLookAndFeel.setMnemonicHidden((boolean)false);
                        UIManager.setLookAndFeel((String)object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object = new IlvSymbolCompilerApplication(stringArray);
                    ((IlvSymbolCompilerApplication)object).b();
                }
            });
        }
    }

    private static boolean b(String[] stringArray) {
        for (String string : stringArray) {
            if (!"-compile".equals(string)) {
                if (!"-generate".equals(string)) continue;
            }
            return true;
        }
        return false;
    }

    private static void aj() {
        GraphicsEnvironment.getLocalGraphicsEnvironment().preferLocaleFonts();
    }

    void a(JFrame jFrame) {
        URL uRL = IlvSymbolCompilerApplication.class.getResource("images/symbcomp16.png");
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        jFrame.setIconImage(image);
    }

    private void a(String string, String string2, String string3, String string4) {
        File file = null;
        try {
            if (string != null && string.trim().length() > 0) {
                file = new File(string.trim()).getAbsoluteFile();
            }
            if (file == null || !file.exists()) {
                string = string2;
                file = new File(string.trim()).getAbsoluteFile();
            }
            if (!file.exists()) {
                Object[] objectArray = new Object[]{file};
                this.b(MessageFormat.format(string3, objectArray));
                return;
            }
            IlvPopUserBrowser.pop((File)file);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{file};
            String string5 = exception.getMessage();
            if (string5 == null || string5.trim().length() < 1) {
                string5 = exception.toString();
            }
            this.b(MessageFormat.format(string4, objectArray) + '\n' + string5);
        }
    }

    void ac() {
        this.a(this.a("Help.Menu.Help.File"), this.a("Help.Menu.Help.Fallback.File"), this.a("Help.Menu.Help.File.Missing"), this.a("Help.Menu.Help.Failed"));
    }

    static class Mode {
        Mode() {
        }
    }

    private class CompileToJava
    implements Runnable {
        private ArrayList<IlvPaletteSymbol> a;
        private String b;
        private String c;

        CompileToJava(ArrayList<IlvPaletteSymbol> arrayList, String string, String string2) {
            this.a = new ArrayList<IlvPaletteSymbol>(arrayList);
            this.b = new String(string);
            this.c = new String(string2);
        }

        @Override
        public void run() {
            for (IlvPaletteSymbol ilvPaletteSymbol : this.a) {
                try {
                    IlvSymbolCompilerApplication.this.b(IlvSymbolCompilerApplication.this.a("Compiler.CompilingSymbol") + " " + ilvPaletteSymbol.getID());
                    IlvSymbolCompilerApplication.this.a.generateSymbol(ilvPaletteSymbol, this.b, this.c);
                }
                catch (IlvSymbolCompilerException ilvSymbolCompilerException) {
                    ilvSymbolCompilerException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            IlvSymbolCompilerApplication.this.b(IlvSymbolCompilerApplication.this.a("Compiler.Done"));
        }
    }

    private class ProgressListener
    implements IlvSymbolCompiler.ProgressListener {
        private int a;
        private int b;

        ProgressListener(int n) {
            this.b = n;
        }

        @Override
        public void progress(ScSymbol scSymbol) {
            ++this.a;
            IlvSymbolCompilerApplication.this.b(IlvSymbolCompilerApplication.this.a("Compiler.Compiling") + " (" + this.a + "/" + this.b + ") " + scSymbol.getFullClassName());
        }
    }

    private class JavaC
    implements Runnable {
        private ArrayList<IlvPaletteSymbol> a;
        private String b;
        private String c;
        private String d;

        JavaC(ArrayList<IlvPaletteSymbol> arrayList, String string, String string2, String string3) {
            this.a = new ArrayList<IlvPaletteSymbol>(arrayList);
            this.b = new String(string);
            this.c = new String(string2);
            this.d = new String(string3);
        }

        @Override
        public void run() {
            Mode mode = IlvSymbolCompilerApplication.this.y;
            IlvSymbolCompilerApplication.this.a(IlvSymbolCompilerApplication.this.x);
            IlvSymbolCompilerApplication.this.b(IlvSymbolCompilerApplication.this.a("Compiler.Compiling"));
            try {
                IlvSymbolCompilerApplication.this.a.a(this.a, this.b, this.c, this.d, new ProgressListener(this.a.size()));
            }
            catch (IlvSymbolCompilerException ilvSymbolCompilerException) {
                ilvSymbolCompilerException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            IlvSymbolCompilerApplication.this.a(mode);
            IlvSymbolCompilerApplication.this.b(IlvSymbolCompilerApplication.this.a("Compiler.Done"));
        }
    }

    private static class ClProgressListener
    implements IlvSymbolCompiler.ProgressListener {
        int a;
        private int b;

        ClProgressListener(int n) {
            this.b = n;
            this.a = 0;
        }

        @Override
        public void progress(ScSymbol scSymbol) {
            System.out.println("Compiling (" + ++this.a + "/" + this.b + ") " + scSymbol.getFullClassName());
        }
    }
}

