/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.debugger;

import ilog.views.diagrammer.IlvDiagrammer;
import ilog.views.diagrammer.IlvDiagrammerException;
import ilog.views.diagrammer.project.IlvDiagrammerProject;
import ilog.views.sdm.debugger.IlvDebuggerContext;
import ilog.views.sdm.debugger.gui.IlvDiagramPanel;
import ilog.views.sdm.debugger.gui.IlvTextPanel;
import ilog.views.sdm.debugger.gui.MessageDialog;
import ilog.views.sdm.model.IlvSDMNode;
import ilog.views.util.css.IlvCSSDebugHandler;
import ilog.views.util.css.IlvCSSModel;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.cssbeans.IlvParameterValue;
import ilog.views.util.styling.IlvCSSSelector;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class IlvSDMDebugger {
    private IlvDebuggerContext a = new IlvDebuggerContext();
    private int b = 0;
    private static final int c = 0;
    private static final int d = 1;
    private JFrame e;

    public IlvSDMDebugger(IlvDiagrammer ilvDiagrammer) {
        this.a.setDiagrammer(ilvDiagrammer);
        this.a.setDebugger(this);
        if (ilvDiagrammer.getEngine().getCSSDebugHandler() instanceof Handler) {
            System.err.println("IlvSDMDebugger: debugger already running");
            return;
        }
        JFrame jFrame = new JFrame("SDM debugger");
        JSplitPane jSplitPane = new JSplitPane();
        IlvTextPanel ilvTextPanel = new IlvTextPanel(this.a);
        jSplitPane.setLeftComponent(ilvTextPanel);
        IlvDiagramPanel ilvDiagramPanel = new IlvDiagramPanel(this.a);
        jSplitPane.setRightComponent(ilvDiagramPanel);
        jFrame.getContentPane().add(jSplitPane);
        jFrame.setSize(500, 500);
        jFrame.setDefaultCloseOperation(2);
        jFrame.setVisible(true);
        jSplitPane.setDividerLocation(0.5);
        this.e = jFrame;
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                IlvSDMDebugger.this.a();
            }
        });
        ilvDiagrammer.getEngine().setCSSDebugHandler(new Handler());
    }

    private void a() {
        this.a.getDiagrammer().getEngine().setCSSDebugHandler(null);
        this.a.getDiagramPanel().shutDown();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IlvDiagrammer ilvDiagrammer = new IlvDiagrammer();
                try {
                    ilvDiagrammer.setProject(new IlvDiagrammerProject(new File("data/wizard/basic-debugger.idpr").toURI().toURL()));
                    new IlvSDMDebugger(ilvDiagrammer).b().setDefaultCloseOperation(3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (IlvDiagrammerException ilvDiagrammerException) {
                    ilvDiagrammerException.printStackTrace();
                }
            }
        });
    }

    private JFrame b() {
        return this.e;
    }

    private boolean c() {
        return this.b == 1;
    }

    public void startAction() {
        this.b = 1;
        this.a.getDiagramPanel().recordSession(true);
    }

    public void stopAction() {
        this.b = 0;
        this.nextAction();
        this.a.getDiagramPanel().recordSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextAction() {
        Object object;
        Object object2 = object = this.a.getLock();
        synchronized (object2) {
            object.notifyAll();
        }
    }

    private class Handler
    extends IlvCSSDebugHandler {
        ExecutorService a = Executors.newSingleThreadExecutor();

        private Handler() {
        }

        private boolean a(IlvCSSModel ilvCSSModel) {
            return "ilog.views.util.cssbeans.IlvCSSBeans$ExternalBeanModel".equals(ilvCSSModel.getClass().getName());
        }

        private boolean a(Object object) {
            return object instanceof IlvSDMNode;
        }

        private Object a(Object[] objectArray, String string) {
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != string) continue;
                return objectArray[i + 1];
            }
            return null;
        }

        public void cannotCreateBean(IlvCSSModel ilvCSSModel, Object object, byte by, Object[] objectArray) {
            if (!IlvSDMDebugger.this.c()) {
                return;
            }
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = this.a(objectArray, "CSS.Beans.Class");
            String string = MessageFormat.format(IlvSDMDebugger.this.a.getBundle().getString("IlvSDMDebugger.cannotCreateBean.text"), objectArray2);
            MessageDialog.showDialog(objectArray, IlvSDMDebugger.this.a, string);
            IlvSDMDebugger.this.a.getTextPanel().waitOn((Rule)this.a(objectArray, "CSS.Beans.Rule"), "class", (byte)21, string);
        }

        public void cannotCreateSymbol(IlvCSSModel ilvCSSModel, String string, Rule rule, RuntimeException runtimeException) {
            if (!IlvSDMDebugger.this.c()) {
                return;
            }
            String string2 = MessageFormat.format(IlvSDMDebugger.this.a.getBundle().getString("IlvSDMDebugger.cannotCreateSymbol.text"), string);
            Object[] objectArray = new Object[4];
            objectArray[0] = "CSS.Beans.Rule";
            objectArray[1] = rule;
            objectArray[2] = "CSS.Beans.Exception";
            objectArray[3] = runtimeException;
            MessageDialog.showDialog(objectArray, IlvSDMDebugger.this.a, string2);
            IlvSDMDebugger.this.a.getTextPanel().waitOn(rule, "class", (byte)21, string2);
        }

        public void cannotFindSymbol(IlvCSSModel ilvCSSModel, String string, String string2, String string3, Rule rule) {
            String string4 = MessageFormat.format(IlvSDMDebugger.this.a.getBundle().getString("IlvSDMDebugger.cannotFindSymbol.text"), string, string2, string3);
            IlvSDMDebugger.this.a.getTextPanel().waitOn(rule, "class", (byte)21, string4);
        }

        public void cannotSetProperty(IlvCSSModel ilvCSSModel, Object[] objectArray) {
            if (!IlvSDMDebugger.this.c()) {
                return;
            }
            IlvSDMDebugger.this.a.getDiagramPanel().setCurrentObject(this.a(objectArray, "CSS.Beans.Object"));
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = this.a(objectArray, "CSS.Beans.Property");
            String string = MessageFormat.format(IlvSDMDebugger.this.a.getBundle().getString("IlvSDMDebugger.cannotSetProperty.text"), objectArray2);
            MessageDialog.showDialog(objectArray, IlvSDMDebugger.this.a, string);
            IlvSDMDebugger.this.a.getTextPanel().waitOn((Rule)this.a(objectArray, "CSS.Beans.Rule"), (String)this.a(objectArray, "CSS.Beans.Property"), (byte)21, string);
        }

        public void cannotReadProperty(IlvCSSModel ilvCSSModel, Object[] objectArray) {
            if (!IlvSDMDebugger.this.c()) {
                return;
            }
            IlvSDMDebugger.this.a.getDiagramPanel().setCurrentObject(this.a(objectArray, "CSS.Beans.Object"));
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = this.a(objectArray, "CSS.Beans.ModelProperty");
            String string = MessageFormat.format(IlvSDMDebugger.this.a.getBundle().getString("IlvSDMDebugger.cannotReadProperty.text"), objectArray2);
            IlvSDMDebugger.this.a.getTextPanel().waitOn((Rule)this.a(objectArray, "CSS.Beans.Rule"), (String)this.a(objectArray, "CSS.Beans.Property"), (byte)21, string);
        }

        public void beanCreated(IlvCSSModel ilvCSSModel, Object object, Object object2) {
        }

        public void propertySkipped(IlvCSSModel ilvCSSModel, Rule rule, Object object, Object object2, String string) {
        }

        public void propertySet(IlvCSSModel ilvCSSModel, Rule rule, PropertyDescriptor propertyDescriptor, Object object, int n) {
            if (!IlvSDMDebugger.this.c()) {
                return;
            }
            boolean bl = IlvSDMDebugger.this.a.getTextPanel().waitOnBreakpoint(rule, propertyDescriptor.getName(), object, false);
            if (!bl && IlvSDMDebugger.this.a.getDiagramPanel().shouldPauseDebugger()) {
                IlvSDMDebugger.this.a.getTextPanel().waitOnBreakpoint(rule, propertyDescriptor.getName(), object, true);
            }
        }

        public void applySymbolParameters(IlvCSSModel ilvCSSModel, Object object, Object object2, HashMap<String, IlvParameterValue> hashMap) {
            if (!IlvSDMDebugger.this.c()) {
                return;
            }
            IlvSDMDebugger.this.a.getDiagramPanel().setCurrentObject(object);
            for (String string : hashMap.keySet()) {
                boolean bl;
                if (!IlvSDMDebugger.this.c()) {
                    IlvSDMDebugger.this.a.getDiagramPanel().setCurrentObject(null);
                    return;
                }
                IlvParameterValue ilvParameterValue = hashMap.get(string);
                if (!IlvSDMDebugger.this.a.getTextPanel().isKnownRule(ilvParameterValue._rule) || (bl = IlvSDMDebugger.this.a.getTextPanel().waitOnBreakpoint(ilvParameterValue._rule, string, ilvParameterValue.valueAsObject == IlvParameterValue.UNDEFINED ? ilvParameterValue.cssExpression : ilvParameterValue.valueAsObject, false)) || !IlvSDMDebugger.this.a.getDiagramPanel().shouldPauseDebugger()) continue;
                IlvSDMDebugger.this.a.getTextPanel().waitOnBreakpoint(ilvParameterValue._rule, string, ilvParameterValue.valueAsObject == IlvParameterValue.UNDEFINED ? ilvParameterValue.cssExpression : ilvParameterValue.valueAsObject, true);
            }
            IlvSDMDebugger.this.a.getDiagramPanel().setCurrentObject(null);
        }

        public void simpleSelectorMatchFailed(IlvCSSModel ilvCSSModel, Object object, IlvCSSSelector ilvCSSSelector, byte by) {
        }

        public void startCheckingRule(IlvCSSModel ilvCSSModel, Object object, Rule rule) {
        }

        public void startCustomizing(IlvCSSModel ilvCSSModel, Object object) {
            if (this.a(object)) {
                IlvSDMDebugger.this.a.getDiagramPanel().setCurrentObject(object);
            }
        }

        public void endCheckingRules(IlvCSSModel ilvCSSModel) {
        }

        public void endCustomizing(IlvCSSModel ilvCSSModel, Object object) {
            if (this.a(object) && !this.a(ilvCSSModel)) {
                IlvSDMDebugger.this.a.getDiagramPanel().setCurrentObject(null);
            }
        }

        public void executeDebuggableCode(Runnable runnable, Object object) {
            if (!IlvSDMDebugger.this.c()) {
                runnable.run();
                return;
            }
            if (object.equals("update")) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.a.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }
}

