/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.builder.gui;

import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.appframe.IlvApplication;
import ilog.views.builder.gui.Utils;
import ilog.views.sdm.builder.gui.IlvSymbolUtils;
import ilog.views.swing.IlvJManagerViewPanel;
import ilog.views.symbology.builder.IlvSymbolDesignerUtilities;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteDocumentation;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.event.PaletteManagerEvent;
import ilog.views.symbology.palettes.event.PaletteManagerListener;
import ilog.views.symbology.palettes.event.PaletteViewerEvent;
import ilog.views.symbology.palettes.event.PaletteViewerListener;
import ilog.views.symbology.palettes.swing.IlvPaletteManagerCollapsibleTreeViewer;
import ilog.views.symbology.palettes.swing.action.IlvPaletteLoadAction;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.swing.border.IlvEtchedLineBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class IlvPaletteGUI {
    protected IlvPaletteManagerCollapsibleTreeViewer _tree;
    private IlvPaletteDocumentation a;
    private JPanel b;
    private JSplitPane c;
    private JPanel d;
    private JEditorPane e;
    private JScrollPane f;
    private JButton g;
    protected Box _detailArea;
    private IlvPaletteManager h;
    private IlvSymbolUtils.SymbolPreview i;
    private static final ResourceBundle j = IlvResourceUtil.getBundle((String)"ilog.views.sdm.builder.gui.IlvPaletteGUI", (Locale)IlvLocaleUtil.getCurrentLocale(), (ClassLoader)IlvPaletteGUI.class.getClassLoader());
    private MessageFormat k;

    public IlvPaletteGUI(IlvApplication ilvApplication, IlvPaletteManager ilvPaletteManager) {
        this.h = ilvPaletteManager;
        File file = this.h.getWorkingDirectory();
        this.a = file == null || !file.exists() || !file.isDirectory() ? new IlvPaletteDocumentation(IlvSymbolDesignerUtilities.getPaletteWorkingDirectory((IlvApplication)ilvApplication)) : new IlvPaletteDocumentation(file);
        this.k = new MessageFormat(j.getString("IlvPaletteGUI.paletteReportFormat"));
        this.b();
        this.h.addPaletteManagerListener((PaletteManagerListener)new PaletteManagerListenerImpl());
    }

    public void select(IlvPaletteSymbol ilvPaletteSymbol) {
        this._tree.select(ilvPaletteSymbol);
    }

    public JPanel getComponent() {
        return this.b;
    }

    public void addPaletteViewerListener(PaletteViewerListener paletteViewerListener) {
        this._tree.addPaletteViewerListener(paletteViewerListener);
    }

    public void removePaletteViewerListener(PaletteViewerListener paletteViewerListener) {
        this._tree.removePaletteViewerListener(paletteViewerListener);
    }

    protected String getTitle() {
        return j.getString("IlvPaletteGUI.title");
    }

    protected String getDialogTitle() {
        return j.getString("IlvPaletteGUI.dialog.title");
    }

    protected String getDialogDescription() {
        return j.getString("IlvPaletteGUI.dialog.description");
    }

    protected boolean isClosePaletteAvailable() {
        return false;
    }

    protected boolean isClosePaletteButtonEnabled() {
        return false;
    }

    private void a() {
        if (this.g != null) {
            this.g.setEnabled(this.isClosePaletteButtonEnabled());
        }
    }

    protected void updateDetailArea(Box box) {
    }

    protected void updateContents() {
        this.a();
        this.updateDetailArea(this._detailArea);
    }

    private void b() {
        Dimension dimension;
        this.b = new JPanel(new BorderLayout());
        this.b.putClientProperty("__PSheetDialogTitleKey", this.getTitle());
        Box box = new Box(2);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(BorderFactory.createCompoundBorder((Border)new IlvEtchedLineBorder(2), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        JLabel jLabel = new JLabel(this.getDialogTitle());
        jLabel.setForeground(Utils.LABEL_FOREGROUND_COLOR);
        jLabel.setFont(Utils.TITLE_FONT);
        box.add(jLabel);
        this.b.add((Component)box, "North");
        Box box2 = new Box(3);
        box2.add(Box.createVerticalStrut(3));
        box = new Box(2);
        box.add(Box.createHorizontalStrut(5));
        JLabel jLabel2 = new JLabel(this.getDialogDescription());
        jLabel2.setForeground(Utils.LABEL_FOREGROUND_COLOR);
        jLabel2.setFont(Utils.DESCRIPTION_FONT);
        box.add(jLabel2);
        box2.add(box);
        box2.add(Box.createVerticalStrut(5));
        this._detailArea = new Box(3);
        box2.add(this._detailArea);
        box2.add(Box.createVerticalStrut(5));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 1));
        IlvPaletteLoadAction ilvPaletteLoadAction = new IlvPaletteLoadAction(null, this.h);
        ilvPaletteLoadAction.setCurrentDir(new File("."));
        JButton jButton = new JButton((Action)ilvPaletteLoadAction);
        JCheckBox jCheckBox = new JCheckBox(j.getString("IlvPaletteGUI.viewReport"));
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    IlvPaletteGUI.this.d();
                } else {
                    IlvPaletteGUI.this.e();
                }
            }
        });
        Dimension dimension2 = jButton.getPreferredSize();
        Dimension dimension3 = jCheckBox.getPreferredSize();
        int n = Math.max(dimension2.width, dimension3.width);
        int n2 = dimension2.height;
        Box box3 = new Box(3);
        box3.add(jButton);
        if (this.isClosePaletteAvailable()) {
            this.g = new JButton(j.getString("IlvPaletteGUI.closePalette"));
            dimension = this.g.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 = Math.max(dimension2.height, dimension.height);
            dimension = new Dimension(n, n2);
            this.g.setPreferredSize(dimension);
            this.g.setMinimumSize(dimension);
            this.g.setMaximumSize(dimension);
            this.g.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IlvPalette ilvPalette = IlvPaletteGUI.this._tree.getSelectedPalette();
                    if (ilvPalette != null) {
                        IlvPaletteGUI.this.h.remove(ilvPalette);
                    }
                }
            });
            box3.add(Box.createVerticalStrut(5));
            box3.add(this.g);
        }
        dimension2 = new Dimension(n, n2);
        dimension3 = new Dimension(n, dimension3.height);
        jButton.setMinimumSize(dimension2);
        jButton.setPreferredSize(dimension2);
        jButton.setMaximumSize(dimension2);
        jCheckBox.setMinimumSize(dimension3);
        jCheckBox.setPreferredSize(dimension3);
        box3.add(Box.createVerticalGlue());
        box3.add(jCheckBox);
        box3.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 3));
        jPanel.add((Component)box3, "After");
        this._tree = new IlvPaletteManagerCollapsibleTreeViewer();
        this._tree.setPaletteManager(this.h);
        this._tree.setEditable(false);
        this._tree.getComponent().setBorder(BorderFactory.createEtchedBorder());
        this._tree.getComponent().setMinimumSize(new Dimension(200, 100));
        this.i = new IlvSymbolUtils.SymbolPreview(this.h);
        dimension = new IlvJManagerViewPanel();
        dimension.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                IlvPaletteGUI.this.i.attachPaletteMgr(IlvPaletteGUI.this.h);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                IlvPaletteGUI.this.i.attachPaletteMgr(null);
            }
        });
        IlvManagerView ilvManagerView = dimension.getManagerView();
        ilvManagerView.setManager((IlvManager)this.i.getSDMEngine().getGrapher());
        this.i.getSDMEngine().setReferenceView(ilvManagerView);
        ilvManagerView.setZoomFactorRange(1.0, 1.0);
        ilvManagerView.setAutoFitToContents(true);
        dimension.setBackground(Color.white);
        dimension.setMinimumSize(new Dimension(300, 100));
        dimension.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder()));
        this._tree.addPaletteViewerListener(new PaletteViewerListener(){

            public void symbolSelected(PaletteViewerEvent paletteViewerEvent) {
                IlvPaletteSymbol ilvPaletteSymbol = paletteViewerEvent.getSymbol();
                this.a(ilvPaletteSymbol);
            }

            public void categorySelected(PaletteViewerEvent paletteViewerEvent) {
                this.a(null);
            }

            public void categoryDeselected(PaletteViewerEvent paletteViewerEvent) {
                this.a(null);
            }

            public void symbolDeselected(PaletteViewerEvent paletteViewerEvent) {
                this.a(null);
            }

            private void a(IlvPaletteSymbol ilvPaletteSymbol) {
                IlvPaletteGUI.this.i.previewSymbol(ilvPaletteSymbol);
                IlvPaletteGUI.this.a(ilvPaletteSymbol);
            }
        });
        this._tree.addPropertyChangeListener("current_palette", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IlvPaletteGUI.this.a();
                IlvPaletteSymbol ilvPaletteSymbol = IlvPaletteGUI.this._tree.getSelectedSymbol();
                if (ilvPaletteSymbol != null && ilvPaletteSymbol.getPalette() != propertyChangeEvent.getNewValue()) {
                    ilvPaletteSymbol = null;
                }
                IlvPaletteGUI.this.a(ilvPaletteSymbol);
            }
        });
        JSplitPane jSplitPane = new JSplitPane(1, this._tree.getComponent(), (Component)((Object)dimension));
        jSplitPane.setBackground(Color.white);
        jSplitPane.setDividerLocation(200);
        this.d = this.c();
        this.c = new JSplitPane(0);
        this.c.setLeftComponent(jSplitPane);
        this.c.setResizeWeight(1.0);
        jPanel.add((Component)this.c, "Center");
        box2.add(jPanel);
        box2.add(Box.createVerticalStrut(5));
        this.b.add((Component)box2, "Center");
    }

    private JPanel c() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(600, 300));
        this.e = new JEditorPane(){

            @Override
            public URL getPage() {
                return null;
            }
        };
        this.e.setContentType("text/html");
        this.e.setEditable(false);
        this.f = new JScrollPane();
        this.f.getViewport().add(this.e);
        jPanel.add((Component)this.f, "Center");
        return jPanel;
    }

    private void d() {
        this.c.setRightComponent(null);
        this.c.setResizeWeight(1.0);
    }

    private void e() {
        this.c.setRightComponent(this.d);
        this.c.setResizeWeight(0.5);
        this.a(this._tree.getSelectedSymbol());
    }

    private void a(IlvPaletteSymbol ilvPaletteSymbol) {
        Object object;
        if (this.c.getRightComponent() != this.d) {
            return;
        }
        if (this.a == null) {
            this.e.setText(j.getString("IlvPaletteGUI.documentationNotAvailable"));
            return;
        }
        boolean bl = false;
        try {
            if (ilvPaletteSymbol != null) {
                object = this.a.createPaletteObjectsDocumentation(new IlvPaletteObject[]{ilvPaletteSymbol});
                this.e.setPage((URL)object);
            } else {
                bl = true;
            }
        }
        catch (IOException iOException) {
            bl = true;
        }
        if (bl) {
            object = this._tree.getSelectedPalette();
            if (object != null) {
                try {
                    Locale locale = IlvLocaleUtil.getCurrentLocale();
                    Object[] objectArray = new Object[]{object.getName(locale), object.getDescription(locale), object.getJarURL().toExternalForm()};
                    this.e.setText(this.k.format(objectArray));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JScrollBar jScrollBar = IlvPaletteGUI.this.f.getHorizontalScrollBar();
                            if (jScrollBar != null) {
                                jScrollBar.setValue(jScrollBar.getMinimum());
                            }
                        }
                    });
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.e.setText(j.getString("IlvPaletteGUI.documentationNotAvailable"));
                }
            } else {
                this.e.setText(j.getString("IlvPaletteGUI.emptyPaletteSelection"));
            }
        }
    }

    private class PaletteManagerListenerImpl
    implements PaletteManagerListener {
        private PaletteManagerListenerImpl() {
        }

        public void paletteAdded(PaletteManagerEvent paletteManagerEvent) {
            IlvPalette ilvPalette = paletteManagerEvent.getPalette();
            IlvPaletteGUI.this._tree.select(ilvPalette, true);
        }

        public void paletteRemoved(PaletteManagerEvent paletteManagerEvent) {
        }
    }
}

