/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.undo;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.hypergraph.undo.IlvGraphicEdit;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public abstract class IlvAbstractGraphicEdit
extends AbstractUndoableEdit
implements IlvGraphicEdit {
    private IlvGraphic a;

    protected IlvAbstractGraphicEdit() {
    }

    @Override
    public void before(IlvGraphic ilvGraphic) {
        this.a = ilvGraphic;
    }

    @Override
    public void after(IlvGraphic ilvGraphic) {
        if (ilvGraphic != this.a) {
            throw new IllegalArgumentException("Different graphic object in before and after");
        }
    }

    public IlvGraphic getObject() {
        return this.a;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.a == null) {
            return;
        }
        if (this.a.getGraphicBag() == null) {
            this.undoImpl(this.a);
        } else {
            this.a.getGraphicBag().applyToObject(this.a, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvAbstractGraphicEdit.this.undoImpl(ilvGraphic);
                }
            }, null, true);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.a == null) {
            return;
        }
        if (this.a.getGraphicBag() == null) {
            this.redoImpl(this.a);
        } else {
            this.a.getGraphicBag().applyToObject(this.a, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvAbstractGraphicEdit.this.redoImpl(ilvGraphic);
                }
            }, null, true);
        }
    }

    protected abstract void undoImpl(IlvGraphic var1) throws CannotRedoException;

    protected abstract void redoImpl(IlvGraphic var1) throws CannotRedoException;
}

