/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.edgeconnector;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvHyperEdge;
import ilog.views.hypergraph.IlvHyperEdgeEnd;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgeConnectorWithCache;
import ilog.views.hypergraph.internal.IlvGeometryUtil;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.io.IOException;

public class IlvHyperEdgeClippingConnector
extends IlvHyperEdgeConnectorWithCache {
    private boolean a;

    public IlvHyperEdgeClippingConnector() {
        this.a = false;
    }

    public IlvHyperEdgeClippingConnector(IlvGraphic ilvGraphic) {
        super(ilvGraphic);
        this.a = false;
    }

    public IlvHyperEdgeClippingConnector(IlvHyperEdgeClippingConnector ilvHyperEdgeClippingConnector) {
        super(ilvHyperEdgeClippingConnector);
        this.a = ilvHyperEdgeClippingConnector.a;
    }

    public IlvHyperEdgeClippingConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readBoolean("clipToCenter");
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("clipToCenter", this.a);
    }

    public IlvGraphic copy() {
        return new IlvHyperEdgeClippingConnector(this);
    }

    @Override
    public boolean isGraphic() {
        return false;
    }

    @Override
    protected IlvPoint calcConnectionPoint(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
        if (ilvGraphic == null || ilvHyperEdge == null) {
            throw new RuntimeException("Hyperedge end is not connected");
        }
        if (ilvHyperEdge == this.getOwner()) {
            ilvGraphic = ilvHyperEdge.getVisibleEndNode(ilvGraphic);
        } else if (this.getOwner() != null && !(this.getOwner() instanceof IlvHyperEdge)) {
            ilvGraphic = this.getOwner();
        }
        IlvTransformer ilvTransformer2 = IlvGeometryUtil.getTransformerFromTo(ilvHyperEdge, ilvTransformer, ilvGraphic);
        IlvPoint[] ilvPointArray = ilvHyperEdge.getUnclippedSegmentPoints(ilvHyperEdgeEnd, ilvTransformer);
        if (this.a) {
            ilvPointArray[0] = this.getClosestConnectionPoint(ilvHyperEdgeEnd, ilvPointArray[0], ilvTransformer);
        }
        return IlvClippingUtil.getClippedPoint((IlvGraphic)ilvGraphic, (IlvTransformer)ilvTransformer2, (IlvPoint)ilvPointArray[0], (IlvPoint)ilvPointArray[1]);
    }

    @Override
    public IlvPoint getClosestConnectionPoint(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (!this.a) {
            return new IlvPoint(ilvPoint);
        }
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
        if (ilvGraphic == null || ilvHyperEdge == null) {
            throw new RuntimeException("Hyperedge end is not connected");
        }
        if (ilvHyperEdge == this.getOwner()) {
            ilvGraphic = ilvHyperEdge.getVisibleEndNode(ilvGraphic);
        } else if (this.getOwner() != null && !(this.getOwner() instanceof IlvHyperEdge)) {
            ilvGraphic = this.getOwner();
        }
        IlvTransformer ilvTransformer2 = IlvGeometryUtil.getTransformerFromTo(ilvHyperEdge, ilvTransformer, ilvGraphic);
        IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer2);
        return new IlvPoint(ilvRect.x + 0.5f * ilvRect.width, ilvRect.y + 0.5f * ilvRect.height);
    }

    public void setClipToCenter(boolean bl) {
        this.a = bl;
        this.adjustAll();
    }

    public boolean isClipToCenter() {
        return this.a;
    }
}

