/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.crossing;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.hypergraph.crossing.IlvCrossingAwareObject;
import ilog.views.hypergraph.crossing.IlvCrossingGraphic;
import ilog.views.hypergraph.internal.IlvGeometryUtil;
import ilog.views.internal.IlvBoundingBoxCache;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public abstract class IlvAbstractCrossingGraphic
extends IlvGraphic
implements IlvCrossingGraphic {
    private IlvCrossingAwareObject a;
    private IlvBoundingBoxCache b = new IlvBoundingBoxCache(3);
    private transient boolean c = false;

    public IlvAbstractCrossingGraphic(IlvCrossingAwareObject ilvCrossingAwareObject) {
        this.a = ilvCrossingAwareObject;
    }

    public IlvAbstractCrossingGraphic(IlvAbstractCrossingGraphic ilvAbstractCrossingGraphic) {
        super((IlvGraphic)ilvAbstractCrossingGraphic);
    }

    public IlvAbstractCrossingGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        try {
            this.a = (IlvCrossingAwareObject)ilvInputStream.readObject("object");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        IlvGraphicBag ilvGraphicBag2 = this.getGraphicBag();
        if (ilvGraphicBag != ilvGraphicBag2) {
            SelectionListener selectionListener;
            if (ilvGraphicBag2 != null && (selectionListener = SelectionListener.a(ilvGraphicBag2, false)) != null) {
                selectionListener.b();
            }
            if (ilvGraphicBag != null && (selectionListener = SelectionListener.a(ilvGraphicBag, true)) != null) {
                selectionListener.a();
            }
        }
        super.setGraphicBag(ilvGraphicBag);
    }

    public IlvCrossingAwareObject getRelatedObject() {
        return this.a;
    }

    public void setRelatedObject(IlvCrossingAwareObject ilvCrossingAwareObject) {
        if (this.getGraphicBag() != null) {
            throw new RuntimeException("Cannot change the related object while crossing graphic is in grapher");
        }
        this.a = ilvCrossingAwareObject;
    }

    public boolean zoomable() {
        return false;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.a != null) {
            IlvTransformer ilvTransformer2 = IlvGeometryUtil.getTransformerFromTo((IlvGraphic)this.a, this);
            if (ilvTransformer2 == null) {
                ilvTransformer2 = ilvTransformer;
            } else {
                ilvTransformer2.compose(ilvTransformer);
            }
            this.a.drawCrossingGraphic(graphics, ilvTransformer2);
        }
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.a == null) {
            return false;
        }
        IlvPoint ilvPoint3 = ilvPoint;
        IlvTransformer ilvTransformer2 = IlvGeometryUtil.getTransformerFromTo((IlvGraphic)this.a, this);
        if (ilvTransformer2 == null) {
            ilvTransformer2 = ilvTransformer;
        } else {
            ilvTransformer2.compose(ilvTransformer);
            ilvPoint3 = new IlvPoint(ilvPoint);
            ilvTransformer2.inverse(ilvPoint3);
        }
        return this.a.containsAtCrossingGraphic(ilvPoint3, ilvPoint2, ilvTransformer2);
    }

    @Override
    public boolean containsAtCrossing(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvCrossingAwareObject ilvCrossingAwareObject, IlvCrossingAwareObject ilvCrossingAwareObject2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvPoint ilvPoint6, float f, float f2, float f3) {
        return false;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (this.a == null) {
            float f = 1.0E-7f;
            return new IlvRect(0.0f, 0.0f, f, f);
        }
        IlvRect ilvRect = this.b.get(ilvTransformer);
        if (ilvRect == null) {
            IlvTransformer ilvTransformer2 = IlvGeometryUtil.getTransformerFromTo((IlvGraphic)this.a, this);
            if (ilvTransformer2 == null) {
                ilvTransformer2 = ilvTransformer;
            } else {
                ilvTransformer2.compose(ilvTransformer);
            }
            ilvRect = this.calcBoundingBox(ilvTransformer2);
            this.b.put(ilvTransformer, ilvRect);
        }
        return ilvRect;
    }

    public void setBoundingBoxCacheSize(int n) {
        this.b.setSize(n);
    }

    public int getBoundingBoxCacheSize() {
        return this.b.getSize();
    }

    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        return this.a.boundingBoxCrossingGraphic(ilvTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlvRect calcBoundingBoxOfLink(IlvTransformer ilvTransformer) {
        if (this.a == null) {
            return null;
        }
        IlvGraphic ilvGraphic = (IlvGraphic)this.a;
        boolean bl = this.isInsideCalcBoundingBoxOfLink();
        try {
            this.c = true;
            IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
            return ilvRect;
        }
        finally {
            this.c = bl;
        }
    }

    public boolean isInsideCalcBoundingBoxOfLink() {
        return this.c;
    }

    @Override
    public void crossingChanged() {
        this.b.setInvalid();
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        if (this.a != null) {
            ilvOutputStream.write("object", (IlvGraphic)this.a);
        }
    }

    static final class SelectionListener
    implements ManagerSelectionListener {
        private IlvGrapher a;
        private int b = 0;
        private static final String c = "__IlvAbstractCrossingGraphicSelectionListenerProperty".intern();

        SelectionListener() {
        }

        static SelectionListener a(IlvGraphicBag ilvGraphicBag, boolean bl) {
            IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphicBag;
            if (ilvGrapher == null) {
                return null;
            }
            SelectionListener selectionListener = (SelectionListener)ilvGrapher.getProperty(c);
            if (selectionListener == null && bl) {
                selectionListener = new SelectionListener();
                selectionListener.a = ilvGrapher;
                ilvGrapher.addManagerSelectionListener((ManagerSelectionListener)selectionListener);
                ilvGrapher.setProperty(c, (Object)selectionListener);
            }
            return selectionListener;
        }

        void a() {
            ++this.b;
        }

        void b() {
            --this.b;
            if (this.b <= 0) {
                this.c();
            }
        }

        private void c() {
            if (this.a != null) {
                this.a.removeManagerSelectionListener((ManagerSelectionListener)this);
                this.a.removeProperty(c);
                this.a = null;
            }
        }

        public void selectionChanged(ManagerSelectionChangedEvent managerSelectionChangedEvent) {
            IlvGraphic ilvGraphic;
            IlvGraphic ilvGraphic2 = managerSelectionChangedEvent.getGraphic();
            if (ilvGraphic2 != null && ilvGraphic2 instanceof IlvAbstractCrossingGraphic && (ilvGraphic = (IlvGraphic)((IlvAbstractCrossingGraphic)ilvGraphic2).a) != null) {
                IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphic2.getGraphicBag();
                IlvGrapher ilvGrapher2 = (IlvGrapher)ilvGraphic.getGraphicBag();
                if (ilvGrapher != null && ilvGrapher.isSelected(ilvGraphic2)) {
                    ilvGrapher.setSelected(ilvGraphic2, false, true);
                    if (ilvGrapher2 != null && !ilvGrapher2.isSelected(ilvGraphic)) {
                        ilvGrapher2.setSelected(ilvGraphic, true, true);
                    }
                }
            }
        }
    }
}

