/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.internalutil;

import ilog.views.IlvManager;
import ilog.views.graphlayout.internalutil.IlvLayoutInterface;
import ilog.views.graphlayout.internalutil.IlvLayoutParamControlBlock;

public abstract class IlvManagerPropertyAdapter {
    IlvManager a;

    public IlvManagerPropertyAdapter(IlvManager ilvManager) {
        if (ilvManager == null) {
            throw new IllegalArgumentException("the manager argument cannot be null");
        }
        this.a = ilvManager;
    }

    public IlvManager getManager() {
        return this.a;
    }

    protected abstract Object allocateLayoutClass(String var1);

    protected abstract void attachIfNotAlreadyAttached(Object var1);

    protected abstract void createLayoutProperties(Object var1, String var2, boolean var3);

    protected abstract boolean allowTransferParametersToNamedProperties(Object var1);

    public String saveParametersToNamedProperties(IlvLayoutInterface ilvLayoutInterface, String string, boolean bl) {
        if (!ilvLayoutInterface.supportsSaveParametersToNamedProperties()) {
            throw new RuntimeException("this layout class does not support saving parameters to named properties");
        }
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.GetOrCreate(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return null;
        }
        Object object = ilvLayoutInterface.getLayout();
        String string2 = ilvLayoutParamControlBlock.push(string, object);
        Object object2 = ilvLayoutInterface.getModel();
        ilvManager.setNamedProperty(ilvLayoutInterface.createLayoutManagerProperty(string2, bl));
        if (!this.allowTransferParametersToNamedProperties(object2)) {
            return string2;
        }
        this.createLayoutProperties(object, string2, bl);
        return string2;
    }

    public Object loadParametersInternal(IlvLayoutInterface ilvLayoutInterface, String string) {
        String string2;
        Object object;
        Object object2 = object = ilvLayoutInterface != null ? ilvLayoutInterface.getLayout() : null;
        if (string == null && object == null) {
            throw new IllegalArgumentException("layout and propertyPrefix cannot be both null");
        }
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return null;
        }
        String string3 = string2 = string != null && string.length() > 0 ? ilvLayoutParamControlBlock.searchLayoutId(string) : ilvLayoutParamControlBlock.searchLayoutId(object.getClass());
        if (string2 != null) {
            if (object == null) {
                object = this.allocateLayoutClass(ilvLayoutParamControlBlock.getLayoutName(string2));
            }
            if (object == null) {
                return null;
            }
            this.attachIfNotAlreadyAttached(object);
            this.transferNamedPropertyToLayout(string2, ilvManager, object);
            ilvLayoutParamControlBlock.remove(string2);
            if (ilvLayoutParamControlBlock.isEmpty()) {
                IlvLayoutParamControlBlock.Remove(ilvManager);
            }
            return object;
        }
        return null;
    }

    public void removeParametersFromNamedProperties() {
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return;
        }
        String[] stringArray = ilvLayoutParamControlBlock.getAllLayoutIds();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.removeNamedPropertyFromManager(stringArray[i])) continue;
            ilvLayoutParamControlBlock.remove(stringArray[i]);
        }
        if (ilvLayoutParamControlBlock.isEmpty()) {
            IlvLayoutParamControlBlock.Remove(ilvManager);
        }
    }

    public void removeParametersFromNamedProperties(String string) {
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return;
        }
        String string2 = ilvLayoutParamControlBlock.searchLayoutId(string);
        if (string2 != null) {
            if (this.removeNamedPropertyFromManager(string2)) {
                ilvLayoutParamControlBlock.remove(string2);
            }
            if (ilvLayoutParamControlBlock.isEmpty()) {
                IlvLayoutParamControlBlock.Remove(ilvManager);
            }
        }
    }

    public void removeParametersFromNamedProperties(Class clazz) {
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return;
        }
        String string = ilvLayoutParamControlBlock.searchLayoutId(clazz);
        while (string != null) {
            if (this.removeNamedPropertyFromManager(string)) {
                ilvLayoutParamControlBlock.remove(string);
            }
            string = ilvLayoutParamControlBlock.searchLayoutId(clazz);
        }
        if (ilvLayoutParamControlBlock.isEmpty()) {
            IlvLayoutParamControlBlock.Remove(ilvManager);
        }
    }

    public void setPreferredLayoutPropertyPrefix(String string) {
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return;
        }
        ilvLayoutParamControlBlock.setPreferredLayoutId(string);
    }

    public String getPreferredLayoutPropertyPrefix() {
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return null;
        }
        return ilvLayoutParamControlBlock.getPreferredLayoutId();
    }

    public String getLayoutPropertyPrefix(Object object) {
        IlvManager ilvManager = this.getManager();
        IlvLayoutParamControlBlock ilvLayoutParamControlBlock = IlvLayoutParamControlBlock.Get(ilvManager);
        if (ilvLayoutParamControlBlock == null) {
            return null;
        }
        return ilvLayoutParamControlBlock.searchLayoutId(object.getClass());
    }

    protected abstract void transferNamedPropertyToLayout(String var1, IlvManager var2, Object var3);

    protected abstract boolean removeNamedPropertyFromManager(String var1);
}

