/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.internalutil;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerExpansionEvent;
import ilog.views.event.ManagerExpansionListener;
import ilog.views.event.ManagerLayerEvent;
import ilog.views.event.ManagerLayerInsertedEvent;
import ilog.views.event.ManagerLayerListener;
import ilog.views.event.ManagerLayerMovedEvent;
import ilog.views.event.ManagerLayerRemovedEvent;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.event.ObjectLayerChangedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.graphlayout.internalutil.GenericLayoutUtil;
import ilog.views.graphlayout.internalutil.IlvLayerGraphicEnumeration;
import ilog.views.graphlayout.internalutil.IlvLayoutInterface;
import ilog.views.graphlayout.internalutil.IlvManagerPropertyAdapter;
import java.util.Enumeration;
import java.util.Vector;

public abstract class IlvManagerAdapter
extends IlvManagerPropertyAdapter
implements ManagerContentChangedListener,
ManagerLayerListener,
ManagerViewsChangedListener,
TransformerListener,
ManagerExpansionListener {
    public static final int DONT_FIRE_EVENT = -1;
    private static final String a = "This object has been disposed and cannot be used";
    private int b = 0;
    private IlvManagerView c;
    private IlvManagerView d;
    private IlvTransformer e;
    private IlvTransformer f;
    private IlvTransformer g = new IlvTransformer();
    private boolean h;
    private ObjectTranslator i = new ObjectTranslator();
    private int j;
    private IlvManagerView k;
    private IlvTransformer l;
    private IlvTransformer m;
    private int n;
    private static final Boolean o = Boolean.TRUE;
    private Vector p;
    private boolean q = true;
    private String r;
    private String s;

    public IlvManagerAdapter(IlvManager ilvManager, String string, String string2) {
        super(ilvManager);
        this.r = string;
        this.s = string2;
        this.a();
    }

    protected abstract boolean isDefaultModelClass(Object var1);

    @Override
    protected boolean allowTransferParametersToNamedProperties(Object object) {
        return this.isDefaultModelClass(object);
    }

    private void a() {
        ((IlvManagerPropertyAdapter)this).a.removeManagerContentChangedListener((ManagerContentChangedListener)this);
        ((IlvManagerPropertyAdapter)this).a.addManagerContentChangedListener((ManagerContentChangedListener)this);
        ((IlvManagerPropertyAdapter)this).a.removeManagerLayerListener((ManagerLayerListener)this);
        ((IlvManagerPropertyAdapter)this).a.addManagerLayerListener((ManagerLayerListener)this);
        ((IlvManagerPropertyAdapter)this).a.removeManagerViewsListener((ManagerViewsChangedListener)this);
        ((IlvManagerPropertyAdapter)this).a.addManagerViewsListener((ManagerViewsChangedListener)this);
        ((IlvManagerPropertyAdapter)this).a.removeManagerExpansionListener((ManagerExpansionListener)this);
        ((IlvManagerPropertyAdapter)this).a.addManagerExpansionListener((ManagerExpansionListener)this);
        Enumeration enumeration = ((IlvManagerPropertyAdapter)this).a.getViews();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                ilvManagerView.removeTransformerListener((TransformerListener)this);
                ilvManagerView.addTransformerListener((TransformerListener)this);
            }
        }
    }

    private void b() {
        ((IlvManagerPropertyAdapter)this).a.removeManagerContentChangedListener((ManagerContentChangedListener)this);
        ((IlvManagerPropertyAdapter)this).a.removeManagerLayerListener((ManagerLayerListener)this);
        ((IlvManagerPropertyAdapter)this).a.removeManagerViewsListener((ManagerViewsChangedListener)this);
        ((IlvManagerPropertyAdapter)this).a.removeManagerExpansionListener((ManagerExpansionListener)this);
        Enumeration enumeration = ((IlvManagerPropertyAdapter)this).a.getViews();
        while (enumeration.hasMoreElements()) {
            IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
            ilvManagerView.removeTransformerListener((TransformerListener)this);
        }
    }

    public final void dispose() {
        if (this.p != null) {
            for (int i = 0; i < this.p.size(); ++i) {
                ((IlvManagerLayer)this.p.elementAt(i)).setProperty(this.s, null);
            }
            this.p = null;
        }
        if (((IlvManagerPropertyAdapter)this).a != null) {
            this.b();
            ((IlvManagerPropertyAdapter)this).a = null;
        }
        this.d = null;
        this.e = null;
        this.f = null;
        this.c = null;
        this.k = null;
        this.l = null;
        this.m = null;
    }

    public final void clean(IlvLayoutInterface ilvLayoutInterface) {
        this.c(ilvLayoutInterface);
    }

    public void moveObject(Object object, float f, float f2, boolean bl) {
        if (((IlvManagerPropertyAdapter)this).a == null) {
            throw new RuntimeException(a);
        }
        IlvGraphic ilvGraphic = (IlvGraphic)object;
        switch (this.getCoordinatesMode()) {
            case 0: {
                IlvTransformer ilvTransformer = this.getReferenceTransformer();
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    IlvRect ilvRect = ilvGraphic.boundingBox(null);
                    IlvRect ilvRect2 = ilvGraphic.boundingBox(ilvTransformer);
                    ilvTransformer.inverse(ilvRect2);
                    f -= ilvRect2.x - ilvRect.x;
                    f2 -= ilvRect2.y - ilvRect.y;
                }
                ((IlvManagerPropertyAdapter)this).a.moveObject(ilvGraphic, f, f2, bl);
                break;
            }
            case 1: {
                ((IlvManagerPropertyAdapter)this).a.moveObject(ilvGraphic, f, f2, bl);
                break;
            }
            case 2: {
                IlvTransformer ilvTransformer = this.getReferenceTransformer();
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
                    float f3 = (float)((double)(f - ilvRect.x) / ilvTransformer.zoomXFactor());
                    float f4 = (float)((double)(f2 - ilvRect.y) / ilvTransformer.zoomYFactor());
                    this.i.a(ilvGraphic, f3, f4, bl);
                    break;
                }
                ((IlvManagerPropertyAdapter)this).a.moveObject(ilvGraphic, f, f2, bl);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported coordinates mode: " + this.getCoordinatesMode());
            }
        }
    }

    public IlvRect boundingBox(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (!(object instanceof IlvGraphic)) {
            throw new IllegalArgumentException("Unexpected object type: " + object.getClass());
        }
        IlvGraphic ilvGraphic = (IlvGraphic)object;
        switch (this.getCoordinatesMode()) {
            case 0: {
                return GenericLayoutUtil.BoundingBox(ilvGraphic, this.getReferenceTransformer());
            }
            case 1: {
                return ilvGraphic.boundingBox(null);
            }
            case 2: {
                return ilvGraphic.boundingBox(this.getReferenceTransformer());
            }
        }
        throw new IllegalArgumentException("unsupported coordinates mode: " + this.getCoordinatesMode());
    }

    public boolean isLayoutNeeded(IlvLayoutInterface ilvLayoutInterface) {
        StateDescription stateDescription = this.a(this.b(ilvLayoutInterface));
        if (stateDescription == null) {
            return true;
        }
        int n = ilvLayoutInterface.getCoordinatesMode();
        if (n != stateDescription.b()) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        IlvTransformer ilvTransformer = this.getReferenceTransformer();
        IlvTransformer ilvTransformer2 = stateDescription.a();
        if (ilvTransformer == null) {
            return ilvTransformer2 != null;
        }
        if (ilvTransformer2 == null) {
            return true;
        }
        return ilvTransformer.getx11() != ilvTransformer2.getx11() || ilvTransformer.getx12() != ilvTransformer2.getx12() || ilvTransformer.getx21() != ilvTransformer2.getx21() || ilvTransformer.getx22() != ilvTransformer2.getx22();
    }

    public void beforeLayout(IlvLayoutInterface ilvLayoutInterface, boolean bl) {
        ilvLayoutInterface.setOriginalCoordModeOfModel(this.getCoordinatesMode());
        this.b = ilvLayoutInterface.getCoordinatesMode();
        this.f = null;
        this.h = true;
        if (((IlvManagerPropertyAdapter)this).a != null) {
            ((IlvManagerPropertyAdapter)this).a.setContentsAdjusting(true);
            if (this.n < 0) {
                throw new RuntimeException("negative layout start counter: " + this.n);
            }
            if (this.n == 0) {
                this.prepareManager(((IlvManagerPropertyAdapter)this).a, ilvLayoutInterface, bl);
            }
            ++this.n;
        }
    }

    protected void prepareManager(IlvManager ilvManager, IlvLayoutInterface ilvLayoutInterface, boolean bl) {
        if (bl && ilvManager != null && ilvLayoutInterface != null && ilvLayoutInterface.getLayout() != null) {
            ilvManager.initReDraws();
        }
    }

    public void afterLayout(IlvLayoutInterface ilvLayoutInterface, boolean bl) {
        if (((IlvManagerPropertyAdapter)this).a != null) {
            ((IlvManagerPropertyAdapter)this).a.setContentsAdjusting(false);
            --this.n;
            if (this.n < 0) {
                throw new RuntimeException("negative start layout count");
            }
            if (this.n == 0) {
                this.redrawAfterLayout(((IlvManagerPropertyAdapter)this).a, ilvLayoutInterface, bl);
            }
            this.a(ilvLayoutInterface);
        }
        this.b = ilvLayoutInterface.getOriginalCoordModeOfModel();
        this.f = null;
        this.h = false;
    }

    protected void redrawAfterLayout(IlvManager ilvManager, IlvLayoutInterface ilvLayoutInterface, boolean bl) {
        if (ilvManager != null && bl) {
            ilvManager.reDrawViews();
        }
    }

    private void a(IlvLayoutInterface ilvLayoutInterface) {
        String string = this.b(ilvLayoutInterface);
        StateDescription stateDescription = this.a(string);
        if (stateDescription == null) {
            stateDescription = new StateDescription();
            this.a(string, stateDescription);
        }
        stateDescription.a(this.getReferenceTransformer(), ilvLayoutInterface.getCoordinatesMode());
    }

    private StateDescription a(String string) {
        return (StateDescription)this.b(string);
    }

    private void a(String string, StateDescription stateDescription) {
        this.a(string, (Object)stateDescription);
    }

    private String b(IlvLayoutInterface ilvLayoutInterface) {
        return this.r + "L" + ilvLayoutInterface.getInstanceId();
    }

    private void c(IlvLayoutInterface ilvLayoutInterface) {
        String string = this.b(ilvLayoutInterface);
        this.a(string, (Object)null);
    }

    public final void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
        switch (managerContentChangedEvent.getType()) {
            case 4: {
                IlvGraphic ilvGraphic = ((ObjectBBoxChangedEvent)managerContentChangedEvent).getGraphicObject();
                if (ilvGraphic == null) break;
                this.objectGeometryChanged(ilvGraphic, managerContentChangedEvent.isAdjusting());
                break;
            }
            case 1: {
                IlvGraphic ilvGraphic = ((ObjectInsertedEvent)managerContentChangedEvent).getGraphicObject();
                if (ilvGraphic == null) break;
                this.objectAdded(ilvGraphic, managerContentChangedEvent.isAdjusting());
                break;
            }
            case 2: {
                IlvGraphic ilvGraphic = ((ObjectRemovedEvent)managerContentChangedEvent).getGraphicObject();
                if (ilvGraphic == null) break;
                this.objectRemoved(ilvGraphic, managerContentChangedEvent.isAdjusting());
                break;
            }
            case 16: {
                boolean bl;
                ObjectLayerChangedEvent objectLayerChangedEvent;
                IlvGraphic ilvGraphic;
                if (this.p == null || (ilvGraphic = (objectLayerChangedEvent = (ObjectLayerChangedEvent)managerContentChangedEvent).getGraphicObject()) == null) break;
                boolean bl2 = objectLayerChangedEvent.getOldLayer().getProperty(this.s) != null;
                boolean bl3 = bl = objectLayerChangedEvent.getNewLayer().getProperty(this.s) != null;
                if (bl2 == bl) break;
                if (bl) {
                    this.objectMovedFromNonUsedToUsedLayer(ilvGraphic, managerContentChangedEvent.isAdjusting());
                    break;
                }
                this.objectMovedFromUsedToNonUsedLayer(ilvGraphic, managerContentChangedEvent.isAdjusting());
                break;
            }
            case 32: {
                this.adjustmentEnd();
            }
        }
    }

    public final void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
        this.fireModelEvent(null, this.getGeometryChangedEventType(), ((IlvManagerPropertyAdapter)this).a.isContentsAdjusting());
    }

    private void a(IlvManagerView ilvManagerView) {
        if (((IlvManagerPropertyAdapter)this).a == null || ilvManagerView == null) {
            return;
        }
        ilvManagerView.addTransformerListener((TransformerListener)this);
        if (this.e != null || this.d != null) {
            return;
        }
        this.c = this.a(((IlvManagerPropertyAdapter)this).a);
        if (this.c != null && this.c != ilvManagerView) {
            return;
        }
        this.fireModelEvent(null, this.getGeometryChangedEventType(), ((IlvManagerPropertyAdapter)this).a.isContentsAdjusting());
    }

    private void b(IlvManagerView ilvManagerView) {
        if (ilvManagerView == null) {
            return;
        }
        ilvManagerView.removeTransformerListener((TransformerListener)this);
        if (((IlvManagerPropertyAdapter)this).a == null) {
            return;
        }
        if (this.e != null || this.d != null) {
            return;
        }
        if (this.c == ilvManagerView || this.c == null) {
            this.fireModelEvent(null, this.getGeometryChangedEventType(), ((IlvManagerPropertyAdapter)this).a.isContentsAdjusting());
        }
        this.c = this.a(((IlvManagerPropertyAdapter)this).a);
    }

    public final void viewChanged(ManagerViewsChangedEvent managerViewsChangedEvent) {
        if (managerViewsChangedEvent.getType() == 1) {
            this.a(managerViewsChangedEvent.getManagerView());
        } else if (managerViewsChangedEvent.getType() == 2) {
            this.b(managerViewsChangedEvent.getManagerView());
        }
    }

    public final void layerInserted(ManagerLayerInsertedEvent managerLayerInsertedEvent) {
    }

    public final void layerRemoved(ManagerLayerRemovedEvent managerLayerRemovedEvent) {
        IlvManagerLayer ilvManagerLayer = managerLayerRemovedEvent.getLayer();
        this.a(ilvManagerLayer, false);
    }

    public final void layerMoved(ManagerLayerMovedEvent managerLayerMovedEvent) {
    }

    public final void layerChanged(ManagerLayerEvent managerLayerEvent) {
    }

    public void managerCollapsed(ManagerExpansionEvent managerExpansionEvent) {
    }

    public void managerExpanded(ManagerExpansionEvent managerExpansionEvent) {
    }

    private void a(String string, Object object) {
        ((IlvManagerPropertyAdapter)this).a.setProperty(string, object);
    }

    private Object b(String string) {
        return ((IlvManagerPropertyAdapter)this).a.getProperty(string);
    }

    protected abstract int getCoordinatesMode();

    public void setCoordinatesModeInternal(int n) {
        if (n != 1 && n != 2 && n != 0) {
            throw new IllegalArgumentException("Unsupported coordinates mode: " + n);
        }
        if (this.b != n) {
            this.b = n;
            this.fireModelEvent(null, this.getGeometryChangedEventType(), ((IlvManagerPropertyAdapter)this).a.isContentsAdjusting());
        }
    }

    public int getCoordinatesModeInternal() {
        return this.b;
    }

    protected abstract IlvTransformer getReferenceTransformer();

    public void setReferenceTransformerInternal(IlvTransformer ilvTransformer) {
        if (((IlvManagerPropertyAdapter)this).a == null) {
            throw new RuntimeException(a);
        }
        IlvTransformer ilvTransformer2 = this.e;
        this.e = ilvTransformer;
        this.d = null;
        this.f = null;
        if (ilvTransformer2 != ilvTransformer) {
            this.fireModelEvent(null, this.getGeometryChangedEventType(), ((IlvManagerPropertyAdapter)this).a.isContentsAdjusting());
        }
    }

    public IlvTransformer getReferenceTransformerInternal() {
        if (this.e != null) {
            return this.e;
        }
        if (this.h && this.f != null) {
            return this.f;
        }
        if (this.d == null) {
            if (((IlvManagerPropertyAdapter)this).a == null) {
                throw new RuntimeException(a);
            }
            this.c = this.a(((IlvManagerPropertyAdapter)this).a);
            if (this.c == null) {
                this.g.setValues(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
                this.f = this.g;
            } else {
                this.f = ((IlvManagerPropertyAdapter)this).a.getDrawingTransformer(this.c);
            }
        } else {
            this.f = ((IlvManagerPropertyAdapter)this).a.getDrawingTransformer(this.d);
        }
        return this.f;
    }

    public void setReferenceView(IlvManagerView ilvManagerView) {
        if (((IlvManagerPropertyAdapter)this).a == null) {
            throw new RuntimeException(a);
        }
        IlvManagerView ilvManagerView2 = this.d;
        this.d = ilvManagerView;
        this.e = null;
        this.f = ((IlvManagerPropertyAdapter)this).a.getDrawingTransformer(ilvManagerView);
        if (ilvManagerView2 != ilvManagerView) {
            this.fireModelEvent(null, this.getGeometryChangedEventType(), ((IlvManagerPropertyAdapter)this).a.isContentsAdjusting());
        }
    }

    public IlvManagerView getReferenceView() {
        return this.d;
    }

    private final IlvManagerView a(IlvManager ilvManager) {
        if (ilvManager == null) {
            return null;
        }
        Enumeration enumeration = ilvManager.getViews();
        if (enumeration.hasMoreElements()) {
            return (IlvManagerView)enumeration.nextElement();
        }
        return this.a(ilvManager.getParent());
    }

    public final void saveAndEnableViewCoordinates(IlvManager ilvManager, IlvManagerView ilvManagerView) {
        this.j = this.b;
        this.k = this.d;
        this.l = this.e;
        this.m = this.f;
        if (ilvManagerView == null) {
            ilvManagerView = this.a(ilvManager);
        }
        if (ilvManagerView == null) {
            this.d = null;
            this.e = this.getManager().getTopLevelTransformer();
            this.f = null;
        } else {
            this.d = ilvManagerView;
            this.e = null;
            this.f = null;
        }
        this.b = 2;
    }

    public final void restoreAndDisableViewCoordinates() {
        this.b = this.j;
        this.d = this.k;
        this.e = this.l;
        this.f = this.m;
    }

    public void addLayer(IlvManagerLayer ilvManagerLayer) {
        if (ilvManagerLayer == null) {
            throw new IllegalArgumentException("layer cannot be null");
        }
        if (((IlvManagerPropertyAdapter)this).a == null) {
            throw new RuntimeException(a);
        }
        if (ilvManagerLayer.getManager() != ((IlvManagerPropertyAdapter)this).a) {
            throw new IllegalArgumentException("the layer " + ilvManagerLayer.getIndex() + " is not in the encapsulated IlvManager: " + ((IlvManagerPropertyAdapter)this).a + " but in " + ilvManagerLayer.getManager());
        }
        boolean bl = false;
        if (this.p == null) {
            this.p = new Vector(20, 20);
            bl = true;
        } else if (this.p.contains(ilvManagerLayer)) {
            return;
        }
        this.p.addElement(ilvManagerLayer);
        ilvManagerLayer.setProperty(this.s, (Object)o);
        if (bl) {
            if (this.q) {
                int n = ((IlvManagerPropertyAdapter)this).a.getLayersCount();
                for (int i = 0; i < n; ++i) {
                    IlvManagerLayer ilvManagerLayer2 = ((IlvManagerPropertyAdapter)this).a.getManagerLayer(i);
                    if (ilvManagerLayer2 == ilvManagerLayer) continue;
                    this.b(ilvManagerLayer2, false);
                }
            }
        } else {
            this.b(ilvManagerLayer, true);
        }
    }

    public final boolean removeLayer(IlvManagerLayer ilvManagerLayer) {
        return this.a(ilvManagerLayer, true);
    }

    private boolean a(IlvManagerLayer ilvManagerLayer, boolean bl) {
        if (ilvManagerLayer == null) {
            throw new IllegalArgumentException("layer cannot be null");
        }
        if (((IlvManagerPropertyAdapter)this).a == null) {
            throw new RuntimeException(a);
        }
        if (this.p == null || this.p.size() == 0) {
            return false;
        }
        if (bl && ilvManagerLayer.getManager() != ((IlvManagerPropertyAdapter)this).a) {
            throw new IllegalArgumentException("the layer " + ilvManagerLayer.getIndex() + " is not in the encapsulated IlvManager: " + ((IlvManagerPropertyAdapter)this).a + " but in " + ilvManagerLayer.getManager());
        }
        ilvManagerLayer.setProperty(this.s, null);
        if (this.p.size() == 1 && this.p.contains(ilvManagerLayer)) {
            this.removeAllLayers();
            return true;
        }
        if (this.p.remove(ilvManagerLayer)) {
            this.b(ilvManagerLayer, false);
            return true;
        }
        return false;
    }

    public boolean removeAllLayers() {
        IlvManagerLayer ilvManagerLayer;
        if (((IlvManagerPropertyAdapter)this).a == null) {
            throw new RuntimeException(a);
        }
        if (this.p == null) {
            return false;
        }
        for (int i = 0; i < this.p.size(); ++i) {
            ilvManagerLayer = (IlvManagerLayer)this.p.elementAt(i);
            ilvManagerLayer.setProperty(this.s, null);
        }
        Vector vector = this.p;
        this.p = null;
        if (this.q) {
            int n = ((IlvManagerPropertyAdapter)this).a.getLayersCount();
            for (int i = 0; i < n; ++i) {
                ilvManagerLayer = ((IlvManagerPropertyAdapter)this).a.getManagerLayer(i);
                if (vector.contains(ilvManagerLayer)) continue;
                this.b(ilvManagerLayer, true);
            }
        } else {
            this.fireModelEvent(null, this.getStructureChangedEventType(), ((IlvManagerPropertyAdapter)this).a.isContentsAdjusting());
        }
        return true;
    }

    public final Enumeration getLayers() {
        return this.p != null ? this.p.elements() : null;
    }

    public final int getLayersCount() {
        return this.p != null ? this.p.size() : 0;
    }

    public final boolean isLayerAdded(IlvManagerLayer ilvManagerLayer) {
        if (this.getLayersCount() == 0) {
            return false;
        }
        return this.p.contains(ilvManagerLayer);
    }

    public final IlvGraphicEnumeration getObjectsOnLayers() {
        return this.getLayersCount() > 0 ? new IlvLayerGraphicEnumeration(((IlvManagerPropertyAdapter)this).a, this.p) : null;
    }

    public final boolean isManaged(IlvGraphic ilvGraphic) {
        if (ilvGraphic.getGraphicBag() != ((IlvManagerPropertyAdapter)this).a) {
            return false;
        }
        return this.isOnLayers(ilvGraphic);
    }

    public final boolean isOnLayers(IlvGraphic ilvGraphic) {
        if (this.getLayersCount() > 0) {
            IlvManagerLayer ilvManagerLayer = ((IlvManagerPropertyAdapter)this).a.getManagerLayer(ilvGraphic);
            if (ilvManagerLayer == null) {
                throw new RuntimeException("graphic object " + ilvGraphic + " is not contained in a layer of " + ((IlvManagerPropertyAdapter)this).a);
            }
            if (ilvManagerLayer.getProperty(this.s) == null) {
                return false;
            }
        }
        return true;
    }

    private void b(IlvManagerLayer ilvManagerLayer, boolean bl) {
        if (this.q) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManagerLayer.getElements();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                if (ilvGraphic == null) continue;
                if (bl) {
                    this.objectAdded(ilvGraphic, true);
                    continue;
                }
                this.objectRemoved(ilvGraphic, true);
            }
            if (!((IlvManagerPropertyAdapter)this).a.isContentsAdjusting()) {
                this.adjustmentEnd();
            }
        } else {
            this.fireModelEvent(null, this.getStructureChangedEventType(), ((IlvManagerPropertyAdapter)this).a.isContentsAdjusting());
        }
    }

    public void setFullLayerNotification(boolean bl) {
        this.q = bl;
    }

    public final boolean isFullLayerNotification() {
        return this.q;
    }

    protected void objectAdded(Object object, boolean bl) {
        int n = this.getEventTypeWhenAdding(object);
        if (n != -1) {
            this.fireModelEvent(object, n, bl);
        }
    }

    protected void objectRemoved(Object object, boolean bl) {
        int n = this.getEventTypeWhenRemoving(object);
        if (n != -1) {
            this.fireModelEvent(object, n, bl);
        }
    }

    protected final void objectMovedFromNonUsedToUsedLayer(Object object, boolean bl) {
        this.objectAdded(object, bl);
    }

    protected final void objectMovedFromUsedToNonUsedLayer(Object object, boolean bl) {
        this.objectRemoved(object, bl);
    }

    protected final void objectGeometryChanged(Object object, boolean bl) {
        int n = this.getEventTypeWhenChangingGeometry(object);
        if (n != -1) {
            this.fireModelEvent(object, n, bl);
        }
    }

    protected abstract int getStructureChangedEventType();

    protected abstract int getGeometryChangedEventType();

    protected abstract int getEventTypeWhenAdding(Object var1);

    protected abstract int getEventTypeWhenRemoving(Object var1);

    protected abstract int getEventTypeWhenChangingGeometry(Object var1);

    protected abstract void fireModelEvent(Object var1, int var2, boolean var3);

    protected abstract void adjustmentEnd();

    public String toString() {
        return super.toString() + " [" + this.getManager() + "]";
    }

    private static class StateDescription {
        private IlvTransformer a;
        private int b;

        private StateDescription() {
        }

        void a(IlvTransformer ilvTransformer, int n) {
            this.a = ilvTransformer;
            this.b = n;
        }

        IlvTransformer a() {
            return this.a;
        }

        int b() {
            return this.b;
        }
    }

    private class ObjectTranslator
    implements IlvApplyObject {
        private float a;
        private float b;

        private ObjectTranslator() {
        }

        public final void apply(IlvGraphic ilvGraphic, Object object) {
            ilvGraphic.translate(this.a, this.b);
        }

        final void a(IlvGraphic ilvGraphic, float f, float f2, boolean bl) {
            this.a = f;
            this.b = f2;
            ((IlvManagerPropertyAdapter)IlvManagerAdapter.this).a.applyToObject(ilvGraphic, (IlvApplyObject)this, null, bl);
        }
    }
}

