/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.circular;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutGrapherProperty;
import ilog.views.graphlayout.IlvGraphLayoutNodeProperty;
import ilog.views.graphlayout.IlvGraphLayoutReport;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.basic.IlvBasicLinkStyleLayout;
import ilog.views.graphlayout.circular.CLAutoClustering;
import ilog.views.graphlayout.circular.CLCluster;
import ilog.views.graphlayout.circular.CLCrossingReduction;
import ilog.views.graphlayout.circular.CLGraphOfClusters;
import ilog.views.graphlayout.circular.ClusterLayoutAlgo;
import ilog.views.graphlayout.circular.IlvAbstractGraph;
import ilog.views.graphlayout.circular.IlvAbstractGraphicNode;
import ilog.views.graphlayout.circular.IlvCircularLayoutGrapherProperty;
import ilog.views.graphlayout.circular.IlvCircularLayoutNodeProperty;
import ilog.views.graphlayout.circular.IlvCircularLayoutOfSubTrees;
import ilog.views.graphlayout.circular.IlvClusterId;
import ilog.views.graphlayout.circular.IlvClusterIdCollection;
import ilog.views.graphlayout.circular.IlvClusterInfoProperty;
import ilog.views.graphlayout.circular.IlvClustersConnexion;
import ilog.views.graphlayout.circular.IlvGraphOfClusters;
import ilog.views.graphlayout.circular.IlvGrapherCluster;
import ilog.views.graphlayout.internalutil.IlvArrayStableSort;
import ilog.views.graphlayout.internalutil.LayoutParametersUtil;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.LogResUtil;
import ilog.views.graphlayout.internalutil.LogResUtil2;
import ilog.views.graphlayout.internalutil.ReshapeLinkUtil;
import ilog.views.graphlayout.internalutil.galg.ClusteringGraph;
import ilog.views.graphlayout.tree.IlvTreeLayout;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class IlvCircularLayout
extends IlvBasicLinkStyleLayout {
    public static final int NO_INDEX = -1;
    public static final int BY_CLUSTER_IDS = 0;
    public static final int BY_SUBGRAPHS = 1;
    public static final int AUTOMATIC = 2;
    public static final int STRAIGHT_LINE_STYLE = 1;
    public static final int NO_RESHAPE_STYLE = 0;
    static final double a = 1.2566370614359172;
    private transient IlvGraphOfClusters b;
    private transient CLGraphOfClusters c;
    private ArrayList d;
    private ArrayList e;
    private Hashtable f;
    private static final String g = "ClusterId";
    private static final String h = "StarCenter";
    private float i;
    private float j;
    static final float k = 10.0f;
    static final float l = 0.0f;
    static final float m = 10.0f;
    static final boolean n = false;
    static final int o = 0;
    static final int p = 200;
    static final boolean q = true;
    static final float r = 1.0f;
    static final float s = 1.0f;
    static final float t = 1.0f;
    static final boolean u = true;
    static final int v = 4;
    static final int w = 50;
    static final int x = 5;
    static final int y = 10;
    private float z;
    private float aa;
    private float ab;
    private boolean ac;
    private int ad;
    private int ae;
    private IlvGraphLayout af;
    private boolean ag;
    private float ah;
    private float ai;
    private float aj;
    private boolean ak;
    private int al;
    private int am;
    private int an;
    private int ao;
    private boolean ap = false;
    private boolean aq = false;
    static final int ar = 9;
    private IlvArrayStableSort as;
    private transient ClusterLayoutAlgo at;
    private transient Comparator au = new Comparator(){

        public int compare(Object object, Object object2) {
            return IlvCircularLayout.this.a(object, object2);
        }
    };

    public IlvCircularLayout() {
    }

    public IlvCircularLayout(IlvCircularLayout ilvCircularLayout) {
        super(ilvCircularLayout);
    }

    @Override
    public void copyParameters(IlvGraphLayout ilvGraphLayout) {
        super.copyParameters(ilvGraphLayout);
        if (ilvGraphLayout instanceof IlvCircularLayout) {
            IlvCircularLayout ilvCircularLayout = (IlvCircularLayout)ilvGraphLayout;
            this.setOffset(ilvCircularLayout.getOffset());
            this.setLevelOffset(ilvCircularLayout.getLevelOffset());
            this.setDisconnectedGraphOffset(ilvCircularLayout.getDisconnectedGraphOffset());
            this.setAreaMinimizationEnabled(ilvCircularLayout.isAreaMinimizationEnabled());
            this.setClusteringMode(ilvCircularLayout.getClusteringMode());
            this.setMaxNumberOfPermutations(ilvCircularLayout.getMaxNumberOfPermutations());
            this.setInterClusterCrossingReduction(ilvCircularLayout.isInterClusterCrossingReduction());
            this.setIntraClusterLinkCrossingPenalty(ilvCircularLayout.getIntraClusterLinkCrossingPenalty());
            this.setInterClusterLinkCrossingPenalty(ilvCircularLayout.getInterClusterLinkCrossingPenalty());
            this.setMixedClusterLinkCrossingPenalty(ilvCircularLayout.getMixedClusterLinkCrossingPenalty());
            this.setClusterByBiconnectivity(ilvCircularLayout.isClusterByBiconnectivity());
            this.setMinimumClusterSize(ilvCircularLayout.getMinimumClusterSize());
            this.setMaximumClusterSize(ilvCircularLayout.getMaximumClusterSize());
            this.setHighDegreeStarClusterSize(ilvCircularLayout.getHighDegreeStarClusterSize());
            this.setMaximumNumberOfIterationsToReachMaxClusterSize(ilvCircularLayout.getMaximumNumberOfIterationsToReachMaxClusterSize());
            this.a(ilvCircularLayout);
        }
    }

    private void a(IlvCircularLayout ilvCircularLayout) {
        IlvGraphLayout ilvGraphLayout = ilvCircularLayout.af;
        if (this.af == ilvGraphLayout) {
            return;
        }
        if (ilvGraphLayout == null) {
            this.setLayoutOfClusterGraph(null);
        } else if (this.af != null && this.af.getClass() == ilvGraphLayout.getClass()) {
            this.af.copyParameters(ilvGraphLayout);
        } else {
            this.setLayoutOfClusterGraph(ilvGraphLayout.copy());
        }
    }

    @Override
    protected void init() {
        super.init();
        this.z = 10.0f;
        this.aa = 0.0f;
        this.ab = 10.0f;
        this.ac = false;
        this.ad = 0;
        this.ae = 200;
        this.ag = true;
        this.ah = 1.0f;
        this.ai = 1.0f;
        this.aj = 1.0f;
        this.ak = true;
        this.al = 4;
        this.am = 50;
        this.an = 5;
        this.ao = 10;
        this.af = null;
        this.as = new SortNodesByIndex();
    }

    @Override
    public IlvGraphLayout copy() {
        return new IlvCircularLayout(this);
    }

    @Override
    public synchronized void detach() {
        this.e();
        this.d(false);
        super.detach();
    }

    private void e() {
        this.f = null;
        this.f();
    }

    private void f() {
        if (this.at != null) {
            this.at.cleanData();
        }
        this.at = null;
    }

    private void a(IlvRect ilvRect) {
        this.i = ilvRect.x + ilvRect.width * 0.5f;
        this.j = ilvRect.y + ilvRect.height * 0.5f;
    }

    private void g() {
        this.e = null;
        this.b = null;
        this.c = null;
        this.d = null;
    }

    @Override
    protected void internalLayout(boolean bl) throws IlvGraphLayoutException {
        this.checkAppropriateLinks();
        IlvGraphModel ilvGraphModel = this.getGraphModel();
        IlvGraphLayoutReport ilvGraphLayoutReport = this.getLayoutReport();
        IlvRect ilvRect = this.getCalcLayoutRegion();
        this.a(ilvRect);
        if (this.getLinkStyle() == 1) {
            ReshapeLinkUtil.deleteIntermediatePointsOnLinks(ilvGraphModel, this, bl);
        }
        switch (this.getClusteringMode()) {
            case 0: {
                this.a(ilvRect, bl);
                break;
            }
            case 1: {
                this.b(bl);
                break;
            }
            case 2: {
                this.c(bl);
                break;
            }
            default: {
                LogResUtil.logAndThrowRuntimeExc(IlvCircularLayout.class, "graphlayout.expert.message.6326E", this.getClusteringMode());
            }
        }
        ilvGraphLayoutReport.setCode(5);
    }

    private void b(boolean bl) throws IlvGraphLayoutException {
        this.at = new ClusterLayoutAlgo(this);
        this.at.layout(bl);
    }

    private void c(boolean bl) throws IlvGraphLayoutException {
        this.d(false);
        if (!this.clusterize()) {
            LogResUtil2.logAndThrowGraphLayoutExc(IlvCircularLayout.class, "graphlayout.expert.message.6325E");
        }
        this.c.a(this.getOffset());
        IlvGraphLayout ilvGraphLayout = this.getLayoutOfClusterGraph();
        if (ilvGraphLayout != null) {
            ilvGraphLayout.attach(this.c);
            this.customizeLayoutOfClusterGraph(ilvGraphLayout);
            ilvGraphLayout.performLayout(true, false);
            ilvGraphLayout.detach();
        }
        CLCluster[] cLClusterArray = this.c.l();
        CLCrossingReduction cLCrossingReduction = new CLCrossingReduction(cLClusterArray);
        cLCrossingReduction.a(this.getIntraClusterLinkCrossingPenalty(), this.getInterClusterLinkCrossingPenalty(), this.getMixedClusterLinkCrossingPenalty());
        cLCrossingReduction.run(true, this.isInterClusterCrossingReduction());
        this.c.m();
        this.c.a(bl);
        this.c = null;
        this.d(true);
    }

    private void a(IlvRect ilvRect, boolean bl) throws IlvGraphLayoutException {
        this.d(false);
        if (!this.clusterize()) {
            LogResUtil2.logAndThrowGraphLayoutExc(IlvCircularLayout.class, "graphlayout.expert.message.6325E");
        }
        int n = this.d.size();
        for (int i = 0; i < n; ++i) {
            IlvGraphOfClusters ilvGraphOfClusters = (IlvGraphOfClusters)this.d.get(i);
            this.a(ilvGraphOfClusters, bl);
            if (n <= 1) continue;
            ilvGraphOfClusters.d();
        }
        if (n > 1) {
            IlvCircularLayoutOfSubTrees ilvCircularLayoutOfSubTrees = new IlvCircularLayoutOfSubTrees(this.d, this, ilvRect);
            ilvCircularLayoutOfSubTrees.a(bl);
        }
        this.d(true);
    }

    private void a(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
            int n = this.getClusterIdsCount(ilvGraphic);
            if (n > 0) continue;
            IlvClusterInfoProperty ilvClusterInfoProperty = (IlvClusterInfoProperty)ilvGraphic.getNamedProperty("ClusterInfoPropertyName");
            this.a(ilvGraphic, ilvClusterInfoProperty);
        }
    }

    final void a(IlvGraphic ilvGraphic, IlvClusterInfoProperty ilvClusterInfoProperty) {
        if (ilvGraphic == null) {
            return;
        }
        if (ilvClusterInfoProperty == null) {
            return;
        }
        IlvClusterId[] ilvClusterIdArray = ilvClusterInfoProperty.getClusterIds();
        int[] nArray = ilvClusterInfoProperty.getIndexes();
        for (int i = 0; i < ilvClusterIdArray.length; ++i) {
            int n = nArray[i];
            if (n >= 0) {
                this.addClusterId(ilvGraphic, ilvClusterIdArray[i], n);
                continue;
            }
            this.addClusterId(ilvGraphic, ilvClusterIdArray[i]);
        }
        this.setStarCenter(ilvGraphic, ilvClusterInfoProperty.isStarCenter());
    }

    public synchronized void setRootClusterId(IlvClusterId ilvClusterId) {
        this.b(ilvClusterId);
    }

    private void b(IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6327E");
        }
        if (this.f == null) {
            this.f = new Hashtable(100, 100.0f);
        } else if (this.f.containsKey(ilvClusterId)) {
            return;
        }
        this.f.put(ilvClusterId, ilvClusterId);
        this.d(false);
        this.onParameterChanged("Clustering");
    }

    public synchronized void removeRootClusterId(IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6327E");
        }
        if (this.f != null) {
            this.f.remove(ilvClusterId);
            this.d(false);
            this.onParameterChanged("Clustering");
        }
    }

    public synchronized void removeAllRootClusterIds() {
        if (this.f != null) {
            this.f = null;
            this.d(false);
            this.onParameterChanged("Clustering");
        }
    }

    public synchronized void setRootClusterIds(IlvClusterId[] ilvClusterIdArray) {
        this.removeAllRootClusterIds();
        if (ilvClusterIdArray != null) {
            int n = ilvClusterIdArray.length;
            for (int i = 0; i < n; ++i) {
                this.b(ilvClusterIdArray[i]);
            }
        }
    }

    public IlvClusterId[] getRootClusterIds() {
        if (this.f == null) {
            return null;
        }
        int n = this.f.size();
        if (n == 0) {
            return null;
        }
        Enumeration enumeration = this.f.keys();
        IlvClusterId[] ilvClusterIdArray = new IlvClusterId[n];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            ilvClusterIdArray[n2++] = (IlvClusterId)enumeration.nextElement();
        }
        return ilvClusterIdArray;
    }

    private IlvGrapherCluster a(IlvGraphOfClusters ilvGraphOfClusters) {
        IlvClusterId ilvClusterId;
        if (this.f == null) {
            return ilvGraphOfClusters.a();
        }
        IlvGrapherCluster ilvGrapherCluster = null;
        Enumeration enumeration = this.f.keys();
        while (enumeration.hasMoreElements() && (ilvGrapherCluster = ilvGraphOfClusters.getCluster(ilvClusterId = (IlvClusterId)enumeration.nextElement())) == null) {
        }
        if (ilvGrapherCluster == null) {
            return ilvGraphOfClusters.a();
        }
        ilvGraphOfClusters.a(ilvGrapherCluster);
        return ilvGrapherCluster;
    }

    private final void a(IlvGraphOfClusters ilvGraphOfClusters, boolean bl) throws IlvGraphLayoutException {
        Level level;
        IlvGrapherCluster ilvGrapherCluster;
        Iterator iterator = ilvGraphOfClusters.getNodes();
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            ilvGrapherCluster = (IlvGrapherCluster)iterator.next();
            ilvGrapherCluster.a(this.getOffset(), this);
        }
        ilvGrapherCluster = this.a(ilvGraphOfClusters);
        float f = this.getOffset();
        ilvGrapherCluster.a(this.i, this.j);
        this.layoutStepPerformed();
        ilvGrapherCluster.a(true, this, this.i, this.j, 0.0f, f, bl);
        ArrayList<IlvGrapherCluster> arrayList = new ArrayList<IlvGrapherCluster>(10);
        ArrayList arrayList2 = ilvGrapherCluster.e();
        float f2 = ilvGrapherCluster.m();
        int n = 0;
        float f3 = 0.0f;
        double d = 0.0;
        float f4 = 0.0f;
        double d2 = 0.0;
        float f5 = 0.0f;
        double d3 = 0.0;
        float f6 = 0.0f;
        float f7 = 0.0f;
        Level level2 = level = this.isAreaMinimizationEnabled() ? new Level(50) : null;
        if (arrayList2.size() > 1) {
            float f8;
            int n2;
            IlvAbstractGraphicNode ilvAbstractGraphicNode;
            int n3;
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                ilvAbstractGraphicNode = (IlvAbstractGraphicNode)arrayList2.get(n3);
                ArrayList arrayList3 = ilvAbstractGraphicNode.a();
                if (arrayList3 == null || arrayList3.size() < 1) continue;
                int n4 = arrayList3.size();
                for (n2 = 0; n2 < n4; ++n2) {
                    IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)arrayList3.get(n2);
                    if (ilvGrapherCluster2 == null) continue;
                    arrayList.add(ilvGrapherCluster2);
                    float f9 = ilvGrapherCluster2.m();
                    f2 = IlvCircularLayout.a(ilvGrapherCluster2, ilvGrapherCluster, ilvGrapherCluster.m(), f2, f);
                    if (!(f9 > f6)) continue;
                    f6 = f9;
                }
                f7 = f2 - f6;
                double d4 = IlvGrapherCluster.a(ilvAbstractGraphicNode, this.getGraphModel(), this.i, this.j);
                f8 = 0.0f;
                if (this.isAreaMinimizationEnabled() && arrayList.size() > 0) {
                    Interval interval = new Interval();
                    level.a(interval);
                    interval.a(ilvGrapherCluster);
                    interval.a(ilvGraphOfClusters, arrayList3);
                    interval.a(d4);
                    f8 = IlvCircularLayout.a(arrayList3, f7, f);
                }
                f8 = IlvCircularLayout.a(ilvAbstractGraphicNode, f7, f);
                if (n == 0) {
                    f3 = f8;
                    d = d4;
                }
                f4 = f8;
                d2 = d4;
                if (n > 0) {
                    double d5 = LayoutUtil.GetOrientedDeltaAlpha(LayoutUtil.CorrectAngle(d4), LayoutUtil.CorrectAngle(d3));
                    f7 = (float)Math.max((double)f7, (double)((f5 + f8) * 0.5f + f) / d5);
                    f2 = Math.max(f2, f7 + f6);
                }
                f5 = f8;
                d3 = d4;
                ++n;
            }
            if (n > 1) {
                f7 = (float)Math.max((double)f7, (double)((f3 + f4) * 0.5f + f) / LayoutUtil.GetDeltaAlpha(d, d2));
                f2 = Math.max(f2, f7 + f6);
            }
            f2 += this.getLevelOffset();
            if (this.isAreaMinimizationEnabled() && arrayList.size() > 0) {
                float f10 = IlvCircularLayout.b(ilvGrapherCluster, ilvGraphOfClusters);
                float f11 = f2 - f10;
                for (int i = 0; i < level.b(); ++i) {
                    Interval interval = level.b(i);
                    f8 = IlvCircularLayout.a(interval.c(), f11, f);
                    interval.b(f11);
                    interval.a(f8, ilvGrapherCluster.m(), f2);
                    interval.a(interval.c().size());
                }
                level.a(f);
                this.a(level, f2, f, bl);
            } else {
                f7 = f2 - f6;
                n3 = arrayList2.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    ilvAbstractGraphicNode = (IlvAbstractGraphicNode)arrayList2.get(n2);
                    this.a(ilvAbstractGraphicNode, f2, f7, f, bl);
                }
            }
            this.a(arrayList, ilvGraphOfClusters, this.i, this.j, f2, f, bl);
        } else {
            IlvAbstractGraphicNode ilvAbstractGraphicNode = (IlvAbstractGraphicNode)arrayList2.get(0);
            float f12 = LayoutUtil.getDiagonal(ilvAbstractGraphicNode.getGraphicObject(), this.getGraphModel());
            ArrayList arrayList4 = ilvAbstractGraphicNode.a();
            float[] fArray = new float[1];
            if (arrayList4 == null || arrayList4.size() < 1) {
                return;
            }
            f2 = this.a(arrayList4, ilvGrapherCluster, fArray, f, f12) + this.getLevelOffset();
            this.a(arrayList4, ilvGrapherCluster, fArray[0], ilvGraphOfClusters, this.i, this.j, f2, f, bl);
        }
    }

    private final float a(ArrayList arrayList, IlvGrapherCluster ilvGrapherCluster, float[] fArray, float f, float f2) {
        if (arrayList.size() == 1) {
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)arrayList.get(0);
            fArray[0] = ilvGrapherCluster2.m();
            return f2 * 0.5f + f + ilvGrapherCluster2.o();
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        for (int i = 0; i < arrayList.size(); ++i) {
            IlvGrapherCluster ilvGrapherCluster3 = (IlvGrapherCluster)arrayList.get(i);
            float f7 = ilvGrapherCluster3.m();
            float f8 = ilvGrapherCluster3.o();
            f4 += 2.0f * f7 + f;
            if (f8 > f5) {
                f5 = f8;
            }
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        f3 = (float)((double)f4 / (Math.PI * 2));
        f3 = Math.max(f3, f2 * 0.5f + f + f5);
        if (arrayList.size() > 1) {
            ilvGrapherCluster.a(f4);
        } else {
            ilvGrapherCluster.a(0.0f);
        }
        fArray[0] = f6;
        return f3;
    }

    private final void a(ArrayList arrayList, IlvGrapherCluster ilvGrapherCluster, float f, IlvGraphOfClusters ilvGraphOfClusters, float f2, float f3, float f4, float f5, boolean bl) throws IlvGraphLayoutException {
        switch (arrayList.size()) {
            case 0: {
                return;
            }
            case 2: {
                IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)arrayList.get(0);
                IlvGrapherCluster ilvGrapherCluster3 = (IlvGrapherCluster)arrayList.get(1);
                double d = 0.0;
                double d2 = Math.PI;
                ilvGrapherCluster2.a(d);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster2.a(this, d, f2, f3, f4, f5, bl);
                ilvGrapherCluster3.a(d2);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster3.a(this, d2, f2, f3, f4, f5, bl);
                break;
            }
            default: {
                double d = 0.0;
                float f6 = f4 - f;
                float f7 = (float)(Math.PI * 2 * (double)f6 - (ilvGrapherCluster.s() - (double)(f5 * (float)(arrayList.size() - 1)))) / (float)arrayList.size();
                double d3 = LayoutUtil.getEqualSidesTriangleAngle(f6, f7);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    IlvGrapherCluster ilvGrapherCluster4 = (IlvGrapherCluster)arrayList.get(i);
                    float f8 = ilvGrapherCluster4.m();
                    if (i != 0) {
                        d += LayoutUtil.getEqualSidesTriangleAngle(f6, f8);
                    }
                    ilvGrapherCluster4.a(d);
                    this.callLayoutStepPerformedIfNeeded();
                    ilvGrapherCluster4.a(this, d, f2, f3, f4, f5, bl);
                    d += LayoutUtil.getEqualSidesTriangleAngle(f6, f8) + d3;
                }
            }
        }
        if (arrayList.size() > 0) {
            this.a(arrayList, ilvGraphOfClusters, f2, f3, f4, f5, bl);
        }
    }

    private final void a(ArrayList arrayList, IlvGraphOfClusters ilvGraphOfClusters, float f, float f2, float f3, float f4, boolean bl) throws IlvGraphLayoutException {
        IlvGrapherCluster ilvGrapherCluster;
        int n;
        if (arrayList == null || arrayList.size() < 1) {
            return;
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        float f5 = f3;
        int n2 = 0;
        float f6 = 0.0f;
        double d = 0.0;
        float f7 = 0.0f;
        double d2 = 0.0;
        float f8 = 0.0f;
        double d3 = 0.0;
        float[] fArray = new float[]{0.0f};
        float f9 = 0.0f;
        boolean bl2 = this.isAreaMinimizationEnabled();
        Level level = bl2 ? new Level(arrayList.size()) : null;
        int n3 = arrayList.size();
        for (n = 0; n < n3; ++n) {
            ilvGrapherCluster = (IlvGrapherCluster)arrayList.get(n);
            ArrayList arrayList3 = new ArrayList(15);
            f5 = this.a(ilvGrapherCluster, arrayList3, f3, f5, fArray, f4);
            int n4 = arrayList3.size();
            for (int i = 0; i < n4; ++i) {
                arrayList2.add(arrayList3.get(i));
            }
            if (f5 <= 0.0f || n4 < 1) {
                f5 = Math.abs(f5);
                f9 = f5 - fArray[0];
                continue;
            }
            f9 = f5 - fArray[0];
            float f10 = 0.0f;
            double d4 = ilvGrapherCluster.r();
            if (bl2 && arrayList2.size() > 0) {
                Interval interval = new Interval();
                level.a(interval);
                interval.a(ilvGrapherCluster);
                interval.a(ilvGraphOfClusters, arrayList3);
                interval.a(d4);
                f10 = IlvCircularLayout.a(arrayList3, f9, f4);
            } else {
                f10 = IlvCircularLayout.a(ilvGrapherCluster, ilvGraphOfClusters, f9, f4);
            }
            if (n2 == 0) {
                f6 = f10;
                d = d4;
            }
            f7 = f10;
            d2 = d4;
            if (n2 > 0) {
                double d5 = LayoutUtil.GetOrientedDeltaAlpha(LayoutUtil.CorrectAngle(d4), LayoutUtil.CorrectAngle(d3));
                f9 = (float)Math.max((double)f9, (double)((f8 + f10) * 0.5f + f4) / d5);
                f5 = Math.max(f5, f9 + fArray[0]);
            }
            f8 = f10;
            d3 = d4;
            ++n2;
        }
        if (n2 > 1) {
            f9 = (float)Math.max((double)f9, (double)((f6 + f7) * 0.5f + f4) / LayoutUtil.GetDeltaAlpha(d, d2));
            f5 = Math.max(f5, f9 + fArray[0]);
        }
        f5 += this.getLevelOffset();
        if (bl2 && arrayList2.size() > 0) {
            int n5 = level.b();
            for (int i = 0; i < n5; ++i) {
                Interval interval = level.b(i);
                ilvGrapherCluster = interval.a();
                float f11 = IlvCircularLayout.b(ilvGrapherCluster, ilvGraphOfClusters);
                float f12 = f5 - f11;
                float f13 = IlvCircularLayout.a(interval.c(), f12, f4);
                interval.b(f12);
                interval.a(f13, f3, f5);
                interval.a(interval.c().size());
            }
            level.a(f4);
            this.a(level, f5, f4, bl);
        } else {
            for (n = 0; n < n3; ++n) {
                ilvGrapherCluster = (IlvGrapherCluster)arrayList.get(n);
                this.a(ilvGrapherCluster, ilvGraphOfClusters, f5, f4, bl);
            }
        }
        if (arrayList2.size() > 0) {
            this.a(arrayList2, ilvGraphOfClusters, f, f2, f5, f4, bl);
        }
    }

    private final void a(IlvAbstractGraphicNode ilvAbstractGraphicNode, float f, float f2, float f3, boolean bl) throws IlvGraphLayoutException {
        double d = IlvGrapherCluster.a(ilvAbstractGraphicNode, this.getGraphModel(), this.i, this.j);
        ArrayList arrayList = ilvAbstractGraphicNode.a();
        if (arrayList == null || arrayList.size() < 1) {
            return;
        }
        float f4 = IlvCircularLayout.a(arrayList, f2, f3);
        d -= (double)(f4 / (2.0f * f2));
        float f5 = IlvCircularLayout.a(f3, f2);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                d += (double)(f5 / f2);
            }
            IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)arrayList.get(i);
            float f6 = IlvCircularLayout.a(ilvGrapherCluster.m(), f2);
            this.callLayoutStepPerformedIfNeeded();
            ilvGrapherCluster.a(false, this, d += (double)(f6 / f2), this.i, this.j, f, f3, bl);
            d += (double)(f6 / f2);
        }
    }

    private final void a(Level level, float f, float f2, boolean bl) throws IlvGraphLayoutException {
        if (level.b() < 1) {
            return;
        }
        float f3 = level.b(0).i();
        for (int i = 0; i < level.b(); ++i) {
            Interval interval = level.b(i);
            double d = interval.j();
            double d2 = interval.k();
            double d3 = interval.l();
            double d4 = interval.m();
            double d5 = 0.0;
            if (interval.e() > 1) {
                d5 = (LayoutUtil.GetOrientedDeltaAlpha(d2, d) - LayoutUtil.GetOrientedDeltaAlpha(d4, d3)) / (double)interval.e();
            }
            double d6 = interval.j();
            float f4 = IlvCircularLayout.a(f2, f3);
            ArrayList arrayList = interval.c();
            d6 += d5 * 0.5;
            int n = arrayList.size();
            for (int j = 0; j < n; ++j) {
                if (j > 0) {
                    d6 += d5 + (double)(f4 / f3);
                }
                IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)arrayList.get(j);
                float f5 = IlvCircularLayout.a(ilvGrapherCluster.m(), f3);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster.a(false, this, d6 += (double)(f5 / f3), this.i, this.j, f, f2, bl);
                ilvGrapherCluster.a(d6);
                d6 += (double)(f5 / f3);
            }
        }
    }

    private final void a(IlvGrapherCluster ilvGrapherCluster, IlvGraphOfClusters ilvGraphOfClusters, float f, float f2, boolean bl) throws IlvGraphLayoutException {
        ArrayList arrayList = ilvGrapherCluster.e();
        if (arrayList.size() < 1) {
            return;
        }
        double d = IlvCircularLayout.a(ilvGrapherCluster, this.i, this.j);
        float f3 = IlvCircularLayout.b(ilvGrapherCluster, ilvGraphOfClusters);
        float f4 = f - f3;
        float f5 = IlvCircularLayout.a(ilvGrapherCluster, ilvGraphOfClusters, f4, f2);
        d -= (double)(f5 / (2.0f * f4));
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            IlvAbstractGraphicNode ilvAbstractGraphicNode = (IlvAbstractGraphicNode)arrayList.get(i);
            ArrayList arrayList2 = ilvAbstractGraphicNode.a();
            if (arrayList2 == null || arrayList2.size() < 1) continue;
            float f6 = IlvCircularLayout.a(f2, f4);
            float f7 = f6 / f4;
            int n3 = arrayList2.size();
            for (int j = 0; j < n3; ++j) {
                if (n > 0) {
                    d += (double)f7;
                }
                IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)arrayList2.get(j);
                float f8 = IlvCircularLayout.a(ilvGrapherCluster2.m(), f4);
                this.callLayoutStepPerformedIfNeeded();
                ilvGrapherCluster2.a(false, this, d += (double)(f8 / f4), this.i, this.j, f, f2, bl);
                ilvGrapherCluster2.a(d);
                d += (double)(f8 / f4);
                ++n;
            }
        }
    }

    private final boolean h() {
        return this.ap;
    }

    private final void d(boolean bl) {
        if (this.ap != bl) {
            if (!bl) {
                this.g();
            }
            this.ap = bl;
        }
    }

    @Override
    public void setStructureUpToDate(boolean bl) {
        super.setStructureUpToDate(bl);
        if (!bl) {
            this.d(false);
        }
    }

    private static final double a(IlvGrapherCluster ilvGrapherCluster, float f, float f2) {
        return Math.atan2(f2 - ilvGrapherCluster.u(), ilvGrapherCluster.t() - f);
    }

    private final float a(IlvGrapherCluster ilvGrapherCluster, ArrayList arrayList, float f, float f2, float[] fArray, float f3) {
        float f4;
        IlvCircularLayout.a(ilvGrapherCluster, arrayList);
        ArrayList arrayList2 = arrayList;
        if (arrayList2.size() < 1) {
            ilvGrapherCluster.a(0.0f);
            return -f2;
        }
        float f5 = f2;
        float f6 = 0.0f;
        for (int i = 0; i < arrayList2.size(); ++i) {
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)arrayList2.get(i);
            float f7 = ilvGrapherCluster2.m();
            if (i > 0) {
                f6 += f3;
            }
            f6 += 2.0f * ilvGrapherCluster2.m();
            f5 = IlvCircularLayout.a(ilvGrapherCluster2, ilvGrapherCluster, f, f5, f3);
            if (!(f7 > fArray[0])) continue;
            fArray[0] = f7;
        }
        ilvGrapherCluster.a(f6);
        float f8 = f4 = f5 - fArray[0];
        float f9 = 1.2f * f6;
        if ((double)f4 > 1.0E-4 && f6 > 0.0f && ((double)(f9 / (2.0f * f4)) > Math.PI || Math.cos(f9 / (2.0f * f4)) <= (double)(f / f4))) {
            int n = 0;
            while (((double)(f9 / (2.0f * (f4 += f8))) > Math.PI || Math.cos(f9 / (2.0f * f4)) <= (double)(f / f4)) && ++n < 1000) {
            }
            n = 0;
            do {
                f4 -= f8 / 10.0f;
                ++n;
                if (!((double)(f9 / (2.0f * f4)) <= Math.PI) || !(Math.cos(f9 / (2.0f * f4)) > (double)(f / f4))) break;
            } while (n < 1000);
            f5 = f4 + f5 / 10.0f + fArray[0];
        }
        return f5;
    }

    private static final float a(IlvGrapherCluster ilvGrapherCluster, IlvGrapherCluster ilvGrapherCluster2, float f, float f2, float f3) {
        float f4 = ilvGrapherCluster.c().getType() == 0 ? -ilvGrapherCluster2.n() : f3;
        return Math.max(f2, f + ilvGrapherCluster.o() + f4);
    }

    private void i() {
        if (!this.clusterize()) {
            LogResUtil.logAndThrowRuntimeExc(IlvCircularLayout.class, "graphlayout.expert.message.6325E");
        }
    }

    protected boolean clusterize() {
        if (this.aq || this.h()) {
            return true;
        }
        this.aq = true;
        boolean bl = false;
        try {
            bl = this.getClusteringMode() == 2 ? this.l() : this.j();
            this.b = null;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            this.aq = false;
        }
        if (bl) {
            this.d(true);
        }
        return bl;
    }

    private boolean j() {
        Object object;
        boolean bl = this.k();
        if (!bl && (object = this.getGrapher()) != null) {
            this.a(this.getGraphModel().getNodes());
            bl = this.k();
        }
        if (bl) {
            this.a(this.b);
            this.d = this.b.b();
            if (this.e == null) {
                this.e = new ArrayList(this.b.e().size());
            } else {
                this.e.clear();
            }
            int n = this.d.size();
            for (int i = 0; i < n; ++i) {
                object = (IlvGraphOfClusters)this.d.get(i);
                ArrayList arrayList = ((IlvAbstractGraph)object).e();
                int n2 = arrayList.size();
                for (int j = 0; j < n2; ++j) {
                    this.e.add(arrayList.get(j));
                }
            }
        }
        return bl;
    }

    private boolean k() {
        Object object;
        this.b = new IlvGraphOfClusters();
        Enumeration enumeration = this.getGraphModel().getNodes();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Enumeration enumeration2 = this.getClusterIds(object);
            while (enumeration2.hasMoreElements()) {
                IlvClusterId ilvClusterId = (IlvClusterId)enumeration2.nextElement();
                this.a(object, ilvClusterId);
            }
        }
        object = this.b.getNodes();
        if (!object.hasNext()) {
            return false;
        }
        this.b.a(this);
        return true;
    }

    private boolean l() {
        CLAutoClustering cLAutoClustering = new CLAutoClustering(null, this.getGraphModel()){

            @Override
            protected IlvClusterId getClusterId(Object object) {
                Enumeration enumeration = IlvCircularLayout.this.getClusterIds(object);
                if (enumeration.hasMoreElements()) {
                    return (IlvClusterId)enumeration.nextElement();
                }
                return null;
            }

            @Override
            protected int getStarCenter(Object object) {
                if (IlvCircularLayout.this.isStarCenter(object)) {
                    return 1;
                }
                return 0;
            }

            @Override
            protected int getIndex(Object object) {
                return IlvCircularLayout.this.a(object);
            }
        };
        ClusteringGraph clusteringGraph = cLAutoClustering.run(this);
        this.c = new CLGraphOfClusters(clusteringGraph, this.getGraphModel()){

            @Override
            protected int getIndex(Object object) {
                return IlvCircularLayout.this.a(object);
            }
        };
        this.c.k();
        return true;
    }

    public final synchronized void setStarCenter(Object object, boolean bl) {
        LayoutParametersUtil.SetNodeParameter((IlvGraphLayout)this, object, h, bl, false);
    }

    public boolean isStarCenter(Object object) {
        return LayoutParametersUtil.GetNodeParameter((IlvGraphLayout)this, object, h, false);
    }

    public final synchronized void setClusterId(Object object, IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6327E");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, g, new IlvClusterIdCollection(ilvClusterId));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.set(ilvClusterId);
            this.onParameterChanged(object, g);
        }
        this.d(false);
    }

    public final synchronized void setClusterId(Object object, IlvClusterId ilvClusterId, int n) {
        if (ilvClusterId == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6327E");
        }
        if (n < 0) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6328E");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, g, new IlvClusterIdCollection(ilvClusterId, n));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.set(ilvClusterId, n);
            this.onParameterChanged(object, g);
        }
        this.d(false);
    }

    public final synchronized void addClusterId(Object object, IlvClusterId ilvClusterId) {
        if (ilvClusterId == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6327E");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, g, new IlvClusterIdCollection(ilvClusterId));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.add(ilvClusterId);
            this.onParameterChanged(object, g);
        }
        this.d(false);
    }

    public final synchronized void addClusterId(Object object, IlvClusterId ilvClusterId, int n) {
        if (ilvClusterId == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6327E");
        }
        if (n < 0) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6328E");
        }
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
        if (ilvClusterIdCollection == null) {
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, g, new IlvClusterIdCollection(ilvClusterId, n));
        } else {
            LayoutParametersUtil.CheckInputNode(this, object, "The input node");
            ilvClusterIdCollection.add(ilvClusterId, n);
            this.onParameterChanged(object, g);
        }
        this.d(false);
    }

    public final synchronized void removeClusterId(Object object, IlvClusterId ilvClusterId) {
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
        if (ilvClusterIdCollection != null && ilvClusterIdCollection.remove(ilvClusterId)) {
            this.onParameterChanged(object, g);
            this.d(false);
        }
    }

    public final synchronized void removeAllClusterIds(Object object) {
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
        if (ilvClusterIdCollection != null) {
            boolean bl = !ilvClusterIdCollection.getClusterIds().hasMoreElements();
            LayoutParametersUtil.SetNodeProperty(this, object, "The input node", true, g, null);
            if (!bl) {
                this.onParameterChanged(object, g);
                this.d(false);
            }
        }
    }

    public Vector getClusterIds() {
        int n;
        this.clusterize();
        int n2 = n = this.e != null ? this.e.size() : 0;
        if (n < 1) {
            return null;
        }
        Vector<IlvClusterId> vector = new Vector<IlvClusterId>(n);
        for (int i = 0; i < n; ++i) {
            IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.e.get(i);
            vector.addElement(ilvGrapherCluster.getId());
        }
        return vector;
    }

    public float getClusterRadius(int n) {
        block3: {
            int n2;
            block2: {
                this.i();
                int n3 = n2 = this.e != null ? this.e.size() : 0;
                if (n < 0) break block2;
                if (n < n2) break block3;
            }
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6329E", new Object[]{new Integer(n), new Integer(n2)});
        }
        IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.e.get(n);
        return ilvGrapherCluster.l();
    }

    public IlvPoint getClusterCenter(int n) {
        block3: {
            int n2;
            block2: {
                this.i();
                int n3 = n2 = this.e != null ? this.e.size() : 0;
                if (n < 0) break block2;
                if (n < n2) break block3;
            }
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6329E", new Object[]{new Integer(n), new Integer(n2)});
        }
        IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.e.get(n);
        return new IlvPoint(ilvGrapherCluster.t(), ilvGrapherCluster.u());
    }

    public Vector getClusterNodes(int n) {
        block3: {
            int n2;
            block2: {
                this.i();
                int n3 = n2 = this.e != null ? this.e.size() : 0;
                if (n < 0) break block2;
                if (n < n2) break block3;
            }
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6329E", new Object[]{new Integer(n), new Integer(n2)});
        }
        IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.e.get(n);
        return ilvGrapherCluster.b();
    }

    public Enumeration getClusterIds(Object object) {
        this.b(object);
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
        return ilvClusterIdCollection == null ? LayoutUtil.GetVoidEnumeration() : ilvClusterIdCollection.getClusterIds();
    }

    public int getClusterIdsCount(Object object) {
        this.b(object);
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
        return ilvClusterIdCollection == null ? 0 : ilvClusterIdCollection.size();
    }

    public int getIndex(Object object, IlvClusterId ilvClusterId) {
        IlvClusterIdCollection ilvClusterIdCollection;
        block3: {
            block2: {
                this.b(object);
                ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
                if (ilvClusterIdCollection == null) break block2;
                if (ilvClusterIdCollection.contains(ilvClusterId)) break block3;
            }
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6332E", new Object[]{ilvClusterId});
        }
        return ilvClusterIdCollection.getIndex(ilvClusterId);
    }

    private int a(Object object) {
        this.b(object);
        IlvClusterIdCollection ilvClusterIdCollection = (IlvClusterIdCollection)LayoutParametersUtil.GetNodeProperty(this, object, g);
        if (ilvClusterIdCollection == null || ilvClusterIdCollection.size() == 0) {
            return -1;
        }
        IlvClusterId ilvClusterId = (IlvClusterId)ilvClusterIdCollection.getClusterIds().nextElement();
        return ilvClusterIdCollection.getIndex(ilvClusterId);
    }

    private void b(Object object) {
        if (object == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6330E");
        } else if (!this.getGraphModel().isNode(object)) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6331E");
        }
    }

    public final void setClusteringMode(int n) {
        if (n != 0 && n != 1 && n != 2) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6326E", n);
        }
        if (n != this.ad) {
            this.ad = n;
            this.onParameterChanged("ClusteringMode");
        }
    }

    public final int getClusteringMode() {
        return this.isUseDefaultParameters() ? 0 : this.ad;
    }

    public final void setMaxNumberOfPermutations(int n) {
        if (n < 0) {
            LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6333E", n);
        }
        if (n != this.ae) {
            this.ae = n;
            this.onParameterChanged("MaxNumberOfPermutations");
        }
    }

    public final int getMaxNumberOfPermutations() {
        if (this.isUseDefaultParameters()) {
            return 200;
        }
        return this.ae;
    }

    public final void setInterClusterCrossingReduction(boolean bl) {
        if (bl != this.ag) {
            this.ag = bl;
            this.onParameterChanged("InterClusterCrossingReduction");
        }
    }

    public final boolean isInterClusterCrossingReduction() {
        if (this.isUseDefaultParameters()) {
            return true;
        }
        return this.ag;
    }

    public final void setIntraClusterLinkCrossingPenalty(float f) {
        if (f != this.ah) {
            this.ah = f;
            this.onParameterChanged("IntraClusterLinkCrossingPenalty");
        }
    }

    public final float getIntraClusterLinkCrossingPenalty() {
        if (this.isUseDefaultParameters()) {
            return 1.0f;
        }
        return this.ah;
    }

    public final void setInterClusterLinkCrossingPenalty(float f) {
        if (f != this.ai) {
            this.ai = f;
            this.onParameterChanged("InterClusterLinkCrossingPenalty");
        }
    }

    public final float getInterClusterLinkCrossingPenalty() {
        if (this.isUseDefaultParameters()) {
            return 1.0f;
        }
        return this.ai;
    }

    public final void setMixedClusterLinkCrossingPenalty(float f) {
        if (f != this.aj) {
            this.aj = f;
            this.onParameterChanged("MixedClusterLinkCrossingPenalty");
        }
    }

    public final float getMixedClusterLinkCrossingPenalty() {
        if (this.isUseDefaultParameters()) {
            return 1.0f;
        }
        return this.aj;
    }

    public final void setClusterByBiconnectivity(boolean bl) {
        if (bl != this.ak) {
            this.ak = bl;
            this.onParameterChanged("ClusterByBiconnectivity");
        }
    }

    public final boolean isClusterByBiconnectivity() {
        if (this.isUseDefaultParameters()) {
            return true;
        }
        return this.ak;
    }

    public final void setMinimumClusterSize(int n) {
        if (n < 2) {
            n = 2;
        }
        if (n != this.al) {
            this.al = n;
            this.onParameterChanged("MinimumClusterSize");
        }
    }

    public final int getMinimumClusterSize() {
        if (this.isUseDefaultParameters()) {
            return 4;
        }
        return this.al;
    }

    public final void setMaximumClusterSize(int n) {
        if (n < 2) {
            n = 2;
        }
        if (n != this.am) {
            this.am = n;
            this.onParameterChanged("MaximumClusterSize");
        }
    }

    public final int getMaximumClusterSize() {
        if (this.isUseDefaultParameters()) {
            return 50;
        }
        return this.am;
    }

    public final void setHighDegreeStarClusterSize(int n) {
        if (n != this.an) {
            this.an = n;
            this.onParameterChanged("HighDegreeStarClusterSize");
        }
    }

    public final int getHighDegreeStarClusterSize() {
        if (this.isUseDefaultParameters()) {
            return 5;
        }
        return this.an;
    }

    public final void setMaximumNumberOfIterationsToReachMaxClusterSize(int n) {
        if (n != this.ao) {
            this.ao = n;
            this.onParameterChanged("MaximumNumberOfIterationsToReachMaxClusterSize");
        }
    }

    public final int getMaximumNumberOfIterationsToReachMaxClusterSize() {
        if (this.isUseDefaultParameters()) {
            return 10;
        }
        return this.ao;
    }

    public void setLayoutOfClusterGraph(IlvGraphLayout ilvGraphLayout) {
        if (ilvGraphLayout != this.af) {
            if (this.af != null) {
                this.af.setParentLayout(null);
                this.af.detach();
            }
            if (ilvGraphLayout != null) {
                ilvGraphLayout.setParentLayout(this);
            }
            this.af = ilvGraphLayout;
            this.setStructureUpToDate(false);
            this.onParameterChanged("LayoutOfClusterGraph");
        }
    }

    public IlvGraphLayout getLayoutOfClusterGraph() {
        if (this.af == null) {
            IlvTreeLayout ilvTreeLayout = new IlvTreeLayout();
            ilvTreeLayout.setParentLayout(this);
            ilvTreeLayout.setLayoutMode(2);
            ilvTreeLayout.setIncrementalMode(false);
            ilvTreeLayout.setRespectNodeSizes(true);
            float f = this.getOffset();
            ilvTreeLayout.setSiblingOffset(f);
            ilvTreeLayout.setParentChildOffset(f);
            ilvTreeLayout.setBranchOffset(f);
            this.af = ilvTreeLayout;
        }
        return this.af;
    }

    protected void customizeLayoutOfClusterGraph(IlvGraphLayout ilvGraphLayout) throws IlvGraphLayoutException {
        if (ilvGraphLayout instanceof IlvTreeLayout && this.isInterClusterCrossingReduction()) {
            CLCluster[] cLClusterArray;
            IlvTreeLayout ilvTreeLayout = (IlvTreeLayout)ilvGraphLayout;
            ilvTreeLayout.setGlobalLinkStyle(0);
            ilvTreeLayout.setCategorizingLinks(true);
            ilvTreeLayout.setCategorizingLinksWithoutLayout(true);
            ilvTreeLayout.performLayout(true, false);
            Enumeration enumeration = ilvTreeLayout.getCalcRoots();
            Object var4_4 = null;
            if (enumeration.hasMoreElements()) {
                var4_4 = enumeration.nextElement();
            }
            this.c.a(ilvTreeLayout);
            ilvTreeLayout.setCategorizingLinks(false);
            ilvTreeLayout.setCategorizingLinksWithoutLayout(false);
            float f = this.i;
            float f2 = this.j;
            if (var4_4 != null) {
                cLClusterArray = this.c.boundingBox(var4_4);
                f -= 0.5f * cLClusterArray.width;
                f2 -= 0.5f * cLClusterArray.height;
            }
            ilvTreeLayout.setPosition(new IlvPoint(f, f2), true);
            cLClusterArray = this.c.l();
            CLCrossingReduction cLCrossingReduction = new CLCrossingReduction(cLClusterArray);
            cLCrossingReduction.run(false, false);
            for (int i = 0; i < cLClusterArray.length; ++i) {
                cLClusterArray[i].m();
            }
            ilvTreeLayout.setNodeComparator(this.au);
        }
    }

    private int a(Object object, Object object2) {
        float f;
        CLCluster cLCluster = this.c.c(object);
        CLCluster cLCluster2 = this.c.c(object2);
        float f2 = cLCluster.l();
        if (f2 < (f = cLCluster2.l())) {
            return -1;
        }
        if (f2 > f) {
            return 1;
        }
        return 0;
    }

    private final void a(Object object, IlvClusterId ilvClusterId) {
        int n;
        IlvGrapherCluster ilvGrapherCluster;
        this.b(object);
        if (this.b == null) {
            this.b = new IlvGraphOfClusters();
        }
        if ((ilvGrapherCluster = this.b.getCluster(ilvClusterId)) == null) {
            ilvGrapherCluster = new IlvGrapherCluster(ilvClusterId);
            ilvGrapherCluster.attach(this.getGraphModel());
            this.b.addNode(ilvGrapherCluster);
        }
        if ((n = this.getIndex(object, ilvClusterId)) >= 0) {
            ilvGrapherCluster.addNode(new IlvAbstractGraphicNode(object, n), this.isStarCenter(object));
        } else {
            ilvGrapherCluster.addNode(new IlvAbstractGraphicNode(object), this.isStarCenter(object));
        }
        this.d(false);
    }

    final void a(IlvClustersConnexion ilvClustersConnexion) {
        this.b.addLink(ilvClustersConnexion);
        this.d(false);
    }

    final IlvGrapherCluster a(IlvClusterId ilvClusterId) {
        this.i();
        return this.b.getCluster(ilvClusterId);
    }

    final IlvGraphOfClusters c() {
        return this.b;
    }

    @Override
    public boolean supportsAllowedTime() {
        return false;
    }

    @Override
    public boolean supportsStopImmediately() {
        return false;
    }

    @Override
    public final boolean supportsLayoutRegion() {
        return true;
    }

    @Override
    public boolean supportsPercentageComplete() {
        return false;
    }

    public synchronized void setAreaMinimizationEnabled(boolean bl) {
        if (bl != this.ac) {
            this.ac = bl;
            this.onParameterChanged("AreaMinimizationEnabled");
        }
    }

    public boolean isAreaMinimizationEnabled() {
        if (this.isUseDefaultParameters()) {
            return false;
        }
        return this.ac;
    }

    public synchronized void setOffset(float f) {
        if (f != this.z) {
            this.z = f;
            this.onParameterChanged("Offset");
        }
    }

    public float getOffset() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.z;
    }

    public synchronized void setLevelOffset(float f) {
        if (f != this.aa) {
            this.aa = f;
            this.onParameterChanged("LevelOffset");
        }
    }

    public float getLevelOffset() {
        if (this.isUseDefaultParameters()) {
            return 0.0f;
        }
        return this.aa;
    }

    public synchronized void setDisconnectedGraphOffset(float f) {
        if (f != this.ab) {
            this.ab = f;
            this.onParameterChanged("DisconnectedGraphOffset");
        }
    }

    public float getDisconnectedGraphOffset() {
        if (this.isUseDefaultParameters()) {
            return 10.0f;
        }
        return this.ab;
    }

    private static final void a(IlvGrapherCluster ilvGrapherCluster, ArrayList arrayList) {
        ArrayList arrayList2 = ilvGrapherCluster.e();
        if (arrayList2.size() < 1) {
            return;
        }
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            IlvAbstractGraphicNode ilvAbstractGraphicNode = (IlvAbstractGraphicNode)arrayList2.get(i);
            ArrayList arrayList3 = ilvAbstractGraphicNode.a();
            if (arrayList3 == null || arrayList3.size() < 1) continue;
            for (int j = 0; j < arrayList3.size(); ++j) {
                arrayList.add(arrayList3.get(j));
            }
        }
    }

    private static final ArrayList a(IlvGrapherCluster ilvGrapherCluster, IlvAbstractGraph ilvAbstractGraph) {
        Enumeration enumeration = ilvAbstractGraph.getLinksFrom(ilvGrapherCluster);
        ArrayList<IlvGrapherCluster> arrayList = new ArrayList<IlvGrapherCluster>(10);
        while (enumeration.hasMoreElements()) {
            IlvClustersConnexion ilvClustersConnexion = (IlvClustersConnexion)enumeration.nextElement();
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)ilvAbstractGraph.getOpposite(ilvClustersConnexion, ilvGrapherCluster);
            if (ilvGrapherCluster2.k()) continue;
            arrayList.add(ilvGrapherCluster2);
        }
        return arrayList;
    }

    private static final float a(IlvGrapherCluster ilvGrapherCluster, IlvAbstractGraph ilvAbstractGraph, float f, float f2) {
        ArrayList arrayList = IlvCircularLayout.a(ilvGrapherCluster, ilvAbstractGraph);
        return IlvCircularLayout.a(arrayList, f, f2);
    }

    private static final float a(IlvAbstractGraphicNode ilvAbstractGraphicNode, float f, float f2) {
        ArrayList arrayList = ilvAbstractGraphicNode.a();
        return arrayList == null || arrayList.size() < 1 ? 0.0f : IlvCircularLayout.a(arrayList, f, f2);
    }

    private static final float a(ArrayList arrayList, float f, float f2) {
        if (arrayList == null || arrayList.size() < 1) {
            return 0.0f;
        }
        float f3 = 0.0f;
        float f4 = IlvCircularLayout.a(f2, f);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)arrayList.get(i);
            if (i > 0) {
                f3 += f4;
            }
            f3 += IlvCircularLayout.a(2.0f * ilvGrapherCluster.m(), f);
        }
        return f3;
    }

    private static final float b(IlvGrapherCluster ilvGrapherCluster, IlvAbstractGraph ilvAbstractGraph) {
        ArrayList arrayList = IlvCircularLayout.a(ilvGrapherCluster, ilvAbstractGraph);
        if (arrayList == null || arrayList.size() < 1) {
            return 0.0f;
        }
        float f = 0.0f;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            IlvGrapherCluster ilvGrapherCluster2 = (IlvGrapherCluster)arrayList.get(i);
            float f2 = ilvGrapherCluster2.m();
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    static float a(float f, float f2) {
        if (f2 == 0.0f) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "radius==0";
            LogResUtil.logAndThrowRuntimeExc(IlvGraphLayout.class, "graphlayout.expert.message.6150E", objectArray);
        }
        return 2.0f * f2 * (float)Math.asin(f / (2.0f * f2));
    }

    final IlvArrayStableSort d() {
        return this.as;
    }

    @Override
    protected IlvGraphLayoutGrapherProperty createLayoutGrapherProperty(String string, boolean bl) {
        return new IlvCircularLayoutGrapherProperty(string, this, bl);
    }

    @Override
    protected IlvGraphLayoutNodeProperty createLayoutNodeProperty(String string, IlvGraphic ilvGraphic, boolean bl) {
        return new IlvCircularLayoutNodeProperty(string, this, ilvGraphic, bl);
    }

    static String b(int n) {
        switch (n) {
            case 0: {
                return "BY_CLUSTER_IDS";
            }
            case 1: {
                return "BY_SUBGRAPHS";
            }
            case 2: {
                return "AUTOMATIC";
            }
        }
        LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6326E", n);
        return "not reached";
    }

    static int a(String string) {
        if (string.equals("BY_CLUSTER_IDS")) {
            return 0;
        }
        if (string.equals("BY_SUBGRAPHS")) {
            return 1;
        }
        if (string.equals("AUTOMATIC")) {
            return 2;
        }
        LogResUtil.logAndThrowIllegalArgExc(IlvCircularLayout.class, "graphlayout.expert.message.6326E", new Object[]{string});
        return 0;
    }

    private final class Interval {
        private IlvGrapherCluster a;
        private ArrayList b;
        private double c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private float j = -1.0f;
        private double k;
        private float l;
        private int m;
        private float n;
        private boolean o = true;

        private Interval() {
        }

        void a(IlvGrapherCluster ilvGrapherCluster) {
            this.a = ilvGrapherCluster;
        }

        IlvGrapherCluster a() {
            return this.a;
        }

        void a(double d) {
            this.c = d;
        }

        double b() {
            return this.c;
        }

        void a(IlvGraphOfClusters ilvGraphOfClusters, ArrayList arrayList) {
            this.b = arrayList;
            this.o = true;
            if (this.b != null) {
                int n = this.b.size();
                for (int i = 0; i < n; ++i) {
                    IlvGrapherCluster ilvGrapherCluster = (IlvGrapherCluster)this.b.get(i);
                    if (ilvGraphOfClusters.getLinksCount(ilvGrapherCluster) <= 1) continue;
                    this.o = false;
                    break;
                }
            }
        }

        ArrayList c() {
            return this.b;
        }

        boolean d() {
            return this.o;
        }

        void a(int n) {
            this.m = n;
        }

        int e() {
            return this.m;
        }

        void a(float f) {
            this.n = f;
        }

        float f() {
            return this.n;
        }

        private void a(float f, float f2, float f3) {
            this.j = f;
            if (this.l == 0.0f) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "radius==0";
                LogResUtil.logAndThrowRuntimeExc(IlvGraphLayout.class, "graphlayout.expert.message.6150E", objectArray);
            }
            this.k = this.j / this.l;
            this.a(f2, f3);
            this.d = LayoutUtil.CorrectAngle(this.c - this.k * 0.5);
            this.e = LayoutUtil.CorrectAngle(this.c + this.k * 0.5);
            this.f = this.d;
            this.g = this.e;
        }

        float g() {
            return this.j;
        }

        double h() {
            return this.k;
        }

        void b(float f) {
            this.l = f;
        }

        float i() {
            return this.l;
        }

        void b(double d) {
            this.d = d;
        }

        double j() {
            return this.d;
        }

        void c(double d) {
            this.e = d;
        }

        double k() {
            return this.e;
        }

        double l() {
            return this.f;
        }

        double m() {
            return this.g;
        }

        private void a(float f, float f2) {
            if (this.j < 0.0f) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "computeMinMax before minCurvLength";
                LogResUtil.logAndThrowRuntimeExc(IlvGraphLayout.class, "graphlayout.expert.message.6150E", objectArray);
            }
            double d = LayoutUtil.CorrectAngle(Math.min((double)0.8f * Math.abs(Math.acos(f / f2)), 1.2566370614359172));
            this.h = LayoutUtil.CorrectAngle(this.c - d);
            this.i = LayoutUtil.CorrectAngle(this.c + d);
        }

        double n() {
            return this.h;
        }

        double o() {
            return this.i;
        }
    }

    private final class Level {
        private ArrayList a = null;

        Level(int n) {
            this.a = new ArrayList(n);
        }

        void a() {
            this.a = null;
        }

        void a(int n) {
            this.a.clear();
            this.a.ensureCapacity(n);
        }

        void a(float f) {
            Interval interval;
            if (this.a.size() == 0) {
                return;
            }
            if (this.a.size() == 1) {
                int n;
                Interval interval2 = (Interval)this.a.get(0);
                if (!interval2.d() && (n = interval2.e()) > 1) {
                    double d;
                    double d2 = interval2.n();
                    if (d2 <= (d = interval2.o())) {
                        if (d - d2 <= Math.PI) {
                            interval2.b(LayoutUtil.CorrectAngle(d2));
                            interval2.c(LayoutUtil.CorrectAngle(d));
                        } else {
                            interval2.b(LayoutUtil.CorrectAngle(d));
                            interval2.c(LayoutUtil.CorrectAngle(d2));
                        }
                    } else if (d2 - d <= Math.PI) {
                        interval2.b(LayoutUtil.CorrectAngle(d));
                        interval2.c(LayoutUtil.CorrectAngle(d2));
                    } else {
                        interval2.b(LayoutUtil.CorrectAngle(d2));
                        interval2.c(LayoutUtil.CorrectAngle(d));
                    }
                }
                return;
            }
            int n = this.a.size();
            for (int i = 0; i < n; ++i) {
                interval = (Interval)this.a.get(i);
                interval.a((float)(interval.e() - 1));
            }
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < n; ++j) {
                    interval = (Interval)this.a.get(j);
                    float f2 = interval.f();
                    if (f2 == 0.0f || interval.d()) continue;
                    Interval interval3 = null;
                    Interval interval4 = null;
                    if (j == 0) {
                        interval3 = (Interval)this.a.get(n - 1);
                        interval4 = (Interval)this.a.get(j + 1);
                    } else if (j == n - 1) {
                        interval3 = (Interval)this.a.get(j - 1);
                        interval4 = (Interval)this.a.get(0);
                    } else {
                        interval3 = (Interval)this.a.get(j - 1);
                        interval4 = (Interval)this.a.get(j + 1);
                    }
                    float f3 = interval3.f();
                    float f4 = interval4.f();
                    if (f2 == 0.0f && f3 == 0.0f && f4 == 0.0f) continue;
                    double d = interval3.k();
                    double d3 = interval4.j();
                    double d4 = interval.j();
                    double d5 = interval.k();
                    double d6 = interval.n();
                    double d7 = interval.o();
                    double d8 = d < d3 ? d : d3;
                    d8 = d4 < d8 ? d4 : d8;
                    d8 = d5 < d8 ? d5 : d8;
                    double d9 = LayoutUtil.GetOrientedDeltaAlpha1(d4 -= d8, d -= d8);
                    double d10 = LayoutUtil.GetOrientedDeltaAlpha1(d3 -= d8, d5 -= d8);
                    double d11 = (double)(f3 + f2) > 1.0E-4 ? d9 * (double)f2 / (double)(f3 + f2) : 0.0;
                    double d12 = (double)(f4 + f2) > 1.0E-4 ? d10 * (double)f2 / (double)(f4 + f2) : 0.0;
                    d4 = LayoutUtil.CorrectAngle(d8 + d4 - d11);
                    d5 = LayoutUtil.CorrectAngle(d8 + d5 + d12);
                    if (d6 <= d7) {
                        if (d4 < d6 || d4 > d7) {
                            d4 = d6;
                        }
                        if (d5 < d6 || d5 > d7) {
                            d5 = d7;
                        }
                    } else {
                        if (d4 < d6 && d4 > d7) {
                            d4 = d6;
                        }
                        if (d5 < d6 && d5 > d7) {
                            d5 = d7;
                        }
                    }
                    interval.b(LayoutUtil.CorrectAngle(d4));
                    interval.c(LayoutUtil.CorrectAngle(d5));
                }
            }
        }

        int b() {
            return this.a.size();
        }

        void a(Interval interval) {
            this.a.add(interval);
        }

        Interval b(int n) {
            return (Interval)this.a.get(n);
        }
    }

    private final class SortNodesByIndex
    extends IlvArrayStableSort {
        private SortNodesByIndex() {
        }

        @Override
        protected final boolean compare(Object object, Object object2) {
            int n = ((IlvAbstractGraphicNode)object).getIndex();
            int n2 = ((IlvAbstractGraphicNode)object2).getIndex();
            if (n < 0) {
                return n2 < 0;
            }
            if (n2 < 0) {
                return true;
            }
            return n <= n2;
        }
    }
}

