/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers.annotations;

import java.text.MessageFormat;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import oracle.ide.markers.Marker;
import oracle.ide.markers.annotations.MarkerType;

@SupportedAnnotationTypes(value={"oracle.ide.markers.annotations.MarkerType"})
public class MarkerTypeProcessor
extends AbstractProcessor {
    private static final String INTERFACES_ONLY_MSG = MessageFormat.format("Only Java interface types may be annotated with the {0} annotation.", MarkerType.class.getName());
    private static final String MARKER_SUBS_ONLY = MessageFormat.format("Only subtypes of '{0}' may be annotated with the {0} annotation.", MarkerType.class.getName());
    private TypeMirror baseMarkerType;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(MarkerType.class);
        block3: for (Element element : annotatedElements) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Processing element " + element);
            switch (element.getKind()) {
                case INTERFACE: {
                    this.validateElement((TypeElement)element, roundEnv);
                    continue block3;
                }
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, INTERFACES_ONLY_MSG, element);
        }
        return true;
    }

    private void validateElement(TypeElement element, RoundEnvironment roundEnv) {
        TypeMirror elementType = element.asType();
        if (!this.processingEnv.getTypeUtils().isSubtype(elementType, this.baseMarkerType)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, MessageFormat.format(MARKER_SUBS_ONLY, this.baseMarkerType), element);
        }
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String baseMarkerTypeName = Marker.class.getName();
        TypeElement baseMarkerType = processingEnv.getElementUtils().getTypeElement(baseMarkerTypeName);
        if (null == baseMarkerType) {
            throw new IllegalStateException("Unable to locate base marker type: " + baseMarkerTypeName);
        }
        this.baseMarkerType = baseMarkerType.asType();
    }
}

