/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ideimpl.markers.MarkableImpl;
import oracle.javatools.util.Filter;

public class MarkableNode<N extends Node>
extends NodeListener
implements Markable {
    private final MarkableImpl impl = new MarkableImpl(this);
    private N node;
    private boolean isListeningToNode;

    public MarkableNode(N node) {
        this.init(node);
    }

    @Override
    public List<Marker> getMarkers() {
        return this.impl.getMarkers();
    }

    @Override
    public List<Marker> getMarkers(Filter<Marker> filter) {
        return this.impl.getMarkers(filter);
    }

    @Override
    public List<Marker> removeMarkers() throws MarkerException {
        try {
            List<Marker> list = this.impl.removeMarkers();
            return list;
        }
        finally {
            if (this.getMarkers().isEmpty()) {
                this.stopListeningToNode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <M extends Marker> List<M> removeMarkers(Class<M> type, boolean includeSubtypes) throws MarkerException {
        try {
            List<M> list = this.impl.removeMarkers(type, includeSubtypes);
            return list;
        }
        finally {
            if (this.getMarkers().isEmpty()) {
                this.stopListeningToNode();
            }
        }
    }

    @Override
    public List<Marker> removeMarkers(Filter<Marker> filter) throws MarkerException {
        try {
            List<Marker> list = this.impl.removeMarkers(filter);
            return list;
        }
        finally {
            if (this.getMarkers().isEmpty()) {
                this.stopListeningToNode();
            }
        }
    }

    @Override
    public <M extends Marker> List<M> removeMarkers(M ... markers) throws MarkerException {
        try {
            List list = this.impl.removeMarkers((Marker[])markers);
            return list;
        }
        finally {
            if (this.getMarkers().isEmpty()) {
                this.stopListeningToNode();
            }
        }
    }

    @Override
    public URL getUrl() {
        return this.getNode().getURL();
    }

    @Override
    public void addMarkers(Marker ... markers) throws MarkerException {
        this.impl.addMarkers(markers);
        this.startListeningToNode();
    }

    private synchronized void startListeningToNode() {
        if (!this.isListeningToNode) {
            this.node.addNodeListener((NodeListener)this);
            this.isListeningToNode = true;
        }
    }

    private synchronized void stopListeningToNode() {
        if (this.isListeningToNode) {
            this.node.removeNodeListener((NodeListener)this);
            this.isListeningToNode = false;
        }
    }

    @Override
    public <M extends Marker> List<M> getMarkers(Class<M> type, boolean includeSubtypes) {
        return this.impl.getMarkers(type, includeSubtypes);
    }

    protected void init(N node) {
        if (null == node) {
            throw new IllegalArgumentException("Node must not be null");
        }
        this.node = node;
    }

    public N getNode() {
        return this.node;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MarkableNode)) {
            return false;
        }
        MarkableNode other = (MarkableNode)object;
        return this.node != null ? this.node.equals(other.node) : other.node == null;
    }

    @Override
    public int hashCode() {
        return this.node.hashCode();
    }

    public String toString() {
        return this.getNode().getShortLabel();
    }

    public void nodeDeleted(NodeEvent e) {
        try {
            this.removeMarkers();
        }
        catch (MarkerException f) {
            FeedbackManager.reportException((Throwable)f);
        }
    }

    public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("lastUpdated", System.currentTimeMillis());
        List<Marker> markers = this.getMarkers();
        for (Marker marker : markers) {
            try {
                marker.update(attrs, false);
            }
            catch (MarkerException f) {
                FeedbackManager.reportException((Throwable)f);
            }
        }
    }

    @Override
    public int compareTo(Markable o) {
        return this.impl.compareTo(o);
    }

    public String getShortLabel() {
        N node = this.getNode();
        return null != node ? node.getShortLabel() : "";
    }

    public String getLongLabel() {
        N node = this.getNode();
        return null != node ? node.getLongLabel() : "";
    }

    public Icon getIcon() {
        N node = this.getNode();
        return null != node ? node.getIcon() : null;
    }

    public String getToolTipText() {
        N node = this.getNode();
        return null != node ? node.getToolTipText() : "";
    }

    static {
        AdapterManager.Factory.getAdapterManager().registerFactory((AdapterFactory)new AdapterFactory<MarkableNode, MarkableImpl>(){

            public MarkableImpl adapt(MarkableNode obj) {
                return obj.impl;
            }
        });
    }
}

