/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import javax.ide.util.MetaClass;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerEvent;
import oracle.ide.markers.MarkerTypeFilter;
import oracle.javatools.util.Filter;

public class MarkerEventFilterWithMarkerFilter
implements Filter<MarkerEvent> {
    private final Filter<Marker> markerFilter;

    public static Filter<MarkerEvent> filterByMarkerTypeIncludingSubtypes(Class<? extends Marker> ... markerTypes) {
        return MarkerEventFilterWithMarkerFilter.filterByMarkerTypes(markerTypes, true);
    }

    public static Filter<MarkerEvent> filterByMarkerTypeIncludingSubtypes(MetaClass<? extends Marker> ... markerTypes) {
        return MarkerEventFilterWithMarkerFilter.filterByMarkerTypes(markerTypes, true);
    }

    public static Filter<MarkerEvent> filterByMarkerTypeExcludingSubtypes(Class<? extends Marker> ... markerTypes) {
        return MarkerEventFilterWithMarkerFilter.filterByMarkerTypes(markerTypes, false);
    }

    public static Filter<MarkerEvent> filterByMarkerTypeExcludingSubtypes(MetaClass<? extends Marker> ... markerTypes) {
        return MarkerEventFilterWithMarkerFilter.filterByMarkerTypes(markerTypes, false);
    }

    private static Filter<MarkerEvent> filterByMarkerTypes(Class<? extends Marker>[] markerTypes, boolean includeSubtypes) {
        Filter[] filters = new MarkerTypeFilter[markerTypes.length];
        for (int i = 0; i < markerTypes.length; ++i) {
            filters[i] = new MarkerTypeFilter(markerTypes[i], includeSubtypes);
        }
        return new MarkerEventFilterWithMarkerFilter((Filter<Marker>)Filter.Instances.or((Filter[])filters));
    }

    private static Filter<MarkerEvent> filterByMarkerTypes(MetaClass<? extends Marker>[] markerTypes, boolean includeSubtypes) {
        Filter[] filters = new MarkerTypeFilter[markerTypes.length];
        for (int i = 0; i < markerTypes.length; ++i) {
            filters[i] = new MarkerTypeFilter(markerTypes[i], includeSubtypes);
        }
        return new MarkerEventFilterWithMarkerFilter((Filter<Marker>)Filter.Instances.or((Filter[])filters));
    }

    public MarkerEventFilterWithMarkerFilter(Filter<Marker> markerFilter) {
        if (null == markerFilter) {
            throw new IllegalArgumentException("Marker filter must not be null");
        }
        this.markerFilter = markerFilter;
    }

    public boolean matches(MarkerEvent value) {
        Filter<Marker> filter = this.getMarkerFilter();
        for (Marker marker : value.getMarkers()) {
            if (null == marker || !filter.matches((Object)marker)) continue;
            return true;
        }
        return false;
    }

    public final Filter<Marker> getMarkerFilter() {
        return this.markerFilter;
    }
}

