/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import oracle.javatools.db.DBObjectProvider;

public class UIStringUtils {
    public static String convertDescription(String string) {
        String string2 = string.replace("_", " ");
        return string2;
    }

    public static boolean isObjectNameAndDescriptionEqual(String string, String string2) {
        if (string == null || string2 == null || string.length() != string2.length()) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            Character c = Character.valueOf(Character.toUpperCase(string.charAt(i)));
            Character c2 = Character.valueOf(Character.toUpperCase(string2.charAt(i)));
            if (c.charValue() == ' ' && c2.charValue() == '_' || c.charValue() == '_' && c2.charValue() == ' ' || c == c2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static String capitalizeFirstLetter(String string) {
        if (string.length() == 0) {
            return "";
        }
        return String.format("%s%s", string.substring(0, 1).toUpperCase(), string.substring(1));
    }

    public static String setupTextForDescriptions(String string) {
        string = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("_");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(String.format("%s ", UIStringUtils.capitalizeFirstLetter(stringArray[i])));
        }
        return stringBuffer.toString().trim();
    }

    public static void setKeyAdapterToNameField(JTextField jTextField) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == ' ' || keyEvent.getKeyChar() == '.' || keyEvent.getKeyChar() == '\"') {
                    Toolkit.getDefaultToolkit().beep();
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };
        jTextField.addKeyListener(keyAdapter);
    }

    public static String stripDoubleQuotes(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean isQuotedName(String string) {
        boolean bl = false;
        if (string != null && string.length() >= 2 && string.startsWith("\"") && string.endsWith("\"")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isSingleQuotedLiteral(String string) {
        boolean bl = false;
        if (string != null && string.length() >= 2 && string.startsWith("'") && string.endsWith("'")) {
            bl = true;
        }
        return bl;
    }

    public static boolean isCharTypeExpressionBasedOnCaseOrFunction(String string) {
        boolean bl = false;
        if (string.length() > 4 && string.substring(0, 4).equalsIgnoreCase("case")) {
            bl = true;
        } else if (string.length() > 7 && string.substring(0, 7).equalsIgnoreCase("to_char")) {
            bl = true;
        } else if (string.indexOf(40) > -1) {
            bl = true;
        }
        return bl;
    }

    public static String normalizeName(String string, DBObjectProvider dBObjectProvider) {
        String string2 = null;
        String string3 = dBObjectProvider.getExternalName(string);
        String string4 = dBObjectProvider.getInternalName(string);
        string2 = UIStringUtils.isQuotedName(string) ? string3 : string4;
        return string2;
    }

    public static String escapeSingleQuotesForSQL(String string) {
        return UIStringUtils.getReplacedString(string, "'", "''");
    }

    public static String getReplacedString(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.length() > 0) {
            int n2 = string.indexOf(string2, n);
            while (n2 >= 0) {
                stringBuilder.append(string.substring(n, n2));
                stringBuilder.append(string3);
                n = n2 + string2.length();
                n2 = string.indexOf(string2, n);
            }
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public static List<String> getExternalNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        string = string.trim();
        int n2 = string.length();
        while (n < n2) {
            String string2 = string.substring(n);
            if ((string2 = string2.trim()).startsWith(",") && n > 0) {
                string2 = string2.substring(1).trim();
            }
            if (string2.isEmpty()) break;
            String string3 = UIStringUtils.getFirstExtName(string2);
            arrayList.add(string3);
            n = string.indexOf(string3) + string3.length();
        }
        return arrayList;
    }

    private static String getFirstExtName(String string) {
        String string2 = "";
        if (string.startsWith("\"")) {
            if (string.endsWith("\"") && string.indexOf("\"", 1) == string.length() - 1) {
                string2 = string;
            }
            if (string.indexOf("\"", 1) < string.length() - 1) {
                string2 = string.substring(0, string.indexOf("\"", 1) + 1);
            }
        } else {
            string2 = string.contains(",") ? string.substring(0, string.indexOf(",", 0)) : string;
        }
        return string2;
    }
}

