/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.view.ColumnNode;
import oracle.hcs.tree.view.CheckTreeManager;
import oracle.hcs.util.SourceObjectTree;
import oracle.hcs.util.TableDisplay;

public class SourceCheckboxTree
extends SourceObjectTree {
    private CheckTreeManager checkTreeManager;

    public SourceCheckboxTree() {
    }

    public SourceCheckboxTree(TreeNode treeNode) {
        super(treeNode);
    }

    public void setSelectedAll(boolean bl) {
        this.checkTreeManager.setSelectedAll(bl);
    }

    public void setSelected(Object object, boolean bl) {
        TreeNode treeNode = this.findNodeForObject(object);
        if (treeNode != null) {
            TreePath treePath = SourceCheckboxTree.getPath(treeNode);
            this.checkTreeManager.setSelected(treePath, bl);
        }
    }

    private TreeNode findNodeForObject(Object object) {
        Object object2 = this.getModel().getRoot();
        if (object2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            return this.findNodeForObject(defaultMutableTreeNode, object);
        }
        return null;
    }

    private DefaultMutableTreeNode findNodeForObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 != null && object2.equals(object)) {
            return defaultMutableTreeNode;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            DefaultMutableTreeNode defaultMutableTreeNode3;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || (defaultMutableTreeNode3 = this.findNodeForObject(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode, object)) == null) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    public boolean isSelected(Object object) {
        Object object2 = this.getModel().getRoot();
        if (object2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            boolean bl = this.isNodeSelected(defaultMutableTreeNode, object);
            return bl;
        }
        return false;
    }

    private boolean isNodeSelected(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 != null && object2.equals(object)) {
            TreePath treePath = SourceCheckboxTree.getPath(defaultMutableTreeNode);
            boolean bl = true;
            boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl);
            return bl2;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || !this.isNodeSelected(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode, object)) continue;
            return true;
        }
        return false;
    }

    public boolean isFullySelected() {
        Object object = this.getModel().getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            boolean bl = this.isNodeFullySelected(defaultMutableTreeNode);
            return bl;
        }
        return true;
    }

    private boolean isNodeFullySelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = SourceCheckboxTree.getPath(defaultMutableTreeNode);
        boolean bl = true;
        boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl);
        if (!bl2) {
            return false;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || this.isNodeFullySelected(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode)) continue;
            return false;
        }
        return true;
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode, List<Column> list) {
        defaultMutableTreeNode.setAllowsChildren(true);
        DatabaseSource databaseSource = (DatabaseSource)defaultMutableTreeNode.getUserObject();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Column column : databaseSource.getColumns()) {
            for (Column column2 : list) {
                if (!column.getName().equalsIgnoreCase(column2.getName())) continue;
                arrayList.add(column2.toString());
            }
        }
        databaseSource.setColumns(list.toArray(new Column[list.size()]));
        this.addNode(defaultMutableTreeNode, false);
        if (arrayList.size() > 0) {
            this.checkTreeManager.setSelected(SourceCheckboxTree.getPath(defaultMutableTreeNode), false);
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                String string = defaultMutableTreeNode2.getUserObject().toString();
                for (String string2 : arrayList) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    this.checkTreeManager.setSelected(SourceCheckboxTree.getPath(defaultMutableTreeNode2), true);
                }
            }
        }
    }

    @Override
    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addNode(defaultMutableTreeNode, true);
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        defaultMutableTreeNode.setAllowsChildren(true);
        if (!this.isNodeChild(defaultMutableTreeNode)) {
            Object object;
            DatabaseSource databaseSource = (DatabaseSource)defaultMutableTreeNode.getUserObject();
            if (this.tableDisplay.contains((Object)TableDisplay.COLUMNS) && (object = databaseSource.getColumns()) != null && defaultMutableTreeNode.getChildCount() < 1) {
                for (Object object2 : object) {
                    ColumnNode columnNode = new ColumnNode((Column)object2);
                    defaultMutableTreeNode.add(columnNode);
                }
            }
            if ((object = this.getModel()) instanceof DefaultTreeModel) {
                Object object3 = object;
                DefaultMutableTreeNode defaultMutableTreeNode2 = ((DefaultTreeModel)object3).getRoot() == null ? new DefaultMutableTreeNode("root") : (DefaultMutableTreeNode)((DefaultTreeModel)object3).getRoot();
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                ((DefaultTreeModel)object3).setRoot(defaultMutableTreeNode2);
                if (bl) {
                    this.checkTreeManager.setSelected(SourceCheckboxTree.getPath(defaultMutableTreeNode), true);
                }
            }
        }
    }

    @Override
    public List<DatabaseSource> getList() {
        ArrayList<DatabaseSource> arrayList = new ArrayList<DatabaseSource>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        this.visitAllNodes(defaultMutableTreeNode, arrayList);
        return arrayList;
    }

    @Override
    protected void initUI() {
        super.initUI();
        this.checkTreeManager = new CheckTreeManager(this);
    }

    private void visitAllNodes(DefaultMutableTreeNode defaultMutableTreeNode, List<DatabaseSource> list) {
        if (defaultMutableTreeNode.getChildCount() > 0) {
            Serializable serializable;
            Enumeration<TreeNode> enumeration;
            if (defaultMutableTreeNode.getParent() != null && (enumeration = defaultMutableTreeNode.getUserObject()) != null) {
                serializable = SourceCheckboxTree.getPath(defaultMutableTreeNode);
                boolean bl = true;
                boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected((TreePath)serializable, bl);
                if (bl2) {
                    DatabaseSource databaseSource = (DatabaseSource)((Object)enumeration);
                    list.add(databaseSource);
                } else {
                    boolean bl3 = this.checkTreeManager.getSelectionModel().isPartiallySelected((TreePath)serializable);
                    if (bl3) {
                        ArrayList<Column> arrayList = new ArrayList<Column>();
                        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                            DefaultMutableTreeNode defaultMutableTreeNode2;
                            Object object;
                            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
                            if (!(treeNode instanceof DefaultMutableTreeNode) || (object = (defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode).getUserObject()) == null) continue;
                            TreePath treePath = SourceCheckboxTree.getPath(treeNode);
                            boolean bl4 = true;
                            boolean bl5 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl4);
                            if (!bl5) continue;
                            arrayList.add((Column)object);
                        }
                        DatabaseSource databaseSource = (DatabaseSource)((Object)enumeration);
                        databaseSource.setColumns(arrayList.toArray(new Column[arrayList.size()]));
                        list.add(databaseSource);
                    }
                }
            }
            enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                serializable = (DefaultMutableTreeNode)enumeration.nextElement();
                this.visitAllNodes((DefaultMutableTreeNode)serializable, list);
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.checkTreeManager != null) {
            this.checkTreeManager.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.checkTreeManager != null) {
            this.checkTreeManager.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

