/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RestrictedTextField
extends JTextField {
    public static final int NONE = 0;
    public static final int UPPER_CASE = 1;
    public static final int DIGITS = 2;
    private int m_filter = 0;
    private int m_maxlen = Integer.MAX_VALUE;

    public RestrictedTextField() {
    }

    public RestrictedTextField(int n) {
        super(n);
    }

    public RestrictedTextField(String string) {
        super(string);
    }

    public RestrictedTextField(String string, int n) {
        super(string, n);
    }

    public RestrictedTextField(Document document, String string, int n) {
        super(document, string, n);
    }

    public void setFilterMode(int n) {
        this.m_filter = n;
    }

    public void setMaximumLength(int n) {
        this.m_maxlen = n;
    }

    @Override
    protected Document createDefaultModel() {
        return new RestrictedDocument();
    }

    class RestrictedDocument
    extends PlainDocument {
        RestrictedDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null) {
                if (RestrictedTextField.this.m_filter == 1) {
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = Character.toUpperCase(cArray[i]);
                    }
                    string = new String(cArray);
                } else if (RestrictedTextField.this.m_filter == 2) {
                    char[] cArray = new char[string.length()];
                    int n2 = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        if (!Character.isDigit(string.charAt(i))) continue;
                        cArray[n2++] = string.charAt(i);
                    }
                    string = new String(cArray, 0, n2);
                }
                if (this.getLength() + string.length() <= RestrictedTextField.this.m_maxlen) {
                    super.insertString(n, string, attributeSet);
                }
            }
        }
    }
}

