/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.Hashtable;

public class CursorUtil {
    private static Hashtable m_busyCursorCount = new Hashtable();

    public static synchronized void setBusyCursor(Component component) {
        if (CursorUtil.incrementBusyCursorCount(component) == 1) {
            CursorUtil.setCursor(3, component);
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                CursorUtil.setBusyCursor(componentArray[i]);
            }
        }
    }

    public static synchronized void setDefaultCursor(Component component) {
        if (CursorUtil.decrementBusyCursorCount(component) == 0) {
            int n = 0;
            CursorUtil.setCursor(n, component);
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                CursorUtil.setDefaultCursor(componentArray[i]);
            }
        }
    }

    private static synchronized int incrementBusyCursorCount(Component component) {
        int n = 0;
        Integer n2 = (Integer)m_busyCursorCount.get(component);
        if (n2 != null) {
            n = n2;
        }
        m_busyCursorCount.put(component, new Integer(++n));
        return n;
    }

    private static void setCursor(int n, Component component) {
        Cursor cursor = null;
        cursor = n == 0 ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(n);
        component.setCursor(cursor);
    }

    private static synchronized int decrementBusyCursorCount(Component component) {
        int n = 0;
        Integer n2 = (Integer)m_busyCursorCount.get(component);
        if (n2 != null && (n = n2.intValue()) > 0) {
            m_busyCursorCount.put(component, new Integer(--n));
        }
        return n;
    }
}

