/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.hcs.HCSArb;

public class CheckBoxHeader
extends JCheckBox
implements TableCellRenderer,
MouseListener {
    protected CheckBoxHeader rendererComponent;
    protected int column;
    protected boolean mousePressed = false;
    private JTable table;

    public CheckBoxHeader(final JTable jTable) {
        this.table = jTable;
        this.rendererComponent = this;
        this.rendererComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (!(object instanceof AbstractButton)) {
                    return;
                }
                AbstractButton abstractButton = (AbstractButton)object;
                boolean bl = abstractButton.isSelected();
                int n = jTable.getRowCount();
                for (int i = 0; i < n; ++i) {
                    jTable.setValueAt(new Boolean(bl), i, 0);
                }
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTableHeader jTableHeader;
        if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
            this.rendererComponent.setForeground(jTableHeader.getForeground());
            this.rendererComponent.setBackground(jTableHeader.getBackground());
            this.rendererComponent.setFont(jTableHeader.getFont());
            jTableHeader.addMouseListener(this.rendererComponent);
        }
        this.setColumn(n2);
        this.rendererComponent.setText(HCSArb.get("MEASURE_SELECT_COLUMN"));
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this.rendererComponent;
    }

    protected void setColumn(int n) {
        this.column = n;
    }

    public int getColumn() {
        return this.column;
    }

    protected void handleClickEvent(MouseEvent mouseEvent) {
        if (this.mousePressed) {
            this.mousePressed = false;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = jTable.convertColumnIndexToModel(n);
            if (n == this.column && mouseEvent.getClickCount() == 1 && n2 != -1) {
                this.doClick();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.handleClickEvent(mouseEvent);
        ((JTableHeader)mouseEvent.getSource()).repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

