/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.hcs.templates.templateview.AbstractTemplateJTree;
import oracle.hcs.templates.templateview.BaseTemplateHyperView;
import oracle.hcs.templates.templateview.TemplateGroupHyperView;
import oracle.hcs.templates.templateview.TemplateListHyperView;
import oracle.hcs.templates.templateview.TemplateNodeRenderer;
import oracle.hcs.templates.templateview.TemplateViewNode;

public class TemplateJTree
extends AbstractTemplateJTree {
    private static final Logger LOG = Logger.getLogger(TemplateGroupHyperView.class.getName());
    private TemplateNodeRenderer treeRenderer;

    public TemplateJTree(TemplateListHyperView templateListHyperView) {
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        this.treeRenderer = new TemplateNodeRenderer(this);
        this.treeRenderer.setupTreeRendering();
        templateListHyperView.setTemplateTree(this);
        try {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            for (TemplateGroupHyperView templateGroupHyperView : templateListHyperView.getTemplateGroupHyperViews()) {
                templateGroupHyperView.addTemplateNodes(defaultMutableTreeNode);
            }
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.setModel(defaultTreeModel);
        }
        catch (IOException | SQLException exception) {
            LOG.log(Level.SEVERE, "Create Nodes", exception);
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath treePath = TemplateJTree.this.getPathForRow(2);
                TemplateJTree.this.setSelectionPath(treePath);
                TemplateJTree.this.startEditingAtPath(treePath);
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getPath().getLastPathComponent();
        if (object instanceof TemplateViewNode) {
            TemplateViewNode templateViewNode = (TemplateViewNode)object;
            this.setActions(templateViewNode.getActions());
        } else {
            this.setActions(Collections.emptyList());
        }
    }

    public void addChild(DefaultMutableTreeNode defaultMutableTreeNode, BaseTemplateHyperView baseTemplateHyperView) {
        TemplateViewNode templateViewNode = new TemplateViewNode(baseTemplateHyperView);
        defaultMutableTreeNode.add(templateViewNode);
        if (this.getModel() instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
            TreePath treePath = TemplateJTree.getPath(templateViewNode);
            this.startEditOnPath(treePath);
        }
    }

    public void removeChild(DefaultMutableTreeNode defaultMutableTreeNode, BaseTemplateHyperView baseTemplateHyperView) {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            TemplateViewNode templateViewNode;
            object = defaultMutableTreeNode.getChildAt(i);
            defaultMutableTreeNode2 = ((DefaultMutableTreeNode)object).getNextSibling();
            if (defaultMutableTreeNode2 == null && (defaultMutableTreeNode2 = ((DefaultMutableTreeNode)object).getPreviousSibling()) == null) {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
            }
            if ((templateViewNode = (TemplateViewNode)object).getBaseTemplateHyperView() != baseTemplateHyperView) continue;
            defaultMutableTreeNode.remove(templateViewNode);
            break;
        }
        if (this.getModel() instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
            if (defaultMutableTreeNode2 != null) {
                object = TemplateJTree.getPath(defaultMutableTreeNode2);
                this.startEditOnPath((TreePath)object);
            }
        }
    }

    public void refresh() {
        this.treeRenderer.adjustTreeDisplay();
    }

    private void startEditOnPath(final TreePath treePath) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateJTree.this.setSelectionPath(treePath);
                TemplateJTree.this.startEditingAtPath(treePath);
            }
        });
    }
}

