/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.SyntaxListener;
import oracle.hcs.templates.templateview.TemplateData;

public abstract class TemplateGUI {
    protected EventListenerList listenerList = new EventListenerList();
    public static final String CONTAINER_NAME = "TEMPLATEGUI_CONTAINER";

    public void addSyntaxListener(SyntaxListener syntaxListener) {
        this.listenerList.add(SyntaxListener.class, syntaxListener);
    }

    public void removeSyntaxListener(SyntaxListener syntaxListener) {
        this.listenerList.remove(SyntaxListener.class, syntaxListener);
    }

    protected void fireSyntaxChanged(Object object) throws SQLException, IOException {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SyntaxListener.class) continue;
            ((SyntaxListener)objectArray[i + 1]).syntaxChanged(object, this.getSyntax());
        }
    }

    public abstract String getSyntax() throws SQLException, IOException;

    public abstract TemplateData getSyntax(TemplateData.Mode var1) throws SQLException, IOException;

    public abstract Component getComponent();

    public abstract JPanel getTemplateViewPanel();

    public abstract void loadParseNode(ParseNode var1, String var2);

    public abstract void setValueMap(Map<String, String> var1);

    public abstract void dispose();
}

