/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.util.FetchIcon;
import oracle.hcs.util.Resources;

public class MeasureTreeNode
implements TreeNode {
    private static final String AV_ICON = "AV_ICON";
    private static final String AV_FOLDER_ICON = "AV_FOLDER_ICON";
    private static final String MEASURE_ICON = "MEASURE_ICON";
    private static final String MEASURE_FOLDER_ICON = "MEASURE_FOLDER_ICON";
    private static final String CALC_ICON = "HCSCALCMEASURE_ICON";
    private static final String CALC_FOLDER_ICON = "HCSCALCMEASURE_FOLDER_ICON";
    private static final String TITLE = "MEASURE_PICKER_TITLE";
    private static final String CALC_MEASURES = "MEASURE_PICKER_CALC_MEASURES";
    private static final String MEASURES = "MEASURE_PICKER_MEASURES";
    private static final String OTHER_AVS = "MEASURE_PICKER_OTHER_AVS";
    private final Vector<MeasureTreeNode> children = new Vector();
    private MeasureTreeNode parent;
    private final String text;
    private final String id;
    private final Icon icon;
    private final AVBaseMeasure measure;
    private AnalyticView analyticView;
    private List<AnalyticView> analyticViews;
    private Resources r;
    private FetchIcon fi;

    MeasureTreeNode(AnalyticView analyticView, List<AnalyticView> list, Resources resources, FetchIcon fetchIcon) {
        this(analyticView.getName(), null);
        this.analyticView = analyticView;
        this.r = resources;
        this.fi = fetchIcon;
        this.add(new MeasureTreeNode(analyticView, resources, fetchIcon));
        Collections.sort(list, new Comparator<AnalyticView>(){

            @Override
            public int compare(AnalyticView analyticView, AnalyticView analyticView2) {
                return analyticView.getName().compareTo(analyticView2.getName());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        this.analyticViews = list;
    }

    private MeasureTreeNode(String string, Icon icon) {
        this(string, null, icon);
    }

    MeasureTreeNode(String string, String string2, Icon icon) {
        this(string, string2, null, icon);
    }

    private MeasureTreeNode(String string, String string2, AVBaseMeasure aVBaseMeasure, Icon icon) {
        this.text = string;
        this.icon = icon;
        if (aVBaseMeasure != null) {
            this.id = aVBaseMeasure.getFullID();
            this.measure = aVBaseMeasure;
        } else {
            this.id = string2;
            this.measure = null;
        }
    }

    private MeasureTreeNode(AnalyticView analyticView, Resources resources, FetchIcon fetchIcon) {
        this(analyticView.getName(), fetchIcon.getIcon(AV_ICON));
        MeasureTreeNode measureTreeNode = new MeasureTreeNode(resources.getString(MEASURES), fetchIcon.getIcon(MEASURE_FOLDER_ICON));
        MeasureTreeNode measureTreeNode2 = new MeasureTreeNode(resources.getString(CALC_MEASURES), fetchIcon.getIcon(CALC_FOLDER_ICON));
        List<AVBaseMeasure> list = analyticView.getStoredAndCalculatedMeasures();
        Collections.sort(list, new Comparator<AVBaseMeasure>(){

            @Override
            public int compare(AVBaseMeasure aVBaseMeasure, AVBaseMeasure aVBaseMeasure2) {
                return aVBaseMeasure.getName().compareTo(aVBaseMeasure2.getName());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        for (AVBaseMeasure aVBaseMeasure : list) {
            if (aVBaseMeasure.getType().equals("MEASURE2")) {
                measureTreeNode.add(new MeasureTreeNode(aVBaseMeasure, fetchIcon));
                continue;
            }
            measureTreeNode2.add(new MeasureTreeNode(aVBaseMeasure, fetchIcon));
        }
        this.add(measureTreeNode);
        this.add(measureTreeNode2);
    }

    private MeasureTreeNode(AVBaseMeasure aVBaseMeasure, FetchIcon fetchIcon) {
        this(aVBaseMeasure.getName(), null, aVBaseMeasure, aVBaseMeasure.getType().equals("CALCULATED_MEASURE2") ? fetchIcon.getIcon(CALC_ICON) : fetchIcon.getIcon(MEASURE_ICON));
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.children.get(n);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.children.indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public String toString() {
        return this.text;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getID() {
        return this.id;
    }

    public MeasureTreeNode find(String string) {
        MeasureTreeNode measureTreeNode = null;
        if (this.id != null && this.id.equals(string)) {
            return this;
        }
        for (MeasureTreeNode measureTreeNode2 : this.children) {
            measureTreeNode = measureTreeNode2.find(string);
            if (measureTreeNode == null) continue;
            return measureTreeNode;
        }
        return null;
    }

    void add(MeasureTreeNode measureTreeNode) {
        this.children.add(measureTreeNode);
        measureTreeNode.parent = this;
    }

    void clear() {
        this.children.removeAllElements();
    }

    public AbstractChildObjectWithDesc getMeasure() {
        return this.measure;
    }

    public List<MeasureTreeNode> getChildren() {
        ArrayList<MeasureTreeNode> arrayList = new ArrayList<MeasureTreeNode>();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add((MeasureTreeNode)this.getChildAt(i));
        }
        return arrayList;
    }

    public boolean matches(String string) {
        if (this.measure == null) {
            return false;
        }
        String string2 = this.measure.getName().toUpperCase();
        return (string = string.trim().toUpperCase()).endsWith("%") ? string2.startsWith(string.substring(0, string.length() - 1)) : (string.startsWith("%") ? string2.endsWith(string.substring(1)) : string2.startsWith(string));
    }
}

