/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.syntaxparser.testing;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.hcs.syntaxbuilder.WrappedSyntaxParser;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PermutationPersistence {
    private Element root;
    private Document doc;
    private String wrap;

    public PermutationPersistence(SyntaxParser syntaxParser) {
        if (syntaxParser instanceof WrappedSyntaxParser) {
            this.wrap = ((WrappedSyntaxParser)syntaxParser).getWrapper();
        }
        this.buildDoc();
    }

    private void buildDoc() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.doc = documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public void outputDoc(String string) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(this.root);
            String string2 = String.format("%s/%s.xml", System.getProperties().get("user.home"), string);
            File file = new File(string2);
            transformer.transform(dOMSource, new StreamResult(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void persistXML(String string, String string2, LinkedHashMap<String, ParseNode> linkedHashMap, Map<String, List<String>> map) {
        this.root = this.persistXML(this.doc, this.root, string, string2, linkedHashMap, map);
    }

    private Element persistXML(Document document, Element element, String string, String string2, LinkedHashMap<String, ParseNode> linkedHashMap, Map<String, List<String>> map) {
        try {
            if (element == null) {
                element = document.createElement("Template");
                element.setAttribute("name", string);
                if (this.wrap != null) {
                    element.setAttribute("wrap", this.wrap);
                }
            }
            Element element2 = document.createElement("Permutation");
            Element element3 = document.createElement("Expression");
            CDATASection cDATASection = document.createCDATASection(string2);
            element.appendChild(element2);
            element2.appendChild(element3);
            element3.appendChild(cDATASection);
            Element element4 = document.createElement("CurrentValues");
            element2.appendChild(element4);
            for (Map.Entry<String, List<String>> object2 : map.entrySet()) {
                List<String> list = object2.getValue();
                for (String string3 : list) {
                    Element element5 = document.createElement("Entry");
                    element5.setAttribute("key", object2.getKey());
                    element4.appendChild(element5);
                    element5.setTextContent(string3);
                }
            }
            Element element6 = document.createElement("ParamPatterns");
            element2.appendChild(element6);
            for (Map.Entry<String, ParseNode> entry : linkedHashMap.entrySet()) {
                Element element7 = document.createElement("Entry");
                element7.setAttribute("key", entry.getKey());
                element6.appendChild(element7);
                this.marshallParseNode(document, element7, entry.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }

    private void marshallParseNode(Document document, Element element, ParseNode parseNode) {
        Element element2 = document.createElement("ParseNode");
        element2.setAttribute("paramName", parseNode.getParamName());
        element2.setAttribute("userObject", parseNode.getValue());
        element2.setAttribute("fullValue", parseNode.getFullValue());
        element2.setAttribute("type", parseNode.getType());
        element2.setAttribute("checkName", String.valueOf(parseNode.isCheckName()));
        element2.setAttribute("offset", String.valueOf(parseNode.getOffset()));
        element2.setAttribute("end", String.valueOf(parseNode.getEnd()));
        element2.setAttribute("replaceOffset", String.valueOf(parseNode.getReplaceOffset()));
        element2.setAttribute("replaceEnd", String.valueOf(parseNode.getReplaceEnd()));
        element2.setAttribute("patternType", parseNode.getPatternType().toString());
        Element element3 = document.createElement("paramNames");
        for (String object : parseNode.getParamNames()) {
            Element element4 = document.createElement("name");
            element3.appendChild(element4);
            element4.setTextContent(object);
        }
        element.appendChild(element2);
        for (TreeNode treeNode : parseNode.getChildren()) {
            this.marshallParseNode(document, element2, (ParseNode)treeNode);
        }
    }
}

