/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.syntaxparser;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import oracle.hcs.templates.syntaxparser.FlatNode;
import oracle.hcs.templates.syntaxparser.NodeProcessor;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.TemplateHyperParam;

class Matcher
implements NodeProcessor {
    private static final Logger LOG = Logger.getLogger(Matcher.class.getName());
    private boolean abort;
    private FlatNode flatList;
    private FlatNode prev;
    private int score;
    private List<TemplateHyperParam> pendingParams;

    public Matcher(FlatNode flatNode) {
        this(flatNode, null);
    }

    public Matcher(FlatNode flatNode, List<TemplateHyperParam> list) {
        this.flatList = flatNode;
        flatNode.restartMatch();
        this.pendingParams = list != null ? new LinkedList<TemplateHyperParam>(list) : null;
    }

    @Override
    public ParseNode processNode(ParseNode parseNode) {
        if (this.flatList == null) {
            this.abort = true;
            return null;
        }
        int n = this.flatList.matches(parseNode);
        if (n == 0) {
            this.prev = this.flatList;
            this.flatList = this.flatList.getSpecial();
            if (this.flatList == null) {
                this.score = 0;
                this.abort = true;
                return null;
            }
            if (this.prev != null && this.pendingParams != null) {
                this.prev.tryLoad(this.pendingParams, null);
            }
            this.flatList.restartMatch();
            return this.processNode(parseNode);
        }
        this.tryLoad(parseNode);
        this.prev = this.flatList;
        this.flatList = this.flatList.nextMatch();
        if (this.prev != this.flatList && this.flatList != null) {
            this.flatList.restartMatch();
        }
        if (n > 0) {
            this.score += n;
        }
        return parseNode;
    }

    @Override
    public void finish() {
        if (this.pendingParams != null && !this.pendingParams.isEmpty()) {
            if (this.flatList != null) {
                this.flatList.tryLoad(this.pendingParams, null);
                this.flatList = this.flatList.getNext();
            }
            while (this.flatList != null) {
                this.flatList.restartMatch();
                this.flatList.tryLoad(this.pendingParams, null);
                this.flatList = this.flatList.getNext();
            }
        }
    }

    private void tryLoad(ParseNode parseNode) {
        if (this.pendingParams != null && !this.pendingParams.isEmpty()) {
            this.flatList.tryLoad(this.pendingParams, parseNode);
        }
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public boolean abort() {
        return this.abort;
    }

    @Override
    public FlatNode getFlatList() {
        return this.flatList;
    }
}

