/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.db.RowSetCallBack;
import oracle.hcs.db.RowSetMetadataCallback;
import oracle.hcs.table.Column;
import oracle.hcs.table.Query;
import oracle.hcs.table.QueryResultStatistics;
import oracle.hcs.table.View;

public class QueryTableModel
extends DefaultTableModel {
    private boolean m_changed;
    private String[] m_columnNames;
    private int totalRows;
    private int m_columnCount;
    private Connection m_conn;
    private Query m_query;
    private Map<String, Object> m_queryParams = new HashMap<String, Object>();
    private QueryResultStatistics queryResultStatistics;

    public QueryTableModel(Connection connection, Query query, Map<String, Object> map) {
        this.m_conn = connection;
        this.m_query = query;
        this.m_queryParams = map;
        this.queryResultStatistics = new QueryResultStatistics();
        this.initColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateQueryTableDataModel() throws SQLException {
        boolean bl = false;
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_conn);
        dBUtil.setRaiseError(true);
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.m_conn)) {
            block12: {
                try {
                    if (this.m_columnCount == 0) {
                        RowSetMetadataCallback rowSetMetadataCallback = new RowSetMetadataCallback(){

                            @Override
                            public void processRowSetMetadata(ResultSetMetaData resultSetMetaData) throws SQLException {
                                QueryTableModel.this.m_columnCount = resultSetMetaData.getColumnCount();
                                QueryTableModel.this.m_columnNames = new String[QueryTableModel.this.m_columnCount];
                                for (int i = 1; i <= QueryTableModel.this.m_columnCount; ++i) {
                                    QueryTableModel.this.m_columnNames[i - 1] = resultSetMetaData.getColumnName(i);
                                    QueryTableModel.this.addColumn(resultSetMetaData.getColumnName(i));
                                }
                            }
                        };
                        RowSetCallBack rowSetCallBack = new RowSetCallBack(){
                            int row = 0;

                            @Override
                            public void processRowSet(ResultSet resultSet) throws SQLException {
                                Vector<String> vector = new Vector<String>();
                                for (int i = 0; i < QueryTableModel.this.m_columnCount; ++i) {
                                    vector.add(resultSet.getString(i + 1));
                                }
                                ++this.row;
                                QueryTableModel.this.addRow(vector);
                                QueryTableModel.this.m_changed = true;
                                QueryTableModel.this.totalRows = this.row;
                            }
                        };
                        this.queryResultStatistics.setStartDate(new Date());
                        resultSet = dBUtil.executeQuery(this.m_query.getText(), this.m_queryParams);
                        this.queryResultStatistics.setEndDate(new Date());
                        if (resultSet != null && resultSet != null) {
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            if (rowSetMetadataCallback != null) {
                                rowSetMetadataCallback.processRowSetMetadata(resultSetMetaData);
                            }
                            if (resultSetMetaData != null) {
                                while (resultSet.next()) {
                                    rowSetCallBack.processRowSet(resultSet);
                                }
                            }
                        }
                        break block12;
                    }
                    ArrayList arrayList = new ArrayList();
                    Vector<String> vector = new Vector<String>();
                    this.m_changed = false;
                    String string = this.m_query.getText();
                    this.queryResultStatistics.setStartDate(new Date());
                    resultSet = dBUtil.executeQuery(string, this.m_queryParams);
                    this.queryResultStatistics.setEndDate(new Date());
                    if (resultSet == null) break block12;
                    int n = 0;
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            vector = new Vector();
                            for (int i = 0; i < this.m_columnCount; ++i) {
                                vector.add(resultSet.getString(i + 1));
                            }
                            ++n;
                            arrayList.add(vector);
                        }
                    }
                    if (n <= this.totalRows) break block12;
                    this.setRowCount(0);
                    for (Vector vector2 : arrayList) {
                        this.addRow(vector2);
                        this.m_changed = true;
                    }
                    this.totalRows = arrayList.size();
                }
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(this.m_conn);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.m_conn);
        }
        bl = this.m_changed;
        return bl;
    }

    public QueryResultStatistics getQueryResultStatistics() {
        this.queryResultStatistics.setRowCount(this.totalRows);
        return this.queryResultStatistics;
    }

    public void resetColumnCount() {
        this.m_columnCount = 0;
    }

    public int getNumOfRows() {
        return this.totalRows;
    }

    public Query getQuery() {
        return this.m_query;
    }

    private void initColumnCount() {
        View view = this.m_query.getView();
        if (view != null && this.m_columnCount == 0) {
            List<Column> list = view.getColumnList();
            for (Column column : list) {
                this.addColumn(column.getName());
                ++this.m_columnCount;
            }
        }
    }
}

