/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.shuttle;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import oracle.hcs.syntaxbuilder.shuttle.GuiNodeSelector;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.templates.templateview.TemplateData;

public class DragHandler
extends TransferHandler {
    private static final DataFlavor[] TRANSFER_FLAVORS = new DataFlavor[]{TemplateData.templateFlavor};
    private GuiNodeSelector selector;

    public DragHandler(GuiNodeSelector guiNodeSelector) {
        this.selector = guiNodeSelector;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return TRANSFER_FLAVORS;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return TemplateData.templateFlavor == dataFlavor;
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                String string = DragHandler.this.getSelectedType();
                if (string != null) {
                    return new TemplateData(string, TemplateData.Mode.WRAP);
                }
                return null;
            }
        };
    }

    private String getSelectedType() {
        SpecTreeNode specTreeNode = this.selector.getSelectedNode();
        if (specTreeNode != null) {
            return specTreeNode.getType();
        }
        return null;
    }
}

