/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.qdr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchyviewer.HierarchyET;
import oracle.hcs.hierarchyviewer.HierarchyViewerDialog;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.qdr.QDRTableModel;
import oracle.hcs.table.Queries;
import oracle.hcs.table.TableCellButtonWrapper;
import oracle.hcs.templates.templateview.QDRData;
import oracle.hcs.tree.model.DefaultNode;
import oracle.hcs.tree.model.HierarchyNodeData;
import oracle.hcs.util.JavaXMLBind;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class QDRPanel
extends JPanel {
    private transient Logger LOG = Logger.getLogger(QDRPanel.class.getName());
    private final QDRTableModel model;
    private transient Connection conn;
    private final String owner;
    private static final String XMLFILE = "QDRQueries.xml";
    private static final String PACK = "oracle.hcs.table";
    private transient Queries queries;
    private HCSSchema schema;
    private String initialHierarchy;

    public QDRPanel(Connection connection, Vector<QDRData> vector, String string, String string2) {
        super(new BorderLayout());
        this.conn = connection;
        this.owner = string;
        this.initialHierarchy = string2;
        try {
            this.queries = (Queries)JavaXMLBind.BindToJava(this.getClass().getResource(XMLFILE), PACK, null);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olap_select_qdr");
        final JTable jTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add((Component)jScrollPane, "Center");
        this.model = new QDRTableModel(vector);
        jTable.setModel(this.model);
        TableColumn tableColumn = jTable.getColumn(QDRTableModel.COLUMNS[1]);
        JTextField jTextField = new JTextField();
        jTextField.setEditable(true);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        SearchButton searchButton = new SearchButton(defaultCellEditor);
        SearchButton searchButton2 = new SearchButton(new DefaultTableCellRenderer());
        tableColumn.setCellEditor(searchButton);
        tableColumn.setCellRenderer(searchButton2);
        AbstractAction abstractAction = new AbstractAction("MEMBERSELECTOR"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                if (n >= 0 && n < QDRPanel.this.model.getRowCount()) {
                    QDRPanel.this.showSelector(n);
                }
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(114, 0);
        jTable.getInputMap(1).put(keyStroke, abstractAction.getValue("Name"));
        jTable.getActionMap().put(abstractAction.getValue("Name"), abstractAction);
        jTable.getInputMap().put(keyStroke, abstractAction.getValue("Name"));
        jTable.getActionMap().put(abstractAction.getValue("Name"), abstractAction);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showSelector(int n) {
        Object object;
        String string = (String)this.model.getValueAt(n, 2);
        QDRData qDRData = this.model.getRowValue(n);
        QDRData[] qDRDataArray = null;
        Window window = SwingUtilities.getWindowAncestor(this);
        String string2 = HCSArb.getString("DIMENSION_MEMBER_SELECTOR_TITLE");
        String string3 = qDRData.getMemberKey();
        if (string3 != null) {
            qDRDataArray = new QDRData[]{qDRData};
        }
        String string4 = Connections.getInstance().getConnectionName(this.conn);
        try {
            this.schema = HCSMetadataCache.getUpdatedSchema(string4, this.owner);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        ArrayList<HierarchyET> arrayList = new ArrayList<HierarchyET>();
        boolean bl = false;
        if (!bl) {
            object = this.schema.findHierarchy(string);
            try {
                arrayList.add(new HierarchyET(this.conn, (Hierarchy)object));
            }
            catch (IOException | SQLException exception) {
                this.LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        if (arrayList.size() > 0) {
            try {
                TreePath[] treePathArray;
                object = this.initialHierarchy;
                HierarchyViewerDialog hierarchyViewerDialog = new HierarchyViewerDialog(window, string2, arrayList, (String)object, "SELECT_DIMENSION_MEMBERS_MODE", null, qDRDataArray, null, true, this.conn);
                hierarchyViewerDialog.setModal(true);
                Dimension dimension = new Dimension(400, 400);
                hierarchyViewerDialog.setMinimumSize(dimension);
                hierarchyViewerDialog.setPreferredSize(dimension);
                hierarchyViewerDialog.setSize(dimension);
                hierarchyViewerDialog.setLocationRelativeTo(window);
                hierarchyViewerDialog.setVisible(true);
                boolean bl2 = hierarchyViewerDialog.isOKSelected();
                if (!bl2 || (treePathArray = hierarchyViewerDialog.getTree().getSelectionPaths()) == null || treePathArray.length <= 0) return;
                QDRData qDRData2 = this.model.getRowValue(n);
                QDRData qDRData3 = (QDRData)qDRData2.clone();
                for (int i = 0; i < treePathArray.length; ++i) {
                    TreePath treePath = treePathArray[i];
                    Object object2 = treePath.getLastPathComponent();
                    DefaultNode defaultNode = (DefaultNode)object2;
                    HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)defaultNode.getUserObject();
                    qDRData3.addMember(hierarchyNodeData.dimKey, hierarchyNodeData.desc, (String)hierarchyNodeData.getProperty(hierarchyNodeData.LEVEL_NAME), (String)hierarchyNodeData.getProperty(hierarchyNodeData.LEVEL_KEY));
                    this.model.setRowValue(qDRData3, n);
                }
                return;
            }
            catch (Exception exception) {
                this.LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                String string5 = exception.getLocalizedMessage();
                MessageDialog.error((Component)this, (Object)(HCSArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR") + string5), (String)HCSArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), null);
                return;
            }
        } else {
            MessageDialog.error((Component)this, (Object)HCSArb.get("DIMENSION_MEMBER_SELECTOR_NOT_FOUND"), (String)HCSArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), null);
        }
    }

    class SearchButton
    extends TableCellButtonWrapper {
        SearchButton(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer, OracleIcons.getIcon((String)"edit.png"));
        }

        SearchButton(TableCellEditor tableCellEditor) {
            super(tableCellEditor, OracleIcons.getIcon((String)"edit.png"));
        }

        @Override
        public void buttonPress() {
            QDRPanel.this.showSelector(this.getRow());
        }
    }

    class DeleteButton
    extends TableCellButtonWrapper {
        DeleteButton(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer, OracleIcons.getIcon((String)"delete.png"));
        }

        DeleteButton(TableCellEditor tableCellEditor) {
            super(tableCellEditor, OracleIcons.getIcon((String)"delete.png"));
        }

        @Override
        public void buttonPress() {
            QDRPanel.this.model.setValueAt(null, this.getRow(), this.getColumn());
        }
    }
}

