/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.editor.plugins;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AVValidationAction;
import oracle.hcs.av.calcs.CalculatedMeasurePinningTracker;
import oracle.hcs.av.calcs.CalculatedMeasureSpecTreeController;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.hcs.syntaxbuilder.editor.EditorActions;
import oracle.hcs.syntaxbuilder.editor.SyntaxEditorPinActionController;
import oracle.hcs.syntaxbuilder.editor.SyntaxEditorReadOnlyAction;
import oracle.hcs.syntaxbuilder.editor.plugins.CalcSelectionEditorPlugin;
import oracle.hcs.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.ceditor.find.BasicFindToolbarController;
import oracle.ide.ceditor.find.FindToolbarController;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Node;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class CalculatedMeasureToolbar
implements EditorPlugin {
    private Toolbar toolbar;
    private final InsertionHandlerEditorPlugin ihandler;
    private final Spec specParser;
    private final SyntaxParser parser;
    private final CalcSelectionEditorPlugin calcSel;
    private final EditorActions edActions;
    private final List<Component> remove = new ArrayList<Component>(6);
    private AVValidationAction avValidation;
    private final String INVALID = "INVALID";
    private static final Logger LOG = Logger.getLogger(CalculatedMeasureToolbar.class.getName());

    public CalculatedMeasureToolbar(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, Spec spec, SyntaxParser syntaxParser, CalcSelectionEditorPlugin calcSelectionEditorPlugin, EditorActions editorActions) {
        this.ihandler = insertionHandlerEditorPlugin;
        this.specParser = spec;
        this.parser = syntaxParser;
        this.calcSel = calcSelectionEditorPlugin;
        this.edActions = editorActions;
    }

    public void install(BasicEditorPane basicEditorPane) {
        long l = System.currentTimeMillis();
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        if (!(codeEditor.getContext().getNode() instanceof CalculatedMeasureNode)) {
            return;
        }
        this.avValidation = new AVValidationAction();
        this.toolbar = codeEditor.getToolbar();
        this.edActions.setEditorPane(basicEditorPane);
        CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)codeEditor.getContext().getNode();
        DBConnectionComboBox dBConnectionComboBox = new DBConnectionComboBox();
        this.toolbar.remove(0);
        FindToolbarController findToolbarController = AbstractFindToolbarController.getFindController((BasicEditorPane)basicEditorPane);
        if (findToolbarController != null) {
            findToolbarController.dispose();
        }
        BasicFindToolbarController basicFindToolbarController = UIUtils.createFindToolbarController((BasicEditorPane)basicEditorPane);
        JComponent jComponent = basicFindToolbarController.getToolbarsComponent();
        ((JComponent)codeEditor.getFixedTopMargin()).add(jComponent);
        this.remove.add(this.toolbar.add((Component)this.createPinToggleButton(basicEditorPane)));
        this.remove.add(this.toolbar.add(this.edActions.get(EditorActions.Type.VALIDATE)));
        this.remove.add((Component)this.toolbar.add((ToggleAction)IdeActions.getViewRefreshAction()));
        this.remove.add((Component)this.toolbar.add((ToggleAction)IdeAction.find((int)CalculatedMeasureSpecTreeController.SPEC_TREE_ACTION_CMD_ID)));
        this.remove.add(this.toolbar.add(this.edActions.get(EditorActions.Type.RUN)));
        this.remove.add(this.toolbar.add(this.edActions.get(EditorActions.Type.COMPILE)));
        this.remove.add(this.toolbar.add((Component)this.createROToggleButton(basicEditorPane)));
        this.remove.add(this.toolbar.add((Component)this.createForceCreateCalcCheckBox(calculatedMeasureNode, basicEditorPane)));
        this.remove.add(this.toolbar.add(Box.createHorizontalGlue()));
        this.remove.add(this.toolbar.add((Component)dBConnectionComboBox.getJComboBox()));
        dBConnectionComboBox.setCurrentConnection(calculatedMeasureNode.getConnectionName());
        dBConnectionComboBox.getJComboBox().setEnabled(false);
        this.edActions.stateChanged(null);
        View.updateToolbarActions((Toolbar)this.toolbar);
        LOG.finest(String.format("installed toolbar: %s%n", System.currentTimeMillis() - l));
    }

    private JCheckBox createForceCreateCalcCheckBox(final CalculatedMeasureNode calculatedMeasureNode, final BasicEditorPane basicEditorPane) {
        final JCheckBox jCheckBox = new JCheckBox(HCSArb.getString("FORCE_CREATE_CALC"));
        jCheckBox.setName("ForceCreateCalcCheckBox");
        try {
            Connection connection = Connections.getInstance().getConnection(calculatedMeasureNode.getConnectionName());
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            String string = calculatedMeasureNode.getAVName();
            String string2 = calculatedMeasureNode.getSchemaName();
            String string3 = this.avValidation.isAVValid(string, string2, dBUtil);
            if (string3 != null) {
                jCheckBox.setSelected(string3.equals("INVALID"));
                calculatedMeasureNode.setForceCreate(jCheckBox.isSelected());
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage());
        }
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
                ContextMenu contextMenu = codeEditor.getContextMenu();
                JPopupMenu jPopupMenu = (JPopupMenu)contextMenu.getGUI(false);
                if (jPopupMenu != null) {
                    Component[] componentArray;
                    for (Component component : componentArray = jPopupMenu.getComponents()) {
                        ToggleMenuItem toggleMenuItem;
                        String string;
                        if (!(component instanceof ToggleMenuItem) || !(string = (toggleMenuItem = (ToggleMenuItem)component).getText()).equals(HCSArb.getString("FORCE_CREATE_CALC"))) continue;
                        toggleMenuItem.setSelected(jCheckBox.isSelected());
                    }
                }
                calculatedMeasureNode.setForceCreate(jCheckBox.isSelected());
            }
        });
        return jCheckBox;
    }

    private ToggleToolButton createROToggleButton(BasicEditorPane basicEditorPane) {
        ToggleToolButton toggleToolButton = null;
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        IdeAction ideAction = IdeAction.findOrCreate((int)SyntaxEditorReadOnlyAction.READ_ONLY_CMD_ID, null, (String)Messages.getString((String)"PLSQLEditorToolbar.switchWrite"), null, null, (Icon)RaptorImagesArb.getIcon((String)"EDIT_CODE_BROKEN"), null, (boolean)true).newLocalAction((View)codeEditor);
        ideAction.putValue("ShortDescription", (Object)Messages.getString((String)"PLSQLEditorToolbar.switchWrite"));
        toggleToolButton = new ToggleToolButton((ToggleAction)ideAction);
        ideAction.addController((Controller)new SyntaxEditorReadOnlyAction(toggleToolButton, basicEditorPane));
        ideAction.setState(basicEditorPane.isEnabled());
        return toggleToolButton;
    }

    private ToggleToolButton createPinToggleButton(BasicEditorPane basicEditorPane) {
        ToggleToolButton toggleToolButton = null;
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        IdeAction ideAction = IdeAction.findOrCreate((int)SyntaxEditorPinActionController.PIN_EDITOR_CMD_ID, null, (String)IdeArb.getString((int)28), null, null, (Icon)OracleIcons.getIcon((String)"pin.png"), null, (boolean)true).newLocalAction((View)codeEditor);
        toggleToolButton = new ToggleToolButton((ToggleAction)ideAction);
        ideAction.addController((Controller)new SyntaxEditorPinActionController(toggleToolButton, this.toolbar));
        Node node = codeEditor.getContext().getNode();
        boolean bl = CalculatedMeasurePinningTracker.isPinned(node);
        ideAction.setState(bl);
        if (!bl) {
            toggleToolButton.setIcon(OracleIcons.getIcon((String)"pin.png"));
        } else {
            toggleToolButton.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
        }
        return toggleToolButton;
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        for (Component component : this.remove) {
            this.toolbar.remove(component);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

