/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import javax.swing.DropMode;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import oracle.hcs.HCSArb;
import oracle.hcs.syntaxbuilder.editor.EditorActions;
import oracle.hcs.syntaxbuilder.editor.HCSTextFormatter;
import oracle.hcs.syntaxbuilder.editor.SnippetValidator;
import oracle.hcs.syntaxbuilder.editor.SyntaxCodeEditor;
import oracle.hcs.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.syntaxbuilder.spectree.SpecJTree;
import oracle.hcs.templates.templateview.TemplateData;
import oracle.hcs.util.FetchIcon;
import oracle.hcs.util.IconButton;
import oracle.ide.controls.Toolbar;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.PopupManager;

public class SnippetCodeEditor
extends SyntaxCodeEditor {
    private SpecJTree tree;
    DataFlavor nodeFlavor = DataFlavor.stringFlavor;
    private InsertionHandlerEditorPlugin insertionHandler;
    private EditorActions actions;
    private Toolbar toolBar;
    private UndoManager undoer;
    private SnippetValidator snippetValidator;
    private JLabel editorUsageLabel;

    public SnippetCodeEditor(FetchIcon fetchIcon, HCSTextFormatter hCSTextFormatter) {
        super(fetchIcon, hCSTextFormatter);
        this.initToolBarAndContextMenu(fetchIcon);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JScrollPane jScrollPane = new JScrollPane((Component)this.getEditor(), 20, 30);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.editorUsageLabel = new JLabel(HCSArb.getString("SNIPPET_CODE_EDITOR_USAGE"));
        this.add((Component)this.editorUsageLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
    }

    public void setSpecJTree(SpecJTree specJTree) {
        this.tree = specJTree;
    }

    @Override
    protected void setupTextEditorDocument() {
        BasicEditorPane basicEditorPane = this.getEditor();
        basicEditorPane.setDocument((Document)new BasicDocument("foo.plsql"));
        basicEditorPane.setDropMode(DropMode.INSERT);
        basicEditorPane.setTransferHandler((TransferHandler)new SnippetDragAndDrop());
        this.undoer = new UndoManager();
        basicEditorPane.getDocument().addUndoableEditListener(this.undoer);
    }

    public void setText(String string) {
        this.insertionHandler.insertSyntax(new TemplateData(string));
    }

    public String getText() {
        return this.getEditor().getText();
    }

    @Override
    public boolean isSyntaxValid() {
        if (this.snippetValidator != null) {
            return this.snippetValidator.isValid(this.getText());
        }
        return true;
    }

    public void setSnippetValidator(SnippetValidator snippetValidator) {
        this.snippetValidator = snippetValidator;
    }

    public SnippetValidator getSnippetValidator() {
        return this.snippetValidator;
    }

    public void setEditorUsageText(String string) {
        this.editorUsageLabel.setText(string);
    }

    private void initToolBarAndContextMenu(FetchIcon fetchIcon) {
        this.insertionHandler = new InsertionHandlerEditorPlugin(){

            @Override
            public void insertSyntax(TemplateData templateData) {
                if (templateData != null) {
                    if (templateData.getMode().equals((Object)TemplateData.Mode.REPLACEALL)) {
                        SnippetCodeEditor.this.getEditor().setText(templateData.getSyntax());
                    } else {
                        this.adjustCaret(templateData.getOffset(), templateData.getLength(), null);
                        SnippetCodeEditor.this.getEditor().replaceSelection(templateData.getSyntax());
                    }
                }
            }
        };
        this.actions = new EditorActions(fetchIcon, this.insertionHandler, this.getEditor(), this.undoer);
        this.getEditor().getDocument().addUndoableEditListener(this.actions);
        this.setupToolbar();
        this.setupContextMenu();
    }

    public void clearEditorText() {
        this.actions.get(EditorActions.Type.CLEAR).actionPerformed(new ActionEvent(this, 1, ""));
    }

    private void setupToolbar() {
        this.toolBar = new Toolbar();
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.add((Component)new IconButton(this.actions.get(EditorActions.Type.UNDO)));
        this.toolBar.add((Component)new IconButton(this.actions.get(EditorActions.Type.REDO)));
        this.toolBar.addSeparator();
        this.toolBar.add((Component)new IconButton(this.actions.get(EditorActions.Type.CUT)));
        this.toolBar.add((Component)new IconButton(this.actions.get(EditorActions.Type.COPY)));
        this.toolBar.add((Component)new IconButton(this.actions.get(EditorActions.Type.PASTE)));
        this.toolBar.addSeparator();
        this.toolBar.add((Component)new IconButton(this.actions.get(EditorActions.Type.CLEAR)));
        this.toolBar.add((Component)new IconButton(this.actions.get(EditorActions.Type.FORMAT)));
    }

    private void setupContextMenu() {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.actions.get(EditorActions.Type.UNDO));
        jPopupMenu.add(this.actions.get(EditorActions.Type.REDO));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(EditorActions.Type.CUT));
        jPopupMenu.add(this.actions.get(EditorActions.Type.COPY));
        jPopupMenu.add(this.actions.get(EditorActions.Type.PASTE));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.actions.get(EditorActions.Type.CLEAR));
        jPopupMenu.add(this.actions.get(EditorActions.Type.FORMAT));
        this.getEditor().addPopupManager(new PopupManager(){

            public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }

            public void hidePopup(BasicEditorPane basicEditorPane) {
                jPopupMenu.setVisible(false);
            }
        });
    }

    private class SnippetDragAndDrop
    extends TransferHandler {
        private SnippetDragAndDrop() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return transferSupport.isDataFlavorSupported(SnippetCodeEditor.this.nodeFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDrop()) {
                return false;
            }
            SpecTreeNode specTreeNode = (SpecTreeNode)SnippetCodeEditor.this.tree.getSelectionModel().getSelectionPath().getLastPathComponent();
            if (specTreeNode != null && specTreeNode.getChildCount() == 0) {
                if (specTreeNode.getTemplateHelper() != null) {
                    try {
                        String string = specTreeNode.getTemplateHelper().getGUI(true).getSyntax();
                        SnippetCodeEditor.this.setText(string);
                    }
                    catch (Exception exception) {
                        SyntaxCodeEditor.LOG.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                } else {
                    SnippetCodeEditor.this.setText(specTreeNode.getTemplate());
                }
            }
            return true;
        }
    }
}

