/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.details;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.javatools.db.AbstractChildDBObject;

public class CalculatedMeasureTablePanel
extends JPanel {
    private List<? extends AbstractChildDBObject> objects;
    private ResultSetTable table;

    public CalculatedMeasureTablePanel(List<? extends AbstractChildDBObject> list, TableModel tableModel) {
        this.objects = list;
        this.init(tableModel);
    }

    private void init(TableModel tableModel) {
        this.table = new ResultSetTable();
        this.table.setModel(tableModel);
        this.populateTable();
        this.layoutComponents();
        this.setColumnsSize();
    }

    protected void setColumnsSize() {
    }

    protected void populateTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        if (this.objects != null && !this.objects.isEmpty()) {
            Object[] objectArray = null;
            for (AbstractChildDBObject abstractChildDBObject : this.objects) {
                AVBaseMeasure aVBaseMeasure = (AVBaseMeasure)abstractChildDBObject;
                objectArray = new Object[]{aVBaseMeasure.getAV().getName(), aVBaseMeasure.getName(), aVBaseMeasure.getDescription(), aVBaseMeasure.getCaption(), aVBaseMeasure.getDescription(), aVBaseMeasure.getExpression()};
                defaultTableModel.addRow(objectArray);
            }
        }
    }

    protected List<? extends AbstractChildDBObject> getObjects() {
        return this.objects;
    }

    protected ResultSetTable getTable() {
        return this.table;
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 1, 1));
    }

    private void clearTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(defaultTableModel.getRowCount() - 1);
        }
    }

    public void refresh(List<? extends AbstractChildDBObject> list) {
        this.objects = list;
        this.clearTable();
        this.populateTable();
    }
}

