/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax.parser;

import java.util.Iterator;
import java.util.List;
import oracle.hcs.syntax.ColumnExpression;
import oracle.hcs.syntax.DimensionArgument;
import oracle.hcs.syntax.FunctionDescriptorDimensionArgument;
import oracle.hcs.syntax.Query;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.UnresolvedMetadataObjectReference;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.metadata.MetadataXMLParserCallback;
import oracle.hcs.syntax.metadata.mdm.MdmDimension;
import oracle.hcs.syntax.metadata.mdm.MdmHierarchy;
import oracle.hcs.syntax.metadata.mdm.MdmMetadataProvider;
import oracle.hcs.syntax.metadata.mdm.MdmObject;
import oracle.hcs.syntax.metadata.mdm.MdmRootSchema;
import oracle.hcs.syntax.parser.Identifier;

public class IdentifierResolver {
    private String m_Owner = null;
    private List<Query> m_Queries = null;
    private MdmMetadataProvider m_MetadataProvider = null;
    private MdmRootSchema m_RootSchema = null;
    private MetadataXMLParserCallback m_XMLCallback = null;

    private String getOwner() {
        return this.m_Owner;
    }

    private List<Query> getQueries() {
        return this.m_Queries;
    }

    private MdmMetadataProvider getMetadataProvider() {
        return this.m_MetadataProvider;
    }

    private MdmRootSchema getRootSchema() {
        return this.m_RootSchema;
    }

    private MetadataXMLParserCallback getXMLCallback() {
        return this.m_XMLCallback;
    }

    private boolean fullyQualifyObjectID(Identifier identifier, int n, boolean bl, Class clazz) {
        return this.fullyQualifyObjectID(identifier, n, n, bl, clazz);
    }

    public boolean fullyQualifyObjectID(Identifier identifier, int n, int n2, boolean bl, Class clazz) {
        return true;
    }

    private MdmObject getMdmObject(Identifier identifier) {
        if (null == this.getMetadataProvider()) {
            return null;
        }
        return null;
    }

    public void error(Identifier identifier) {
        throw new SyntaxException("InvalidIdentifier", identifier.toString());
    }

    public Query getQuery(Identifier identifier) {
        return this.getQuery(identifier, true);
    }

    Query getQuery(Identifier identifier, boolean bl) {
        if (1 == identifier.getNumComponents() && null != this.getQueries()) {
            for (Query query : this.getQueries()) {
                if (!query.getName().equals(identifier)) continue;
                return query;
            }
        }
        Iterator<Query> iterator = null;
        return iterator;
    }

    private MdmObject getMdmObjectAndID(Identifier identifier, int n, Class clazz) {
        return null;
    }

    public MdmObject getMdmObjectAndID(Identifier identifier, int n, int n2, Class clazz) {
        boolean bl = this.fullyQualifyObjectID(identifier, n, n2, true, clazz);
        Object object = null;
        if (null == object) {
            return null;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        return null;
    }

    public UnresolvedMetadataObjectReference getUnresolvedMetadataObjectReference(Identifier identifier, Class clazz, int n) {
        return new UnresolvedMetadataObjectReference(identifier, this, n, clazz);
    }

    void resolveHierarchyList(List list, UnresolvedMetadataObjectReference unresolvedMetadataObjectReference) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Identifier identifier = (Identifier)list.get(i);
            Identifier identifier2 = null;
            identifier2.addComponent(identifier.toString());
            UnresolvedMetadataObjectReference unresolvedMetadataObjectReference2 = this.getUnresolvedMetadataObjectReference(identifier2, MdmHierarchy.class, 3);
            list.set(i, unresolvedMetadataObjectReference2);
        }
    }

    public TypedExpression getColumnExpression(Identifier identifier, boolean bl) {
        String string = identifier.getName();
        identifier.removeLastComponent();
        Query query = this.getQuery(identifier, false);
        identifier.addComponent(string);
        ColumnExpression columnExpression = null;
        if (null != query) {
            columnExpression = query.getColumnExpression(identifier.getName());
        }
        if (null == columnExpression && bl) {
            this.error(identifier);
        }
        return columnExpression;
    }

    public DimensionArgument getDimensionArgument(Identifier identifier, ValidationContext validationContext, int n, boolean bl) {
        int n2;
        int n3 = FunctionDescriptorDimensionArgument.getMinExpectedNumComponents(n);
        boolean bl2 = this.fullyQualifyObjectID(identifier, n3, n2 = FunctionDescriptorDimensionArgument.getMaxExpectedNumComponents(n), bl, MdmDimension.class);
        if (!bl2) {
            return null;
        }
        MdmObject mdmObject = this.getMdmObject(identifier);
        if (mdmObject instanceof MdmDimension) {
            MdmDimension mdmDimension = (MdmDimension)mdmObject;
            return new DimensionArgument(mdmDimension);
        }
        if (bl) {
            this.error(identifier);
        }
        return null;
    }

    public String getString(Identifier identifier) {
        int n = identifier.getNumComponents();
        if (1 == n) {
            return identifier.getComponent(0);
        }
        return identifier.toString();
    }

    public String getComponent(Identifier identifier, int n) {
        return identifier.getComponent(n);
    }

    public String getOracleID(String string) {
        if (null == string) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        if ('\"' == string.charAt(0)) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    public IdentifierResolver(String string, List list, MdmMetadataProvider mdmMetadataProvider, MetadataXMLParserCallback metadataXMLParserCallback) {
        this.m_Owner = this.getOracleID(string);
        this.m_Queries = list;
        this.m_MetadataProvider = mdmMetadataProvider;
        this.m_XMLCallback = metadataXMLParserCallback;
        if (null != mdmMetadataProvider && mdmMetadataProvider.getRootSchema() instanceof MdmRootSchema) {
            this.m_RootSchema = mdmMetadataProvider.getRootSchema();
        }
    }
}

