/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.BaseMetadataObjectReference;
import oracle.hcs.syntax.MetadataObjectReference;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.UnresolvedIdentifier;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.metadata.BaseMetadataObject;
import oracle.hcs.syntax.metadata.mdm.MdmObject;
import oracle.hcs.syntax.parser.Identifier;
import oracle.hcs.syntax.parser.IdentifierResolver;
import oracle.hcs.util.NameProvider;

public final class UnresolvedMetadataObjectReference
extends BaseMetadataObjectReference
implements UnresolvedIdentifier {
    private Identifier m_Identifier;
    private IdentifierResolver m_IDResolver;
    private int m_MinNumComps;
    private int m_MaxNumComps;

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return false;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitUnresolvedMetadataObjectReference(this, object);
    }

    final int getMinNumComps() {
        return this.m_MinNumComps;
    }

    final int getMaxNumComps() {
        return this.m_MaxNumComps;
    }

    boolean isValidReference() {
        return this.getIDResolver().fullyQualifyObjectID(new Identifier(this.getIdentifier()), this.getMinNumComps(), this.getMaxNumComps(), false, this.getObjectType());
    }

    @Override
    public final Identifier getIdentifier() {
        return this.m_Identifier;
    }

    @Override
    public final BaseMetadataObject getBaseMetadataObject() {
        throw new SyntaxException("InvalidIdentifier", this.getIdentifier().toString());
    }

    @Override
    public final IdentifierResolver getIDResolver() {
        return this.m_IDResolver;
    }

    public UnresolvedMetadataObjectReference(Identifier identifier, IdentifierResolver identifierResolver, int n, Class clazz) {
        this(identifier, identifierResolver, n, n, clazz);
    }

    public UnresolvedMetadataObjectReference(Identifier identifier, IdentifierResolver identifierResolver, int n, int n2, Class clazz) {
        super(clazz);
        this.m_IDResolver = identifierResolver;
        this.m_Identifier = identifier;
        this.m_MinNumComps = n;
        this.m_MaxNumComps = n2;
        this.initialize();
    }

    @Override
    public final String getName() {
        return this.getIdentifier().getName();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        NameProvider nameProvider = NameProvider.getInstance();
        String string = this.getIdentifier().toString();
        string = nameProvider.getExternalName(string);
        syntaxPrintingContext.appendIdentifier(string);
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        Class clazz = this.getObjectType();
        MdmObject mdmObject = this.getIDResolver().getMdmObjectAndID(this.getIdentifier(), this.getMinNumComps(), this.getMaxNumComps(), clazz);
        if (null != mdmObject) {
            return new MetadataObjectReference(mdmObject, clazz);
        }
        validationContext.addUnresolvedID(this);
        return this;
    }
}

