/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.BaseMetadataObjectReference;
import oracle.hcs.syntax.ColumnExpression;
import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.DimensionArgument;
import oracle.hcs.syntax.FunctionDescriptorDimensionArgument;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.UnresolvedMetadataObjectReference;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.metadata.mdm.MdmQueryColumn;
import oracle.hcs.syntax.parser.ExpParser;
import oracle.hcs.syntax.parser.Identifier;

public final class UnresolvedExpression
extends TypedExpression {
    private UnresolvedMetadataObjectReference m_ObjectReference = null;
    private ExpParser m_ExpParser = null;

    public UnresolvedExpression(ExpParser expParser, UnresolvedMetadataObjectReference unresolvedMetadataObjectReference) {
        this.m_ExpParser = expParser;
        this.m_ObjectReference = unresolvedMetadataObjectReference;
        this.setDataType(DataType.NULL_TYPE);
        this.initialize();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        this.m_ObjectReference.toSyntax(syntaxPrintingContext);
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        UnresolvedMetadataObjectReference unresolvedMetadataObjectReference = new UnresolvedMetadataObjectReference(new Identifier(this.m_ObjectReference.getIdentifier()), this.m_ObjectReference.getIDResolver(), 3, 3, MdmQueryColumn.class);
        BaseMetadataObjectReference baseMetadataObjectReference = (BaseMetadataObjectReference)validationContext.validate(unresolvedMetadataObjectReference);
        ColumnExpression columnExpression = null;
        columnExpression = new ColumnExpression(this.m_ExpParser, baseMetadataObjectReference);
        return validationContext.validate(columnExpression);
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return false;
    }

    DimensionArgument resolveToDimension(ValidationContext validationContext, int n) {
        UnresolvedMetadataObjectReference unresolvedMetadataObjectReference = new UnresolvedMetadataObjectReference(new Identifier(this.m_ObjectReference.getIdentifier()), this.m_ObjectReference.getIDResolver(), FunctionDescriptorDimensionArgument.getMinExpectedNumComponents(n), FunctionDescriptorDimensionArgument.getMaxExpectedNumComponents(n), this.m_ObjectReference.getObjectType());
        if (!unresolvedMetadataObjectReference.isValidReference()) {
            return null;
        }
        return new DimensionArgument(this.m_ExpParser, unresolvedMetadataObjectReference);
    }

    public ColumnExpression resolveToColumnExpression(ValidationContext validationContext) {
        Identifier identifier = this.m_ObjectReference.getIdentifier();
        UnresolvedMetadataObjectReference unresolvedMetadataObjectReference = new UnresolvedMetadataObjectReference(new Identifier(identifier), this.m_ObjectReference.getIDResolver(), 3, 3, MdmQueryColumn.class);
        if (!unresolvedMetadataObjectReference.isValidReference()) {
            return null;
        }
        return new ColumnExpression(this.m_ExpParser, unresolvedMetadataObjectReference);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitUnresolvedExpression(this, object);
    }
}

