/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.BaseMetadataObjectReference;
import oracle.hcs.syntax.ConsistentSolveCommand;
import oracle.hcs.syntax.MetadataObjectReference;
import oracle.hcs.syntax.SimpleCommand;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.UnresolvedMetadataObjectReference;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.metadata.mdm.MdmDimensionCalculationModel;
import oracle.hcs.syntax.parser.ExpParser;

public final class ModelCommand
extends SimpleCommand
implements ConsistentSolveCommand {
    public static final String DEFAULT_OPTION = "";
    public static final String SERIAL_OPTION = "SERIAL";
    public static final String PARALLEL_OPTION = "PARALLEL";
    static final String[] ALL_MODEL_OPTIONS = new String[]{"", "PARALLEL", "SERIAL"};
    private String m_Option = null;
    private BaseMetadataObjectReference m_Model = null;

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Model.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("MODEL ");
        this.m_Model.toSyntax(syntaxPrintingContext);
        if (DEFAULT_OPTION != this.getOption() && syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("1.3")) {
            syntaxPrintingContext.append(" ");
            syntaxPrintingContext.append(this.getOption());
        }
    }

    public ModelCommand(MdmDimensionCalculationModel mdmDimensionCalculationModel, String string) {
        ModelCommand.validateValue(mdmDimensionCalculationModel);
        this.m_Option = ModelCommand.validateEnum(string, ALL_MODEL_OPTIONS);
        this.m_Model = new MetadataObjectReference(mdmDimensionCalculationModel, MdmDimensionCalculationModel.class);
        this.initialize();
    }

    public ModelCommand(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this(mdmDimensionCalculationModel, DEFAULT_OPTION);
    }

    public ModelCommand(ExpParser expParser, UnresolvedMetadataObjectReference unresolvedMetadataObjectReference, String string) {
        ModelCommand.validateValue(unresolvedMetadataObjectReference);
        this.m_Option = ModelCommand.validateEnum(string, ALL_MODEL_OPTIONS);
        this.m_Model = unresolvedMetadataObjectReference;
        this.initialize();
    }

    public MdmDimensionCalculationModel getModel() {
        return (MdmDimensionCalculationModel)this.m_Model.getBaseMetadataObject();
    }

    public String getModelID() {
        return this.m_Model.getIdentifier().toString();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitModelCommand(this, object);
    }

    public String getOption() {
        return this.m_Option;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.m_Model = (BaseMetadataObjectReference)validationContext.validate(this.m_Model);
        return this;
    }
}

