/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.BaseMetadataObjectReference;
import oracle.hcs.syntax.DataObject;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.MetadataObjectReference;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.metadata.mdm.MdmDimension;
import oracle.hcs.syntax.parser.ExpParser;

public class DimensionArgument
extends DataObject
implements FunctionArgument {
    private BaseMetadataObjectReference m_Dimension;

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Dimension.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        this.m_Dimension.toSyntax(syntaxPrintingContext);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitDimensionArgument(this, object);
    }

    public DimensionArgument(MdmDimension mdmDimension) {
        DimensionArgument.validateValue(mdmDimension);
        this.m_Dimension = new MetadataObjectReference(mdmDimension, MdmDimension.class);
        this.initialize();
    }

    public DimensionArgument(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference) {
        DimensionArgument.validateValue(baseMetadataObjectReference);
        this.m_Dimension = baseMetadataObjectReference;
        this.initialize();
    }

    public MdmDimension getDimension() {
        return (MdmDimension)this.m_Dimension.getBaseMetadataObject();
    }

    public String getDimensionID() {
        return this.m_Dimension.getIdentifier().toString();
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.m_Dimension = (BaseMetadataObjectReference)validationContext.validate(this.m_Dimension);
        return this;
    }
}

