/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import oracle.dbtools.app.Format;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.quickav.QuickAVChecklistTaskDialog;
import oracle.hcs.quickav.QuickAVDataTableHelper;
import oracle.hcs.quickav.QuickAVDimensionGenerator;
import oracle.hcs.quickav.model.TableCol;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.javatools.db.Database;

public class QuickAVTableAnalyzer
extends SwingWorker<String, TableCol> {
    private final List<TableCol> columns;
    private final HCSSchema schema;
    private DatabaseSource source;
    private final QuickAVDataTableHelper dataTableHelper;
    private final Database db;
    private final Connection conn;
    private QuickAVChecklistTaskDialog dlg;
    private int completedTask;
    private QuickAVDimensionGenerator dimGenerator;
    private String factTable;
    private static Queries queries;
    private static final String TABLE_STATISTICS = "TABLE_STATISTICS";
    private static final String SOURCE_QUERIES = "sourcequeries.xml";
    private final String COLUMNS_QUERY_NAME = "GET_COLUMNS_BY_OBJECT";

    public QuickAVTableAnalyzer(JDialog jDialog, HCSSchema hCSSchema, Database database, Connection connection, DatabaseSource databaseSource, List<TableCol> list, QuickAVDataTableHelper quickAVDataTableHelper, String string, QuickAVDimensionGenerator quickAVDimensionGenerator) {
        this.db = database;
        this.conn = connection;
        this.schema = hCSSchema;
        this.source = databaseSource;
        this.columns = list;
        this.dataTableHelper = quickAVDataTableHelper;
        this.factTable = string;
        this.dimGenerator = quickAVDimensionGenerator;
        if (queries == null) {
            try {
                String string2 = "oracle.hcs.table";
                String string3 = "avdimensionqueries.xml";
                String string4 = JavaXMLBind.LoadDocument(this.getClass(), string3);
                JavaXMLBind.BindToJavaStr(string4, string2, this);
            }
            catch (Exception exception) {
                oracle.dbtools.util.Logger.log(QuickAVTableAnalyzer.class, (Level)Level.SEVERE, (String)exception.getMessage(), (Throwable)exception);
            }
        }
        this.beginAnalysis(jDialog);
    }

    private void beginAnalysis(JDialog jDialog) {
        this.dlg = new QuickAVChecklistTaskDialog(jDialog, this.factTable);
        this.dlg.start(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String doInBackground() throws Exception {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        ResultSet resultSet = null;
        HashMap hashMap = new HashMap();
        String string = this.db.getExternalName(this.source.getSchemaName());
        String string2 = this.db.getExternalName(this.source.getName());
        String string3 = String.format(queries.getSQL(TABLE_STATISTICS), string, string2);
        Connections.getInstance().lock(this.conn);
        resultSet = dBUtil.executeQuery(string3, hashMap);
        if (!resultSet.isBeforeFirst()) {
            int n = JOptionPane.showConfirmDialog(this.dlg.getParent(), HCSArb.format("QUICK_AV_NO_STATISTICS_MESSAGE", string2), HCSArb.getString("QUICK_AV_NO_STATISTICS_TITLE"), 0, 3);
            if (n == 0) {
                string3 = this.generateTableSummary(this.source);
                resultSet = dBUtil.executeQuery(string3, hashMap);
            } else {
                this.dlg.getParent().setVisible(false);
            }
        }
        while (resultSet.next()) {
            TableCol tableCol = new TableCol();
            tableCol.setIncludeColumn(true);
            tableCol.setFieldName(resultSet.getString(1));
            tableCol.setCardinality(resultSet.getInt(2));
            tableCol.setRatio(resultSet.getBigDecimal(3));
            tableCol.setTotalRows(resultSet.getInt(4));
            tableCol.setDataType(resultSet.getString(5));
            this.columns.add(tableCol);
        }
        this.completedTask = 1;
        this.publish(new TableCol[]{null});
        Thread.sleep(1000L);
        this.dataTableHelper.predictColumnsType(this.columns);
        this.completedTask = 2;
        this.publish(new TableCol[]{null});
        Thread.sleep(1000L);
        for (TableCol tableCol : this.columns) {
            this.publish(tableCol);
            Thread.sleep(1000L);
        }
        this.completedTask = 3;
        this.publish(new TableCol[]{null});
        Thread.sleep(1000L);
        this.completedTask = 4;
        this.publish(new TableCol[]{null});
        Thread.sleep(1000L);
        try {
            if (resultSet == null) return string3;
            DBUtil.closeResultSet((ResultSet)resultSet);
            return string3;
        }
        catch (Exception exception) {
            Logger.getLogger(QuickAVTableAnalyzer.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
            return string3;
        }
        finally {
            Connections.getInstance().unlock(this.conn);
        }
        catch (Exception exception) {
            try {
                Logger.getLogger(QuickAVTableAnalyzer.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet == null) throw throwable;
                    DBUtil.closeResultSet(resultSet);
                    throw throwable;
                }
                catch (Exception exception2) {
                    Logger.getLogger(QuickAVTableAnalyzer.class.getName()).log(Level.SEVERE, exception2.getMessage(), exception2);
                    throw throwable;
                }
                finally {
                    Connections.getInstance().unlock(this.conn);
                }
            }
            try {
                if (resultSet == null) return string3;
                DBUtil.closeResultSet((ResultSet)resultSet);
                return string3;
            }
            catch (Exception exception3) {
                Logger.getLogger(QuickAVTableAnalyzer.class.getName()).log(Level.SEVERE, exception3.getMessage(), exception3);
                return string3;
            }
            finally {
                Connections.getInstance().unlock(this.conn);
            }
        }
    }

    private String generateTableSummary(DatabaseSource databaseSource) throws Exception {
        String string;
        Map<Object, Object> map = new HashMap();
        SourceMetadata sourceMetadata = new SourceMetadata(SOURCE_QUERIES, this.conn);
        map = sourceMetadata.getSourceInformation(databaseSource);
        String string2 = this.externalizeFactTableName(databaseSource);
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        Connections.getInstance().lock(this.conn);
        String string3 = sourceMetadata.getQueries().getSQL("GET_COLUMNS_BY_OBJECT");
        ResultSet resultSet = dBUtil.executeQuery(string3, map);
        StringBuilder stringBuilder = new StringBuilder();
        if (resultSet != null) {
            while (resultSet.next()) {
                string = resultSet.getString(1);
                String string4 = this.db.getExternalName(resultSet.getString(1));
                String string5 = resultSet.getString(3);
                String string6 = String.format(" select '%1$s' as field,count(s) cardinality, (case when sum(aggrows) > 0 then round(count(s)/sum(aggrows),5) else 0 end) ratio, sum(aggrows) total_rows, '%4$s'as column_data_type from (select %2$s s, count(%2$s) aggrows,count(%2$s)/(select count(*) from %3$s) field_ratio  from %3$s group by %2$s)  ratio_table", string, string4, string2, string5);
                stringBuilder.append(string6);
                stringBuilder.append(" union");
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
        }
        Connections.getInstance().unlock(this.conn);
        stringBuilder.delete(stringBuilder.lastIndexOf("union"), stringBuilder.length());
        stringBuilder.append(" order by ratio");
        string = stringBuilder.toString();
        try {
            string = new Format().format(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String externalizeFactTableName(DatabaseSource databaseSource) {
        String string = databaseSource.getSchemaName();
        String string2 = databaseSource.getName();
        if (string.equals(this.schema.getName())) {
            return this.db.getExternalName(string2);
        }
        return String.format("\"%s\".\"%s\"", string, string2);
    }

    @Override
    protected void done() {
        this.dlg.enableOKBtn();
    }

    @Override
    protected void process(List<TableCol> list) {
        if (list != null) {
            for (TableCol tableCol : list) {
                if (tableCol != null) {
                    if (tableCol.getFieldType().equalsIgnoreCase(HCSArb.getString("QUICK_AV_DIALOG_DIMENSION"))) {
                        AttributeDimension attributeDimension = this.dimGenerator.createNewDimension(tableCol.getFieldName(), tableCol.getDataType());
                        this.dlg.addDimOrMeasureFound(3, HCSArb.format("QUICK_AV_DIMENSION_FOUND", attributeDimension.getName()));
                        continue;
                    }
                    if (!tableCol.getFieldType().equalsIgnoreCase(HCSArb.getString("QUICK_AV_DIALOG_MEASURE"))) continue;
                    this.dlg.addDimOrMeasureFound(4, HCSArb.format("QUICK_AV_MEASURE_FOUND", tableCol.getFieldName()));
                    continue;
                }
                this.dlg.addCompletionStatus(this.completedTask);
            }
        }
    }

    public void addQueries(Queries queries) {
        QuickAVTableAnalyzer.queries = queries;
    }
}

