/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.hcs.HCSArb;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.panels.BaseChildTableEditorPanel;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.panels.AttrMapExpressionCellRenderer;
import oracle.hcs.dimension.panels.CompletionAttributeMatchProvider;
import oracle.hcs.dimension.panels.DimensionLevelObjectEditorPanel;
import oracle.hcs.util.CompletionCellEditor;
import oracle.hcs.util.CompletionProviderWithFilter;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.table.GenericTable;

public class DimensionLevelTableEditorPanel<C extends DimensionLevel, P extends AttributeDimension>
extends BaseChildTableEditorPanel<C, P> {
    private int LEVEL_NAME_COLUMN = 0;
    private int MAP_EXPRESSION_COLUMN = 1;
    private int LEVEL_TYPE_COLUMN = 2;
    private int CAPTION_COLUMN = 2;
    private int DESCRIPTION_COLUMN = 3;
    private CompletionAttributeMatchProvider attributeCompletionProvider;
    private List<DimensionAttribute> attributes;
    private MyCellEditor myCellEditor;
    private Map<Object, Boolean> levels = new HashMap<Object, Boolean>();
    private DimensionLevelObjectEditorPanel childPanel;
    String[] TIME_LEVEL_TYPES = new String[]{"SECONDS", "MINUTES", "HOURS", "DAYS", "WEEKS", "MONTHS", "QUARTERS", "HALF_YEARS", "YEARS"};
    private boolean initialized;

    public DimensionLevelTableEditorPanel() {
        super("DimensionLevelTablePanel");
        this.init();
        this.getWrapperTable().setPreferredVisibleRowCount(15);
    }

    public DimensionLevelTableEditorPanel(String string) {
        super(string);
        this.init();
        this.getWrapperTable().setPreferredVisibleRowCount(15);
    }

    protected boolean useSplitter() {
        return true;
    }

    protected JComponent createSplitPane(Component component, Component component2) {
        JSplitPane jSplitPane = new JSplitPane(this.isHorizontalSplit() ? 1 : 0, component, component2);
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerLocation(165);
        return jSplitPane;
    }

    @Override
    public void init() {
        PropertyDisplayRegistry propertyDisplayRegistry = PropertyDisplayRegistry.getInstance();
        propertyDisplayRegistry.registerDisplayName("levels", HCSArb.getString("DIMENSION_LEVELS"));
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        List<DimensionAttribute> list = Arrays.asList(((AttributeDimension)this.getUpdatedObject()).getAttributes());
        if (!this.attributes.containsAll(list)) {
            this.attributes = Arrays.asList(((AttributeDimension)this.getUpdatedObject()).getAttributes());
            for (DimensionAttribute dimensionAttribute : this.attributes) {
                String string = this.prov.getExternalName(dimensionAttribute.getName());
                dimensionAttribute.setExternalName(string);
            }
            this.attributeCompletionProvider.setStrings(this.attributes);
        }
        if (!this.initialized) {
            this.initialized = true;
            ((AttributeDimension)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    Map map = dBObjectChange.getPropertiesChanged();
                    for (String string : map.keySet()) {
                        if (!string.equals("dimensionType") || DimensionLevelTableEditorPanel.this.getWrapperTableModel() == null) continue;
                        DimensionLevelTableEditorPanel.this.resetTable();
                    }
                }
            });
        }
        for (DimensionLevel dimensionLevel : ((AttributeDimension)this.getUpdatedObject()).getLevels()) {
            this.levels.put(dimensionLevel, new Boolean(true));
        }
    }

    private void resetTable() {
        GenericTable genericTable = this.getWrapperTable();
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        for (int i = tableColumnModel.getColumnCount() - 1; i >= 0; --i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumnModel.removeColumn(tableColumn);
        }
        this.initialiseTableComponents();
        this.setupColumns();
        if (genericTable.getRowCount() > 0) {
            genericTable.setSelectedRowInModel(0);
        }
    }

    @Override
    protected void initialiseComponents() {
        this.initImpl(this.getProvider());
        super.initialiseComponents();
        this.setupColumns();
    }

    private void setupColumns() {
        Object object;
        DimensionAttribute dimensionAttribute2;
        GenericTable genericTable = this.getWrapperTable();
        this.myCellEditor = new MyCellEditor();
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this.LEVEL_NAME_COLUMN);
        tableColumn.setCellEditor(this.myCellEditor);
        TableColumn tableColumn2 = tableColumnModel.getColumn(this.DESCRIPTION_COLUMN);
        tableColumn2.setCellEditor(this.myCellEditor);
        TableColumn tableColumn3 = tableColumnModel.getColumn(this.CAPTION_COLUMN);
        tableColumn3.setCellEditor(this.myCellEditor);
        this.attributes = Arrays.asList(((AttributeDimension)this.getUpdatedObject()).getAttributes());
        for (DimensionAttribute dimensionAttribute2 : this.attributes) {
            object = this.prov.getExternalName(dimensionAttribute2.getName());
            dimensionAttribute2.setExternalName((String)object);
        }
        TableColumn tableColumn4 = tableColumnModel.getColumn(this.MAP_EXPRESSION_COLUMN);
        dimensionAttribute2 = new CompletionTextField();
        this.attributeCompletionProvider = new CompletionAttributeMatchProvider(dimensionAttribute2.getPopupHandler().getInsightList(), this.attributes);
        dimensionAttribute2.getPopupHandler().registerInsightProvider((CompletionProvider)this.attributeCompletionProvider);
        tableColumn4.setCellRenderer(new AttrMapExpressionCellRenderer());
        tableColumn4.setCellEditor(new MyCompletionCellEditor((CompletionTextField)dimensionAttribute2, this.attributeCompletionProvider, this.getWrapperTableModel()));
        if (((AttributeDimension)this.getUpdatedObject()).isTime()) {
            object = tableColumnModel.getColumn(this.LEVEL_TYPE_COLUMN);
            ((TableColumn)object).setCellEditor(new MyComboBoxEditor(this.TIME_LEVEL_TYPES));
        }
    }

    @Override
    protected void initialiseTableComponents() {
        if (((AttributeDimension)this.getUpdatedObject()).isTime()) {
            this.CAPTION_COLUMN = 3;
            this.DESCRIPTION_COLUMN = 4;
        } else {
            this.CAPTION_COLUMN = 2;
            this.DESCRIPTION_COLUMN = 3;
        }
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionLevelTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return DimensionLevelTableEditorPanel.this.prov.getExternalName(c.getName());
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic2 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionLevelTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getDescription();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic3 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionLevelTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getCaption();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        this.addColumn(0, HCSArb.get("NAMESPACE_CONFLICT_PANEL_NAME_LABEL"), String.class, nonPropertyColumnLogic);
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic4 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionLevelTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                String string = ((DimensionLevel)c).getLevelKey();
                if (string == null || string.isEmpty()) {
                    return string;
                }
                String[] stringArray = string.split(",");
                if (stringArray.length == 1) {
                    return DimensionLevelTableEditorPanel.this.prov.getExternalName(string);
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(DimensionLevelTableEditorPanel.this.prov.getExternalName(stringArray[i]));
                    if (i >= stringArray.length - 1) continue;
                    stringBuffer.append(",");
                }
                return stringBuffer.toString();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic5 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionLevelTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return DimensionLevelTableEditorPanel.this.prov.getExternalName(((DimensionLevel)c).getLevelType());
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        this.addColumn(this.MAP_EXPRESSION_COLUMN, HCSArb.get("HIERARCHY_DIMENSION_LEVELS_PANEL_MAPPING_EXPRESSION"), String.class, nonPropertyColumnLogic4);
        if (((AttributeDimension)this.getUpdatedObject()).isTime()) {
            this.addColumn(this.LEVEL_TYPE_COLUMN, HCSArb.get("HIERARCHY_DIMENSION_LEVELS_PANEL_LEVEL_TYPE"), String.class, nonPropertyColumnLogic5);
        }
        this.addColumn(this.CAPTION_COLUMN, HCSArb.get("DESCRIPTION_PANEL_SHORT_LABEL"), String.class, nonPropertyColumnLogic3);
        this.addColumn(this.DESCRIPTION_COLUMN, HCSArb.get("DESCRIPTION_PANEL_DESCRIPTION"), String.class, nonPropertyColumnLogic2);
        final GenericTable genericTable = this.getWrapperTable();
        genericTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                genericTable.scrollRectToVisible(genericTable.getCellRect(genericTable.getSelectedRow(), 0, true));
            }
        });
    }

    @Override
    protected void setRowPropertyValue(Object object, int n, int n2) {
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
        DimensionLevel dimensionLevel = (DimensionLevel)rowInfo.getRowObject();
        if (((AttributeDimension)this.getUpdatedObject()).isTime()) {
            this.setPropertyValueTime(object, n, n2, dimensionLevel);
        } else {
            this.setPropertyValueStandard(object, n, n2, dimensionLevel);
        }
    }

    private void setPropertyValueStandard(Object object, int n, int n2, DimensionLevel dimensionLevel) {
        switch (n2) {
            case 0: {
                String string = (String)object;
                dimensionLevel.setName(this.prov.getInternalName(string));
                if (!this.upcaseNameFlag) break;
                this.updateNameToUppercase(string.toUpperCase(), n, 0);
                this.upcaseNameFlag = false;
                break;
            }
            case 2: {
                String string = (String)object;
                dimensionLevel.setCaption(string);
                break;
            }
            case 3: {
                String string = (String)object;
                dimensionLevel.setDescription(string);
                break;
            }
            case 1: {
                String string = (String)object;
                boolean bl = false;
                if (dimensionLevel.getLevelKey() == null) {
                    bl = true;
                }
                List<String> list = UIStringUtils.getExternalNames(string);
                String[] stringArray = new String[list.size()];
                int n3 = 0;
                for (String string2 : list) {
                    String string3;
                    stringArray[n3] = string3 = this.prov.getInternalName(string2);
                    ++n3;
                }
                dimensionLevel.setLevelKeys(stringArray);
                if (!bl) break;
                this.childPanel.loadLevelData();
            }
        }
    }

    private void setPropertyValueTime(Object object, int n, int n2, DimensionLevel dimensionLevel) {
        switch (n2) {
            case 0: {
                String string = (String)object;
                dimensionLevel.setName(this.prov.getInternalName(string));
                if (!this.upcaseNameFlag) break;
                this.updateNameToUppercase(string.toUpperCase(), n, 0);
                this.upcaseNameFlag = false;
                break;
            }
            case 3: {
                String string = (String)object;
                dimensionLevel.setCaption(string);
                break;
            }
            case 4: {
                String string = (String)object;
                dimensionLevel.setDescription(string);
                break;
            }
            case 1: {
                String string = (String)object;
                boolean bl = false;
                if (dimensionLevel.getLevelKey() == null) {
                    bl = true;
                }
                List<String> list = UIStringUtils.getExternalNames(string);
                String[] stringArray = new String[list.size()];
                int n3 = 0;
                for (String string2 : list) {
                    String string3;
                    stringArray[n3] = string3 = this.prov.getInternalName(string2);
                    ++n3;
                }
                dimensionLevel.setLevelKeys(stringArray);
                if (!bl) break;
                this.childPanel.loadLevelData();
                break;
            }
            case 2: {
                String string = (String)object;
                dimensionLevel.setLevelType(string);
            }
        }
    }

    @Override
    protected int getNameColumnIndex() {
        return this.LEVEL_NAME_COLUMN;
    }

    @Override
    protected int getCaptionColumnIndex() {
        return this.CAPTION_COLUMN;
    }

    @Override
    protected int getDescriptionColumnIndex() {
        return this.DESCRIPTION_COLUMN;
    }

    @Override
    protected boolean preserveListOrder() {
        return true;
    }

    public String getChildProperty() {
        return "levels";
    }

    public Class getChildClass() {
        return DimensionLevel.class;
    }

    protected ChildObjectEditorPanel createChildPanel() {
        this.childPanel = new DimensionLevelObjectEditorPanel();
        return this.childPanel;
    }

    @Override
    public C newChild() {
        DimensionLevel dimensionLevel = (DimensionLevel)super.newChild();
        dimensionLevel.setNewObject();
        dimensionLevel.setDataType("VARCHAR2(60)");
        dimensionLevel.setOriginalLevelName(dimensionLevel.getName());
        dimensionLevel.generateDescriptions();
        dimensionLevel.setLevelSkipNullValues(false);
        ((AttributeDimension)this.getUpdatedObject()).addLevel(dimensionLevel);
        return (C)dimensionLevel;
    }

    protected boolean confirmRowCanBeDeleted(int n) {
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
        DimensionLevel dimensionLevel = (DimensionLevel)rowInfo.getRowObject();
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        attributeDimension.removeLevel(dimensionLevel);
        DimensionLevel[] dimensionLevelArray = attributeDimension.getLevels();
        attributeDimension.setLevels(dimensionLevelArray);
        return true;
    }

    class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor(String[] stringArray) {
            super(new JComboBox<String>(stringArray));
            this.setClickCountToStart(2);
        }
    }

    class MyCompletionCellEditor
    extends CompletionCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            super.setCompletionPopupHandlerStatus((String)object);
            return component;
        }

        public MyCompletionCellEditor(CompletionTextField completionTextField, CompletionProviderWithFilter completionProviderWithFilter, ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel) {
            super(completionTextField, completionProviderWithFilter, componentWrapperTableModel);
        }

        @Override
        public void markAsDirty() {
            DimensionLevelTableEditorPanel.this.levels.put(this.abstractChildObjectWithDesc, new Boolean(true));
        }
    }

    class MyCellEditor
    extends BaseChildTableEditorPanel.MyBaseCellEditor {
        public MyCellEditor() {
            this.cellTextField.getDocument().addDocumentListener(new DocumentListener(){

                private void setSelection() {
                    String string;
                    if (MyCellEditor.this.column != DimensionLevelTableEditorPanel.this.getNameColumnIndex() || this.isLevelDirty()) {
                        return;
                    }
                    String string2 = (String)DimensionLevelTableEditorPanel.this.getWrapperTableModel().getValueAt(MyCellEditor.this.row, 0);
                    if (!string2.equals(string = MyCellEditor.this.cellTextField.getText()) && string.length() > 2) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (DimensionAttribute object : DimensionLevelTableEditorPanel.this.attributes) {
                            if (!object.getExternalName().toUpperCase().startsWith(string.toUpperCase())) continue;
                            arrayList.add(object.getExternalName());
                        }
                        Object object = null;
                        if (arrayList.size() > 0) {
                            for (String string3 : arrayList) {
                                if (!string3.toUpperCase().endsWith("_ID") || object != null && string3.length() >= ((String)object).length()) continue;
                                object = string3;
                            }
                            if (object == null) {
                                object = (String)arrayList.get(0);
                            }
                        }
                        if (object != null) {
                            DimensionLevelTableEditorPanel.this.getWrapperTableModel().setValueAt(object, MyCellEditor.this.row, DimensionLevelTableEditorPanel.this.MAP_EXPRESSION_COLUMN);
                        }
                    }
                }

                private boolean isLevelDirty() {
                    Boolean bl = DimensionLevelTableEditorPanel.this.levels.get(MyCellEditor.this.abstractChildObjectWithDesc);
                    if (bl != null) {
                        return bl;
                    }
                    return false;
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.setSelection();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            });
        }

        @Override
        public boolean stopCellEditing() {
            TableColumnModel tableColumnModel = this.jtable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(this.column);
            int n = tableColumn.getModelIndex();
            if (n == DimensionLevelTableEditorPanel.this.LEVEL_NAME_COLUMN) {
                boolean bl = true;
                boolean bl2 = false;
                String string = null;
                AttributeDimension attributeDimension = (AttributeDimension)this.abstractChildObjectWithDesc.getParent();
                String string2 = this.abstractChildObjectWithDesc.getName();
                String string3 = DimensionLevelTableEditorPanel.this.prov.getExternalName(string2);
                String string4 = UIStringUtils.normalizeName(this.cellTextField.getText(), DimensionLevelTableEditorPanel.this.prov);
                String string5 = DimensionLevelTableEditorPanel.this.prov.getInternalName(string4);
                bl2 = UIStringUtils.isQuotedName(string4);
                if (string4 == null || string4.length() == 0) {
                    bl = false;
                    string = HCSArb.getString("DIMENSION_LEVEL_NAME_VALIDATION_ERROR_MSG");
                } else {
                    try {
                        DimensionLevelTableEditorPanel.this.prov.validateName("DIMENSION LEVEL", string4);
                    }
                    catch (InvalidNameException invalidNameException) {
                        string = invalidNameException.getMessage();
                        bl = false;
                    }
                }
                if (bl) {
                    String string6 = string4;
                    if (!DimensionLevelTableEditorPanel.this.isEditing()) {
                        ((DimensionLevel)this.abstractChildObjectWithDesc).setOriginalLevelName(string5);
                    } else if (this.abstractChildObjectWithDesc.isNewObject()) {
                        ((DimensionLevel)this.abstractChildObjectWithDesc).setOriginalLevelName(string5);
                    }
                    if (attributeDimension.findLevel(string5) != null && !string5.equals(string2)) {
                        string = HCSArb.format("VALIDATION_ERROR_DUPLICATE_LEVEL_NAME_MSG", string6);
                        bl = false;
                    }
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)HCSArb.get("DIMENSION_LEVEL_NAME_VALIDATION_ERROR_MSG"), null);
                    this.cellTextField.setText(string3);
                    return bl;
                }
                if (!bl2) {
                    DimensionLevelTableEditorPanel.this.upcaseNameFlag = true;
                }
            }
            return super.stopCellEditing();
        }
    }
}

