/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.JoinPath;
import oracle.hcs.dimension.panels.JoinTablePanel;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;

public class DimensionJoinPathsEditorPanel
extends BaseEditorPanel<AttributeDimension> {
    private GenericTable sourceTable;
    private JoinTablePanel joinTablePanel;
    private DefaultTableModel tableModel;
    private List<DatabaseSource> sources;
    private DBObjectProvider provider;
    private static final int SCHEMA_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int ALIAS_COLUMN = 2;
    private static final String CLOB_TYPE = "CLOB";
    private static final String BLOB_TYPE = "BLOB";
    private static final String NCLOB_TYPE = "NCLOB";
    private static final String BFILE_TYPE = "BFILE";
    private static final String LONG_TYPE = "LONG";
    private static final String LONG_RAW_TYPE = "LONG RAW";

    public DimensionJoinPathsEditorPanel() {
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 2;
            }
        };
        this.tableModel.addColumn(HCSArb.get("DIMENSION_ATTRIBUTE_JOIN_SCHEMA"));
        this.tableModel.addColumn(HCSArb.get("DIMENSION_ATTRIBUTE_JOIN_NAME"));
        this.tableModel.addColumn(HCSArb.get("DIMENSION_ATTRIBUTE_JOIN_ALIAS"));
        this.sourceTable = new GenericTable((TableModel)this.tableModel);
        this.sourceTable.setColumnSelectorAvailable(false);
        this.setLayout(new GridBagLayout());
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(HCSArb.getString("DIMENSION_ATTRIBUTE_SOURCES_TABLE_TITLE")));
        JScrollPane jScrollPane = new JScrollPane((Component)this.sourceTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.joinTablePanel = new JoinTablePanel();
        this.add(this.joinTablePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    private void loadSourcesIntoTable() {
        this.tableModel.setRowCount(0);
        for (DatabaseSource databaseSource : this.sources) {
            Object[] objectArray = new Object[]{this.provider.getExternalName(databaseSource.getSchemaName()), this.provider.getExternalName(databaseSource.getName()), this.provider.getExternalName(databaseSource.getAlias())};
            this.tableModel.addRow(objectArray);
        }
    }

    protected void initialisePanel() {
        this.provider = this.getProvider();
        this.joinTablePanel.setProvider(this.provider);
        this.sources = Arrays.asList(((AttributeDimension)this.getUpdatedObject()).getSources());
        this.loadSourcesIntoTable();
        this.initJointTable();
        this.sourceTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.sourceTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() == 2) {
                    int n = tableModelEvent.getLastRow();
                    String string = UIStringUtils.normalizeName((String)DimensionJoinPathsEditorPanel.this.tableModel.getValueAt(n, 2), DimensionJoinPathsEditorPanel.this.provider);
                    DimensionJoinPathsEditorPanel.this.updateNameToUppercase(string, n, 2);
                    String string2 = DimensionJoinPathsEditorPanel.this.provider.getInternalName((String)DimensionJoinPathsEditorPanel.this.tableModel.getValueAt(tableModelEvent.getLastRow(), 2));
                    String string3 = DimensionJoinPathsEditorPanel.this.sources.get(n).getAlias();
                    if (string3 == null || !string3.equals(string2)) {
                        if (string2 != null && string2.isEmpty()) {
                            string2 = null;
                        }
                        DimensionJoinPathsEditorPanel.this.updateAttributes(string3, string2);
                        DimensionJoinPathsEditorPanel.this.sources.get(n).setAlias(string2);
                        DimensionJoinPathsEditorPanel.this.updateColumnSelection();
                        if (DimensionJoinPathsEditorPanel.this.sources != null && DimensionJoinPathsEditorPanel.this.sources.size() > 1) {
                            DimensionJoinPathsEditorPanel.this.joinTablePanel.setSourceColumns(DimensionJoinPathsEditorPanel.this.getSourceColumns(DimensionJoinPathsEditorPanel.this.sources));
                            if (string3 != null) {
                                DimensionJoinPathsEditorPanel.this.joinTablePanel.setJoinPaths(((AttributeDimension)DimensionJoinPathsEditorPanel.this.getUpdatedObject()).getJoinPaths(), false);
                            }
                        }
                    }
                }
            }
        });
    }

    protected void initJointTable() {
        if (this.sources != null && this.sources.size() > 1) {
            this.joinTablePanel.setVisible(true);
            this.joinTablePanel.setMinJoinConditions(this.sources.size() - 1);
            this.joinTablePanel.setSourceColumns(((AttributeDimension)this.getUpdatedObject()).getSourceColumns());
            if (this.isEditing()) {
                this.joinTablePanel.setJoinPaths(((AttributeDimension)this.getUpdatedObject()).getJoinPaths(), true);
            } else {
                this.joinTablePanel.defaultJoinConditions();
            }
        } else {
            this.joinTablePanel.setVisible(false);
        }
    }

    private void updateAttributes(String string, String string2) {
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        for (DimensionAttribute dimensionAttribute : attributeDimension.getAttributes()) {
            if (dimensionAttribute.getAlias() != null && !dimensionAttribute.getAlias().equals(string)) continue;
            dimensionAttribute.setAlias(string2);
        }
    }

    private void updateColumnSelection() {
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        List<ColumnIdentifier> list = this.getSourceColumns(this.sources);
        attributeDimension.setSourceColumns(list);
        this.joinTablePanel.setSourceColumns(list);
    }

    protected boolean isColumnValidDataType(String string) {
        return !string.equalsIgnoreCase(CLOB_TYPE) && !string.equalsIgnoreCase(BLOB_TYPE) && !string.equalsIgnoreCase(NCLOB_TYPE) && !string.equalsIgnoreCase(BFILE_TYPE) && !string.equalsIgnoreCase(LONG_TYPE) && !string.equalsIgnoreCase(LONG_RAW_TYPE);
    }

    public List<ColumnIdentifier> getSourceColumns(List<DatabaseSource> list) {
        String string = ((AttributeDimension)this.getUpdatedObject()).getSchema().getName();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        if (list != null) {
            for (DatabaseSource databaseSource : list) {
                for (Column column : databaseSource.getColumns()) {
                    if (!this.isColumnValidDataType(column.getDataType().trim())) continue;
                    String string2 = this.getProvider().getExternalName(databaseSource.getSchemaName());
                    String string3 = this.getProvider().getExternalName(databaseSource.getName());
                    String string4 = this.getProvider().getExternalName(databaseSource.getAlias());
                    String string5 = this.getProvider().getExternalName(column.getName());
                    if (string2.equals(string)) {
                        string2 = null;
                    }
                    if (list.size() == 1) {
                        string3 = null;
                    }
                    if (string3 != null && string4 != null) {
                        string3 = null;
                    }
                    if (list.size() > 1 && string4 == null) {
                        string3 = null;
                    }
                    arrayList.add(new ColumnIdentifier(string2, string3, string4, string5, column));
                }
            }
        }
        return arrayList;
    }

    protected boolean shouldValidateOnExit() {
        return true;
    }

    protected void validateObject() throws TraversalException {
        Object object;
        for (DatabaseSource databaseSource : ((AttributeDimension)this.getUpdatedObject()).getSources()) {
            object = new HashSet();
            for (DatabaseSource databaseSource2 : ((AttributeDimension)this.getUpdatedObject()).getSources()) {
                if (databaseSource2.getQualifiedName().equals(databaseSource.getQualifiedName())) continue;
                for (Column column : databaseSource2.getColumns()) {
                    ((HashSet)object).add(column.getName());
                }
            }
            for (Column column : databaseSource.getColumns()) {
                if (!((HashSet)object).contains(column.getName())) continue;
                throw new TraversalException(HCSArb.format("VALIDATION_ERROR_DIMENSION_INVALID_SOURCE_TABLE", databaseSource.getName()));
            }
        }
        for (JoinPath joinPath : ((AttributeDimension)this.getUpdatedObject()).getJoinPaths()) {
            String[] stringArray;
            object = joinPath.getName();
            if (((String)object).trim().isEmpty()) {
                throw new TraversalException((Object)this.getUpdatedObject(), HCSArb.getString("VALIDATION_ERROR_JOIN_NAME"));
            }
            String string = joinPath.getCondition();
            if (!string.contains("=")) {
                throw new TraversalException((Object)this.getUpdatedObject(), HCSArb.getString("VALIDATION_ERROR_JOIN_CONDITION"));
            }
            for (String string2 : stringArray = string.split("=")) {
                if (!string2.trim().isEmpty()) continue;
                throw new TraversalException((Object)this.getUpdatedObject(), HCSArb.getString("VALIDATION_ERROR_JOIN_CONDITION"));
            }
        }
    }

    protected void commitPanel() throws TraversalException {
        JoinPath[] joinPathArray;
        super.commitPanel();
        if (this.sourceTable.getCellEditor() != null) {
            this.sourceTable.getCellEditor().stopCellEditing();
        }
        if (this.joinTablePanel.getTable().getCellEditor() != null) {
            this.joinTablePanel.getTable().getCellEditor().stopCellEditing();
        }
        ((AttributeDimension)this.getUpdatedObject()).setSources(this.sources.toArray(new DatabaseSource[this.sources.size()]));
        if (this.joinTablePanel.isVisible() && (joinPathArray = this.joinTablePanel.getJoinPaths()).length > 0) {
            ((AttributeDimension)this.getUpdatedObject()).setJoinPaths(joinPathArray);
        }
        this.updateColumnSelection();
    }

    protected void updateNameToUppercase(String string, int n, int n2) {
        final String string2 = string;
        final int n3 = n;
        final int n4 = n2;
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    String string = (String)DimensionJoinPathsEditorPanel.this.sourceTable.getModel().getValueAt(n3, n4);
                    String string22 = (String)string2;
                    if (string22 != null && string22.equalsIgnoreCase(string) && !string22.equals(string)) {
                        DimensionJoinPathsEditorPanel.this.sourceTable.getModel().setValueAt(string2, n3, n4);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(thread);
    }
}

