/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.source;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.util.Logger;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;

public class SourceMetadata {
    private DBUtil dbUtil;
    private Queries queries;
    private final String GET_SCHEMAS = "GET_SCHEMAS";
    private final String GET_COLUMNS = "GET_COLUMNS_BY_OBJECT";
    private final String SYNONYM_TYPE = "SYNONYM";
    private final String SYNONYM_TABLE_QUERY_NAME = "GET_TABLE_FROM_SYNONYM";

    public SourceMetadata() {
        this("sourcequeries.xml");
    }

    public SourceMetadata(String string) {
        try {
            String string2 = "oracle.hcs.table";
            String string3 = JavaXMLBind.LoadDocument(this.getClass(), string);
            JavaXMLBind.BindToJavaStr(string3, string2, this);
        }
        catch (Exception exception) {
            Logger.warn(SourceMetadata.class, (Throwable)exception);
        }
    }

    public SourceMetadata(String string, Connection connection) {
        try {
            String string2 = "oracle.hcs.table";
            String string3 = JavaXMLBind.LoadDocument(this.getClass(), string);
            JavaXMLBind.BindToJavaStr(string3, string2, this);
        }
        catch (Exception exception) {
            Logger.warn(SourceMetadata.class, (Throwable)exception);
        }
        this.dbUtil = DBUtil.getInstance((Connection)connection);
    }

    public Queries getQueries() {
        return this.queries;
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    public List<String> getSchemas() throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.queries.getSQL("GET_SCHEMAS");
        List list = this.dbUtil.executeReturnList(string, null);
        for (Map map : list) {
            arrayList.add(map.get("OWNER").toString());
        }
        return arrayList;
    }

    public List<List<String>> executeQueryByName(String string, Map<String, String> map) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        String string2 = this.queries.getSQL(string);
        List list = this.dbUtil.executeReturnList(string2, map);
        for (Map map2 : list) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string3 : map2.values()) {
                arrayList2.add(string3);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public List<Column> getObjectColumns(String string, String string2) throws SQLException {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        hashMap.put("OBJECT", string2);
        String string3 = this.queries.getSQL("GET_COLUMNS_BY_OBJECT");
        List list = this.dbUtil.executeReturnList(string3, hashMap);
        for (Map map : list) {
            String string4 = map.get("COLUMN_NAME").toString();
            String string5 = map.get("NULLABLE").toString();
            Object object = "";
            object = (String)object + map.get("DATA_TYPE");
            if (map.get("TYPE") != null) {
                object = (String)object + map.get("TYPE");
            }
            arrayList.add(new Column(string4, string5, (String)object));
        }
        return arrayList;
    }

    public Map<String, String> getSourceInformation(DatabaseSource databaseSource) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = databaseSource.getSourceType();
        String string2 = databaseSource.getName();
        String string3 = databaseSource.getSchemaName();
        if (string.equals("SYNONYM")) {
            List<List<String>> list = this.getSourceInformation(string3, string2);
            String string4 = "";
            for (List<String> list2 : list) {
                string2 = list2.get(0);
                string4 = list2.get(1);
                if (string4.equals(string3)) continue;
                string3 = string4;
            }
        }
        hashMap.put("OBJECT", string2);
        hashMap.put("OWNER", string3);
        return hashMap;
    }

    private List<List<String>> getSourceInformation(String string, String string2) {
        List<List<String>> list = new ArrayList<List<String>>();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("OWNER", string);
            hashMap.put("OBJECT", string2);
            list = this.executeQueryByName("GET_TABLE_FROM_SYNONYM", hashMap);
        }
        catch (Exception exception) {
            Logger.log(SourceMetadata.class, (Level)Level.SEVERE, (String)exception.getLocalizedMessage(), (Throwable)exception);
        }
        return list;
    }
}

