/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.source;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.hcs.actions.BaseRunnable;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.db.source.Synonym;
import oracle.hcs.db.source.Table;
import oracle.hcs.db.source.View;
import oracle.hcs.util.UIStringUtils;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class ColumnListRunnable
extends BaseRunnable {
    private OracleDatabaseImpl db;
    private Schema schema;
    private String tableNames;
    private List<DatabaseSource> sources;
    private final String GET_TABLE_NAMES_FROM_SYNONYM_LIST = "GET_TABLE_NAMES_FROM_SYNONYM_LIST";

    public ColumnListRunnable(OracleDatabaseImpl oracleDatabaseImpl, Schema schema, String string) {
        this.db = oracleDatabaseImpl;
        this.schema = schema;
        this.tableNames = string;
        this.sources = new ArrayList<DatabaseSource>();
    }

    public ColumnListRunnable(OracleDatabaseImpl oracleDatabaseImpl, List<DatabaseSource> list, Schema schema, String string) {
        this.db = oracleDatabaseImpl;
        this.schema = schema;
        this.tableNames = string;
        this.sources = new ArrayList<DatabaseSource>();
        if (list != null) {
            for (DatabaseSource databaseSource : list) {
                boolean bl = false;
                for (DatabaseSource databaseSource2 : this.sources) {
                    if (!databaseSource2.equals(databaseSource)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.sources.add(databaseSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.db.getConnection());
            if (this.tableNames == null || this.tableNames.length() == 0) {
                return;
            }
            String[] stringArray = this.tableNames.split(",");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("owner", this.schema.getName());
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                string = !string.contains("\"") ? string.toUpperCase() : string.replaceAll("\"", "");
                if (string.indexOf(".") == -1) {
                    string = String.format("%s.%s", this.schema.getName(), string);
                }
                if (string.contains("'")) {
                    stringBuffer.append("q'[" + string + "]'");
                } else {
                    stringBuffer.append("'" + string + "'");
                }
                stringBuffer.append(",");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
            }
            this.fetchSourceColumns(stringBuffer.toString(), true);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = false;
                for (DatabaseSource databaseSource : this.sources) {
                    if (!stringArray[i].equals(databaseSource.getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(stringArray[i]);
            }
            if (arrayList.size() > 0) {
                String string;
                String string2;
                String string3;
                Object object;
                StringBuffer stringBuffer2 = new StringBuffer();
                for (String string4 : arrayList) {
                    void var8_19;
                    void var8_17;
                    if (UIStringUtils.isQuotedName(string4)) {
                        String string5 = UIStringUtils.stripDoubleQuotes(string4);
                    }
                    if (var8_17.indexOf(".") == -1) {
                        String string6 = String.format("%s.%s", this.schema.getName(), var8_17);
                    }
                    stringBuffer2.append("'" + (String)var8_19 + "'");
                    stringBuffer2.append(",");
                }
                stringBuffer2.delete(stringBuffer2.length() - 1, stringBuffer2.length());
                SourceMetadata sourceMetadata = new SourceMetadata();
                String string8 = sourceMetadata.getQueries().getSQL("GET_TABLE_NAMES_FROM_SYNONYM_LIST");
                string8 = String.format(string8, stringBuffer2.toString());
                List list = dBUtil.executeReturnList(string8, null);
                stringBuffer = new StringBuffer();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                for (Object object2 : list) {
                    String string9 = (String)object2.get("OWNER");
                    object = (String)object2.get("SYNONYM_NAME");
                    string3 = (String)object2.get("TABLE_OWNER");
                    string2 = (String)object2.get("TABLE_NAME");
                    string = String.format("%s.%s", string9, object);
                    string2 = String.format("%s.%s", string3, string2);
                    hashMap2.put(string, string2);
                    stringBuffer.append("'" + string2 + "'");
                    stringBuffer.append(",");
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                }
                if (stringBuffer.length() > 0) {
                    List<DatabaseSource> list2 = this.fetchSourceColumns(stringBuffer.toString(), false);
                    for (String string9 : hashMap2.keySet()) {
                        object = new IdentifierElement(string9);
                        string3 = "";
                        string2 = "";
                        if (((IdentifierElement)object).getCount() == 2) {
                            string3 = ((IdentifierElement)object).getFirst();
                            string2 = ((IdentifierElement)object).getSecond();
                        }
                        string = (String)hashMap2.get(string9);
                        Iterator iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            DatabaseSource databaseSource = (DatabaseSource)iterator.next();
                            String string10 = String.format("%s.%s", databaseSource.getSchemaName(), databaseSource.getName());
                            if (!string10.equals(string)) continue;
                            databaseSource.setName(string2);
                            databaseSource.setSchemaName(string3);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            this.setException(exception);
        }
        finally {
            this.getProgressBar().setDoneStatus();
        }
    }

    private List<DatabaseSource> fetchSourceColumns(String string, boolean bl) throws SQLException {
        ArrayList<DatabaseSource> arrayList = new ArrayList<DatabaseSource>();
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.db.getConnection());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", this.schema.getName());
        SourceMetadata sourceMetadata = new SourceMetadata();
        String string2 = sourceMetadata.getQueries().getSQL("GET_COLUMNS_BY_OBJECTS_ALL");
        string2 = String.format(string2, string);
        List list = dBUtil.executeReturnList(string2, hashMap);
        DatabaseSource object = null;
        ArrayList<Column> arrayList2 = new ArrayList<Column>();
        for (Map map : list) {
            String string3 = (String)map.get("OWNER");
            String string4 = (String)map.get("TABLE_NAME");
            String string5 = (String)map.get("OBJECT_TYPE");
            boolean bl2 = false;
            for (DatabaseSource databaseSource : this.sources) {
                if (!databaseSource.getSchemaName().equals(string3) || !databaseSource.getName().equals(string4)) continue;
                object = databaseSource;
                bl2 = true;
                break;
            }
            if (!bl2) {
                if (object != null) {
                    object.setColumns(arrayList2.toArray(new Column[arrayList2.size()]));
                }
                object = bl ? (string5.equalsIgnoreCase("TABLE") ? new Table(string3, string4, null) : new View(string3, string4, null)) : new Synonym(string3, string4, null);
                this.sources.add(object);
                arrayList.add(object);
                arrayList2 = new ArrayList();
            }
            String string6 = (String)map.get("COLUMN_NAME");
            String object22 = (String)map.get("NULLABLE");
            String string7 = (String)map.get("DATA_TYPE");
            Column column = new Column(string6, object22, string7);
            arrayList2.add(column);
        }
        if (object != null) {
            object.setColumns(arrayList2.toArray(new Column[arrayList2.size()]));
        }
        return arrayList;
    }

    public List<DatabaseSource> getSources() {
        return this.sources;
    }
}

